package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class ResultLabSamplePrepPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowByResUid;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public ResultLabSamplePrepPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call result_lab_sample_prep_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_rlsprp_uid

    // DELETE ROW BY RES UID
    _csDeleteRowByResUid = (OracleCallableStatement) _connection.prepareCall(
      "{call result_lab_sample_prep_pkg.delete_row_by_res_uid(?, ?)}");
    _csDeleteRowByResUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowByResUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_res_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call result_lab_sample_prep_pkg.insert_row(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_res_uid
    _csInsertRow.defineParameterType(3, OracleTypes.DATE, 0); // p_rlsprp_end_date
    _csInsertRow.defineParameterType(4, OracleTypes.DATE, 0); // p_rlsprp_end_time
    _csInsertRow.defineParameterType(5, OracleTypes.VARCHAR, 120); // p_rlsprp_method_context
    _csInsertRow.defineParameterType(6, OracleTypes.VARCHAR, 500); // p_rlsprp_method_desc
    _csInsertRow.defineParameterType(7, OracleTypes.VARCHAR, 20); // p_rlsprp_method_id
    _csInsertRow.defineParameterType(8, OracleTypes.VARCHAR, 120); // p_rlsprp_method_name
    _csInsertRow.defineParameterType(9, OracleTypes.VARCHAR, 25); // p_rlsprp_method_qual_type
    _csInsertRow.defineParameterType(10, OracleTypes.DATE, 0); // p_rlsprp_start_date
    _csInsertRow.defineParameterType(11, OracleTypes.DATE, 0); // p_rlsprp_start_time
    _csInsertRow.defineParameterType(12, OracleTypes.NUMBER, 6); // p_tmzone_uid_end_time
    _csInsertRow.defineParameterType(13, OracleTypes.NUMBER, 6); // p_tmzone_uid_start_time
    _csInsertRow.registerOutParameter(14, OracleTypes.NUMBER, 20); // p_rlsprp_uid
  }


  public void deleteRow (  
      String context,
      String rlsprpUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, rlsprpUid);
    _csDeleteRow.execute();
  }


  public void deleteRowByResUid (  
      String context,
      String resUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowByResUid.setString(1, context);
    _csDeleteRowByResUid.setString(2, resUid);
    _csDeleteRowByResUid.execute();
  }


  public String insertRow (  
      String context,
      String resUid,
      Date rlsprpEndDate,
      Time rlsprpEndTime,
      String rlsprpMethodContext,
      String rlsprpMethodDesc,
      String rlsprpMethodId,
      String rlsprpMethodName,
      String rlsprpMethodQualType,
      Date rlsprpStartDate,
      Time rlsprpStartTime,
      String tmzoneUidEndTime,
      String tmzoneUidStartTime)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, resUid);
    _csInsertRow.setDate(3, rlsprpEndDate);
    _csInsertRow.setTime(4, rlsprpEndTime);
    _csInsertRow.setString(5, rlsprpMethodContext);
    _csInsertRow.setString(6, rlsprpMethodDesc);
    _csInsertRow.setString(7, rlsprpMethodId);
    _csInsertRow.setString(8, rlsprpMethodName);
    _csInsertRow.setString(9, rlsprpMethodQualType);
    _csInsertRow.setDate(10, rlsprpStartDate);
    _csInsertRow.setTime(11, rlsprpStartTime);
    _csInsertRow.setString(12, tmzoneUidEndTime);
    _csInsertRow.setString(13, tmzoneUidStartTime);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(14);
  }

}