package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class ResultPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowsByActUid;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public ResultPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call result_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_res_uid

    // DELETE ROWS BY ACT UID
    _csDeleteRowsByActUid = (OracleCallableStatement) _connection.prepareCall(
      "{call result_pkg.delete_rows_by_act_uid(?, ?)}");
    _csDeleteRowsByActUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByActUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_act_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call result_pkg.insert_row(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_act_uid
    _csInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 120); // p_chr_name
    _csInsertRow.defineParameterType(4, OracleTypes.VARCHAR, 12); // p_msunt_cd_dpth_ht
    _csInsertRow.defineParameterType(5, OracleTypes.VARCHAR, 12); // p_msunt_cd_measure
    _csInsertRow.defineParameterType(6, OracleTypes.VARCHAR, 50); // p_rdcnd_name
    _csInsertRow.defineParameterType(7, OracleTypes.NUMBER, 6); // p_anlmth_uid
    _csInsertRow.defineParameterType(8, OracleTypes.VARCHAR, 60); // p_res_measure_bias
    _csInsertRow.defineParameterType(9, OracleTypes.VARCHAR, 4000); // p_res_comments
    _csInsertRow.defineParameterType(10, OracleTypes.VARCHAR, 15); // p_res_data_logger_line
    _csInsertRow.defineParameterType(11, OracleTypes.VARCHAR, 12); // p_res_depth_height
    _csInsertRow.defineParameterType(12, OracleTypes.VARCHAR, 125); // p_res_depth_altitude_ref_point
    _csInsertRow.defineParameterType(13, OracleTypes.DATE, 0); // p_res_lab_analysis_start_date
    _csInsertRow.defineParameterType(14, OracleTypes.DATE, 0); // p_res_lab_analysis_start_time
    _csInsertRow.defineParameterType(15, OracleTypes.DATE, 0); // p_res_lab_analysis_end_date
    _csInsertRow.defineParameterType(16, OracleTypes.DATE, 0); // p_res_lab_analysis_end_time
    _csInsertRow.defineParameterType(17, OracleTypes.VARCHAR, 5); // p_tmzone_cd_lab_start
    _csInsertRow.defineParameterType(18, OracleTypes.VARCHAR, 5); // p_tmzone_cd_lab_end
    _csInsertRow.defineParameterType(19, OracleTypes.VARCHAR, 60); // p_res_lab_name
    _csInsertRow.defineParameterType(20, OracleTypes.VARCHAR, 15); // p_res_particle_size_basis
    _csInsertRow.defineParameterType(21, OracleTypes.VARCHAR, 60); // p_res_measure
    _csInsertRow.defineParameterType(22, OracleTypes.VARCHAR, 15); // p_res_measure_conf_interval
    _csInsertRow.defineParameterType(23, OracleTypes.VARCHAR, 60); // p_res_measure_precision
    _csInsertRow.defineParameterType(24, OracleTypes.VARCHAR, 15); // p_res_measure_lower_conf_limit
    _csInsertRow.defineParameterType(25, OracleTypes.VARCHAR, 15); // p_res_measure_upper_conf_limit
    _csInsertRow.defineParameterType(26, OracleTypes.VARCHAR, 3); // p_rlcom_cd
    _csInsertRow.defineParameterType(27, OracleTypes.VARCHAR, 5); // p_rmqlf_cd
    _csInsertRow.defineParameterType(28, OracleTypes.VARCHAR, 25); // p_rsbas_cd
    _csInsertRow.defineParameterType(29, OracleTypes.VARCHAR, 12); // p_ressta_name
    _csInsertRow.defineParameterType(30, OracleTypes.VARCHAR, 12); // p_rtimb_name
    _csInsertRow.defineParameterType(31, OracleTypes.VARCHAR, 12); // p_rtmpb_name
    _csInsertRow.defineParameterType(32, OracleTypes.VARCHAR, 12); // p_rvtyp_name
    _csInsertRow.defineParameterType(33, OracleTypes.VARCHAR, 15); // p_rwbas_name
    _csInsertRow.defineParameterType(34, OracleTypes.VARCHAR, 25); // p_smfrc_name
    _csInsertRow.registerOutParameter(35, OracleTypes.NUMBER, 20); // p_res_uid
  }


  public void deleteRow (  
      String context,
      String resUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, resUid);
    _csDeleteRow.execute();
  }


  public void deleteRowsByActUid (  
      String context,
      String actUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByActUid.setString(1, context);
    _csDeleteRowsByActUid.setString(2, actUid);
    _csDeleteRowsByActUid.execute();
  }


  public String insertRow (  
      String context,
      String actUid,
      String chrName,
      String msuntCdDpthHt,
      String msuntCdMeasure,
      String rdcndName,
      String anlmthUid,
      String resMeasureBias,
      String resComments,
      String resDataLoggerLine,
      String resDepthHeight,
      String resDepthAltitudeRefPoint,
      Date resLabAnalysisStartDate,
      Time resLabAnalysisStartTime,
      Date resLabAnalysisEndDate,
      Time resLabAnalysisEndTime,
      String tmzoneCdLabStart,
      String tmzoneCdLabEnd,
      String resLabName,
      String resParticleSizeBasis,
      String resMeasure,
      String resMeasureConfInterval,
      String resMeasurePrecision,
      String resMeasureLowerConfLimit,
      String resMeasureUpperConfLimit,
      String rlcomCd,
      String rmqlfCd,
      String rsbasCd,
      String resstaName,
      String rtimbName,
      String rtmpbName,
      String rvtypName,
      String rwbasName,
      String smfrcName)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, actUid);
    _csInsertRow.setString(3, chrName);
    _csInsertRow.setString(4, msuntCdDpthHt);
    _csInsertRow.setString(5, msuntCdMeasure);
    _csInsertRow.setString(6, rdcndName);
    _csInsertRow.setString(7, anlmthUid);
    _csInsertRow.setString(8, resMeasureBias);
    _csInsertRow.setString(9, resComments);
    _csInsertRow.setString(10, resDataLoggerLine);
    _csInsertRow.setString(11, resDepthHeight);
    _csInsertRow.setString(12, resDepthAltitudeRefPoint);
    _csInsertRow.setDate(13, resLabAnalysisStartDate);
    _csInsertRow.setTime(14, resLabAnalysisStartTime);
    _csInsertRow.setDate(15, resLabAnalysisEndDate);
    _csInsertRow.setTime(16, resLabAnalysisEndTime);
    _csInsertRow.setString(17, tmzoneCdLabStart);
    _csInsertRow.setString(18, tmzoneCdLabEnd);
    _csInsertRow.setString(19, resLabName);
    _csInsertRow.setString(20, resParticleSizeBasis);
    _csInsertRow.setString(21, resMeasure);
    _csInsertRow.setString(22, resMeasureConfInterval);
    _csInsertRow.setString(23, resMeasurePrecision);
    _csInsertRow.setString(24, resMeasureLowerConfLimit);
    _csInsertRow.setString(25, resMeasureUpperConfLimit);
    _csInsertRow.setString(26, rlcomCd);
    _csInsertRow.setString(27, rmqlfCd);
    _csInsertRow.setString(28, rsbasCd);
    _csInsertRow.setString(29, resstaName);
    _csInsertRow.setString(30, rtimbName);
    _csInsertRow.setString(31, rtmpbName);
    _csInsertRow.setString(32, rvtypName);
    _csInsertRow.setString(33, rwbasName);
    _csInsertRow.setString(34, smfrcName);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(35);
  }

}