package gov.epa.wqx.node;

import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.NodeDocumentContentConverter;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.zip.ZipUtil;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.ws.logic.WSNodeManager;
import gov.epa.wqx.node.Lib;
import gov.epa.wqx.node.Query;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import java.lang.ClassNotFoundException;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.naming.NamingException;

import oracle.jdbc.OracleConnection;

public class SolicitThread implements Runnable {
  
  private QueryVO _queryVO;
  private OracleConnection  _connection;
  private TransactionLog _transactionLog;
      
  
  public SolicitThread(QueryVO queryVO) {
    try {
      _queryVO = queryVO;
      _connection = Lib.getWqxConnection();
      _transactionLog = new TransactionLog(_connection);
    }
    catch(Exception exception) {
      Lib.log.error(exception);
    }
  }
    

  public void run() {
    
    String            transactionId = null;
    String[]          params = null;
    String            request = null;
    String            logOther = null; 
    String            workingPath = null;
    FileOutputStream  fileOut = null;
    Lib.log.info("******** SolicitThread.run() - Start ********");
    try {
      // CDX uses the ReturnURL parameter to pass the Transaction ID
      transactionId = _queryVO.getReturnURL();
      request = this._queryVO.getServiceName();
      //Get the application Directory from OC4J
      workingPath = Lib.getWorkingDirectory();
      byte[] result = null;
      params = _queryVO.getParameters();
      Query query = new Query(_connection, Constant.TRTYP_SOLICIT);
      _transactionLog.setTransactionId(transactionId);
      _transactionLog.setType(Constant.TRTYP_SOLICIT);
      _transactionLog.setStartTime(new Timestamp(System.currentTimeMillis()));
      if (request.equalsIgnoreCase("WQX.GetDomainValueByElementName_v1.0")) {
        logOther = "Request="+request+";elementName="+params[0];        
        _transactionLog.setComments(logOther);
        _transactionLog.setUserNaasId(params[1]);
        _transactionLog.save();
        result = query.getDomainValues(params[0], params[1]);                          
      }
      else if (request.equalsIgnoreCase("WQX.GetTransactionHistoryByParameters_v1.0")) {
        logOther = "Request="+request+";organizationIdentifier="+params[0]
                   +";userIdentifier="+params[1]+";transactionIdentifier="+params[2]
                   +"transactionDateBegin="+params[3]+";transactionDateEnd="+params[4];
        _transactionLog.setComments(logOther);
        _transactionLog.setOrganizationId(params[0]);
        _transactionLog.setUserNaasId(params[5]);
        _transactionLog.save();        
        result = query.getTransactionHistory(
          params[0],
          params[1],
          params[2],
          params[3],
          params[4],
          params[5]);
      }
      else if (request.equalsIgnoreCase("WQX.GetProjectByParameters_v1.0")) {
        logOther = "Request="+request+";organizationIdentifier="+params[0]
                   +";projectIdentifier="+params[1];
        _transactionLog.setComments(logOther);
        _transactionLog.setOrganizationId(params[0]);
        _transactionLog.setUserNaasId(params[2]);
        _transactionLog.save();
        result = query.getProject(params[0], params[1], params[2]);
      }
      else if (request.equalsIgnoreCase("WQX.GetMonitoringLocationByParameters_v1.0")) {
        logOther = "Request="+request+";organizationIdentifier="+params[0]
                   +";monitoringLocationIdentifier=" + params[1];
        _transactionLog.setComments(logOther);
        _transactionLog.setOrganizationId(params[0]);
        _transactionLog.setUserNaasId(params[2]);
        _transactionLog.save();        
        result = query.getMonitoringLocation(params[0], params[1], params[2]);
      }
      else if (request.equalsIgnoreCase("WQX.GetActivityByParameters_v1.0")) {
        logOther = "Request="+request+";organizationIdentifier="+params[0]
                   +";monitoringLocationIdentifier="+params[1]
                   +";projectIdentifier="+params[2]+";activityStartDateBegin="+params[3]
                   +";activityStartDateEnd="+params[4]+";activityIdentifier="+params[5];
        _transactionLog.setComments(logOther);
        _transactionLog.setOrganizationId(params[0]);
        _transactionLog.setUserNaasId(params[6]);
        _transactionLog.save();
        result = query.getActivity(params[0],params[1],params[2],params[3],params[4],params[5],params[6]);
      }
      else if (request.equalsIgnoreCase("WQX.GetResultByParameters_v1.0")) {
        logOther = "Request="+request+";organizationIdentifier="+params[0]
                   +";monitoringLocationIdentifier="+params[1]
                   +";projectIdentifier="+params[2]+";activityStartDateBegin="+params[3]
                   +";activityStartDateEnd="+params[4]+";activityIdentifier="+params[5];
        _transactionLog.setComments(logOther);
        _transactionLog.setOrganizationId(params[0]);
        _transactionLog.setUserNaasId(params[6]);
        _transactionLog.save();
        result = query.getResult(
          params[0],
          params[1],
          params[2],
          params[3],
          params[4],
          params[5],
          params[6]);
      }
      else if(request.equalsIgnoreCase("WQX.GetActivityGroupByParameters_v1.0")) {
        logOther = "Request="+request+";organizationIdentifier="+params[0]
                   +";activityGroupTypeCode="+params[1]
                   +";activityGroupIdentifier="+params[2];
        _transactionLog.setOrganizationId(params[0]);
        _transactionLog.setUserNaasId(params[3]);
        _transactionLog.setComments(logOther);
        _transactionLog.save();
        result = query.getActivityGroup(
          params[0], 
          params[1], 
          params[2], 
          params[3]);
      }
      else {
        throw new WqxException("The request " + request + " is not valid.", null);
      }
      zipSolicitFile(result, workingPath, transactionId);
      _transactionLog.end(new Timestamp(System.currentTimeMillis()));
    }
    catch (Exception exception) {
      try {
        _transactionLog.logError(exception);
        if (_transactionLog.getCount() > 0) {
          _transactionLog.end(new Timestamp(System.currentTimeMillis()));
        }
      }
      catch (WqxFatalException fatalException) {
        exception = fatalException;
      }
      if (Lib.allowTwoWayCommunication()) {
        //Make NodeDocument which can be sent to notify
        String transId = _queryVO.getReturnURL();
        String errorMessage;
        if (exception instanceof WqxFatalException) {
          errorMessage = "Fatal Error (please notify CDX Help Desk): " + exception.getMessage();
        }
        else {
          errorMessage = exception.getMessage();
        }
        if (exception.getCause() != null) {
          errorMessage.concat("\n  Original Error: " + exception.getCause().getMessage()
            + "\n  Stack Trace: " + Lib.getSimplifiedStackTrace(exception, false));
        }
        byte[] content = Lib.getNotifyXML(
          "Failed",
          "Solicit",
          new Timestamp(System.currentTimeMillis()),
          transactionId,
          errorMessage).getBytes();
        NodeDocument nodeDoc = new NodeDocument();
        nodeDoc.putContent(content, NodeDocumentContentConverter.CONTENT_TYPE_BYTES);
        nodeDoc.setName(transId);
        nodeDoc.setType("XML");
        String urlEndpoint = CDXPropertyManager.getProperty("Solicit", "NotifyURL");
        WSNodeManager.callCdxNotify(transId, nodeDoc, urlEndpoint);
      }
    }
    finally {
      try {
        Lib.log.info("******** SolicitThread.run() - End ********");
        if(_connection != null) {
          _connection.commit();
          _connection.close();
        }
      }
      catch(SQLException sqlException) {
        Lib.log.error(sqlException);
      }
    }
  }
  
  
  public void zipSolicitFile(byte[] result, String path, String transactionId)
      throws FileNotFoundException, IOException, WqxException {
    
    // Create a zip file with query results to be sent to CDX
    String zipFilePath = path + transactionId + "_Results.zip";
    ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFilePath));
    ZipEntry entry = new ZipEntry("Results.xml");
    zipOutputStream.putNextEntry(entry);
    zipOutputStream.write(result, 0, result.length);
    zipOutputStream.closeEntry();
    zipOutputStream.close();
    // Retrieve zip file into array of bytes
    File zipFile = new File(zipFilePath);
    int fileLength = (int)zipFile.length();
    FileInputStream zipInputStream = new FileInputStream(zipFile);
    byte[] zipFileBytes = new byte[fileLength];
    int bytesRead = zipInputStream.read(zipFileBytes, 0, fileLength);
    zipInputStream.close();
    //Make NodeDocument which can be sent to CDX Submit
    NodeDocument nodeDoc = new NodeDocument();
    nodeDoc.putContent(zipFileBytes, NodeDocumentContentConverter.CONTENT_TYPE_BYTES);
    nodeDoc.setName("Results.zip");
    nodeDoc.setType("ZIP");
    if (Lib.allowTwoWayCommunication()) {
      WSNodeManager.callCdxSubmit(transactionId, nodeDoc);
      try {
        zipFile.delete();
        Lib.log.debug("Deleted Solicit Results file " + zipFile.getName());
      }
      catch (Exception e) {
        Lib.log.error("Error Deleting Solicit Results file " + zipFile.getName(), e);
      }
    }
  }
}  