package gov.epa.wqx.node;

import java.io.FileReader;
import java.io.IOException;

import java.sql.SQLException;

import oracle.jdbc.pool.OracleDataSource;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

//import org.apache.xerces.parsers.SAXParser;
//import org.apache.crimson.parser.*;

public class TestWorkerThread {
  
  public void parseDocument(
      String docPath,
      String docName, 
      String transactionId) 
      
      throws Exception, IOException, SAXException {
      
    WqxSaxHandler handler = null;
    try {
      // create instance of this object
      handler = new WqxSaxHandler(
        docPath,
        docName,
        transactionId);    
      //XMLReader reader = new XMLReaderImpl();
      XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
      reader.setContentHandler(handler);
      reader.setErrorHandler(handler);
      // Create an input source that points to the file to parse.
      InputSource input = new InputSource(new FileReader(docPath + Lib.getFileSeparator() + docName));
      Lib.log.debug("Begin Parsing");
      // Parse and Load the submission file
      reader.parse(input);
      Lib.log.debug("End Parsing");
    } 
    catch (Exception e) {
      Lib.log.error(e);
    }
    finally {
      // Get the processing report and then call notify
      if (handler != null) {
        //Lib.log.debug(handler.getProcessingReport());
        handler.done();
      }
    }		
  }


  public static void main(String[] args) {
    String filePath = "D:\\My Documents\\Env\\WQX\\Test";
    String fileName = "DeleteKATTEST_All.xml";
    try { 
      Lib.log.info("Test Worker Thread Started");
      Lib.log.info(fileName);
      Lib.setDataSourceInfo("jdbc:oracle:thin:@10.0.0.28:1521:sldev10","wqx","wqx");
      TestWorkerThread thread = new TestWorkerThread();
      thread.parseDocument(filePath, fileName, "123SDF2342SDF2lsdf2");
    }
    catch (Exception e) {
      Lib.log.error(e);
    }
    System.exit(0);
  }
  
  
}