package gov.epa.wqx.node;

import java.sql.SQLException;
import java.sql.Timestamp;

import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

import oracle.sql.TIMESTAMPTZ;

public class TransactionLogPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csEndTransaction;
  private OracleCallableStatement _csGetErrorCount;
  private OracleCallableStatement _csGetTrlogUid;
  private OracleCallableStatement _csInsertAudit;
  private OracleCallableStatement _csInsertError;
  private OracleCallableStatement _csInsertMessage;
  private OracleCallableStatement _csInsertWarning;
  private OracleCallableStatement _csStartTransaction;
  private OracleCallableStatement _csUpdateAuditPending;

  // constructor  
  public TransactionLogPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // END TRANSACTION
    _csEndTransaction = (OracleCallableStatement) _connection.prepareCall(
      "{? = call transaction_log_pkg.end_transaction(?, ?)}");
    _csEndTransaction.registerOutParameter(1, OracleTypes.NUMBER, 6); // return value
    _csEndTransaction.defineParameterType(2, OracleTypes.VARCHAR, 500); // p_context
    _csEndTransaction.defineParameterType(3, OracleTypes.TIMESTAMP, 6); // p_end_time

    // GET ERROR COUNT
    _csGetErrorCount = (OracleCallableStatement) _connection.prepareCall(
      "{? = call transaction_log_pkg.get_error_count()}");
    _csGetErrorCount.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value

    // GET TRLOG UID
    _csGetTrlogUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call transaction_log_pkg.get_trlog_uid(?)}");
    _csGetTrlogUid.registerOutParameter(1, OracleTypes.NUMBER, 20); // return value
    _csGetTrlogUid.defineParameterType(2, OracleTypes.VARCHAR, 100); // p_trlog_trans_id

    // INSERT AUDIT
    _csInsertAudit = (OracleCallableStatement) _connection.prepareCall(
      "{? = call transaction_log_pkg.insert_audit(?, ?, ?, ?, ?)}");
    _csInsertAudit.registerOutParameter(1, OracleTypes.NUMBER, 20); // return value
    _csInsertAudit.defineParameterType(2, OracleTypes.NUMBER, 6); // p_audtyp_uid
    _csInsertAudit.defineParameterType(3, OracleTypes.NUMBER, 6); // p_tbl_uid
    _csInsertAudit.defineParameterType(4, OracleTypes.NUMBER, 20); // p_ref_uid
    _csInsertAudit.defineParameterType(5, OracleTypes.VARCHAR, 35); // p_ref_id
    _csInsertAudit.defineParameterType(6, OracleTypes.VARCHAR, 1); // p_tlaud_success_yn

    // INSERT ERROR
    _csInsertError = (OracleCallableStatement) _connection.prepareCall(
      "{call transaction_log_pkg.insert_error(?, ?, ?)}");
    _csInsertError.defineParameterType(1, OracleTypes.VARCHAR, 4000); // p_tldet_msg
    _csInsertError.defineParameterType(2, OracleTypes.VARCHAR, 500); // p_tldet_source
    _csInsertError.defineParameterType(3, OracleTypes.VARCHAR, 1000); // p_tldet_context

    // INSERT MESSAGE
    _csInsertMessage = (OracleCallableStatement) _connection.prepareCall(
      "{call transaction_log_pkg.insert_message(?)}");
    _csInsertMessage.defineParameterType(1, OracleTypes.VARCHAR, 4000); // p_tldet_msg

    // INSERT WARNING
    _csInsertWarning = (OracleCallableStatement) _connection.prepareCall(
      "{call transaction_log_pkg.insert_warning(?, ?)}");
    _csInsertWarning.defineParameterType(1, OracleTypes.VARCHAR, 4000); // p_tldet_msg
    _csInsertWarning.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_tldet_context

    // START TRANSACTION
    _csStartTransaction = (OracleCallableStatement) _connection.prepareCall(
      "{call transaction_log_pkg.start_transaction(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
    _csStartTransaction.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csStartTransaction.defineParameterType(2, OracleTypes.VARCHAR, 30); // p_org_id
    _csStartTransaction.defineParameterType(3, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csStartTransaction.defineParameterType(4, OracleTypes.VARCHAR, 100); // p_usr_naas_id
    _csStartTransaction.defineParameterType(5, OracleTypes.VARCHAR, 100); // p_trlog_trans_id
    _csStartTransaction.defineParameterType(6, OracleTypes.VARCHAR, 100); // p_trlog_doc_id
    _csStartTransaction.defineParameterType(7, OracleTypes.VARCHAR, 500); // p_trlog_other
    _csStartTransaction.defineParameterType(8, OracleTypes.VARCHAR, 100); // p_trhead_author
    _csStartTransaction.defineParameterType(9, OracleTypes.VARCHAR, 1000); // p_trhead_comment
    _csStartTransaction.defineParameterType(10, OracleTypes.VARCHAR, 300); // p_trhead_contact_info
    _csStartTransaction.defineParameterType(11, OracleTypes.TIMESTAMPTZ, 0); // p_trhead_creation_time
    _csStartTransaction.defineParameterType(12, OracleTypes.VARCHAR, 40); // p_trhead_id
    _csStartTransaction.defineParameterType(13, OracleTypes.VARCHAR, 20); // p_trhead_operation
    _csStartTransaction.defineParameterType(14, OracleTypes.VARCHAR, 100); // p_trhead_org_name
    _csStartTransaction.defineParameterType(15, OracleTypes.VARCHAR, 40); // p_trhead_schema_ref
    _csStartTransaction.defineParameterType(16, OracleTypes.VARCHAR, 100); // p_trhead_title
    _csStartTransaction.defineParameterType(17, OracleTypes.TIMESTAMP, 6); // p_trlog_start_time
    _csStartTransaction.registerOutParameter(18, OracleTypes.NUMBER, 20); // p_trlog_uid

    // UPDATE AUDIT PENDING
    _csUpdateAuditPending = (OracleCallableStatement) _connection.prepareCall(
      "{call transaction_log_pkg.update_audit_pending(?)}");
    _csUpdateAuditPending.defineParameterType(1, OracleTypes.VARCHAR, 1); // p_tlaud_success_yn
  }


  public int endTransaction (  
      String context,
      Timestamp endTime)

      throws SQLException {

    // set parameter values and call procedure
    _csEndTransaction.setString(2, context);
    _csEndTransaction.setTimestamp(3, endTime);
    _csEndTransaction.execute();
    // get out parameters and/or return value
    return _csEndTransaction.getInt(1);
  }

  public int getErrorCount (  )

      throws SQLException {

    // set parameter values and call procedure
    _csGetErrorCount.execute();
    // get out parameters and/or return value
    return _csGetErrorCount.getInt(1);
  }

  public String getTrlogUid (  
      String trlogTransId)

      throws SQLException {

    // set parameter values and call procedure
    _csGetTrlogUid.setString(2, trlogTransId);
    _csGetTrlogUid.execute();
    // get out parameters and/or return value
    return _csGetTrlogUid.getString(1);
  }

  public String insertAudit (  
      String audtypUid,
      String tblUid,
      String refUid,
      String refId,
      String tlaudSuccessYn)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertAudit.setString(2, audtypUid);
    _csInsertAudit.setString(3, tblUid);
    _csInsertAudit.setString(4, refUid);
    _csInsertAudit.setString(5, refId);
    _csInsertAudit.setString(6, tlaudSuccessYn);
    _csInsertAudit.execute();
    // get out parameters and/or return value
    return _csInsertAudit.getString(1);
  }

  public void insertError (  
      String tldetMsg,
      String tldetSource,
      String tldetContext)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertError.setString(1, tldetMsg);
    _csInsertError.setString(2, tldetSource);
    _csInsertError.setString(3, tldetContext);
    _csInsertError.execute();
  }


  public void insertMessage (  
      String tldetMsg)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertMessage.setString(1, tldetMsg);
    _csInsertMessage.execute();
  }


  public void insertWarning (  
      String tldetMsg,
      String tldetContext)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertWarning.setString(1, tldetMsg);
    _csInsertWarning.setString(2, tldetContext);
    _csInsertWarning.execute();
  }


  public String startTransaction (  
      String context,
      String orgId,
      int trtypUid,
      String usrNaasId,
      String trlogTransId,
      String trlogDocId,
      String trlogOther,
      String trheadAuthor,
      String trheadComment,
      String trheadContactInfo,
      Timestamp trheadCreationTime,
      String trheadId,
      String trheadOperation,
      String trheadOrgName,
      String trheadSchemaRef,
      String trheadTitle,
      Timestamp trlogStartTime)

      throws SQLException {

    // set parameter values and call procedure
    _csStartTransaction.setString(1, context);
    _csStartTransaction.setString(2, orgId);
    _csStartTransaction.setInt(3, trtypUid);
    _csStartTransaction.setString(4, usrNaasId);
    _csStartTransaction.setString(5, trlogTransId);
    _csStartTransaction.setString(6, trlogDocId);
    _csStartTransaction.setString(7, trlogOther);
    _csStartTransaction.setString(8, trheadAuthor);
    _csStartTransaction.setString(9, trheadComment);
    _csStartTransaction.setString(10, trheadContactInfo);
    _csStartTransaction.setTimestamp(11, trheadCreationTime);
    _csStartTransaction.setString(12, trheadId);
    _csStartTransaction.setString(13, trheadOperation);
    _csStartTransaction.setString(14, trheadOrgName);
    _csStartTransaction.setString(15, trheadSchemaRef);
    _csStartTransaction.setString(16, trheadTitle);
    _csStartTransaction.setTimestamp(17, trlogStartTime);
    _csStartTransaction.execute();
    // get out parameters and/or return value
    return _csStartTransaction.getString(18);
  }

  public void updateAuditPending (  
      String tlaudSuccessYn)

      throws SQLException {

    // set parameter values and call procedure
    _csUpdateAuditPending.setString(1, tlaudSuccessYn);
    _csUpdateAuditPending.execute();
  }


}