package gov.epa.wqx.node;

public class WqxException extends Exception {

  protected String _context;
  protected boolean _logged = false;

  public WqxException (Throwable cause) {
    super(cause);
  }
  
  
  public WqxException (Throwable cause, String context) {
    super(cause);
    _context = context;
  }
  
  
  public WqxException (String message, String context) {
    super(message);
    _context = context;
  }
  
  
  public WqxException (String message, Throwable cause, String context) {
    super(message, cause);
    _context = context;
  }
  
  
  public void setContext(String context) {
    _context = context;
  }


  public String getContext() {
    return _context;
  }


  public void setLogged(boolean logged) {
    _logged = logged;
  }


  public boolean isLogged() {
    return _logged;
  }
    
};
