package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class XmlQueryPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csGetActivity;
  private OracleCallableStatement _csGetActivityGroup;
  private OracleCallableStatement _csGetDomainValues;
  private OracleCallableStatement _csGetMonitoringLocation;
  private OracleCallableStatement _csGetProcessingReport;
  private OracleCallableStatement _csGetProject;
  private OracleCallableStatement _csGetResult;
  private OracleCallableStatement _csGetTransactionHistory;

  // constructor  
  public XmlQueryPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // GET ACTIVITY
    _csGetActivity = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_activity(?, ?, ?, ?, ?, ?, ?, ?)}");
    _csGetActivity.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetActivity.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetActivity.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_org_id
    _csGetActivity.defineParameterType(4, OracleTypes.VARCHAR, 35); // p_mloc_id
    _csGetActivity.defineParameterType(5, OracleTypes.VARCHAR, 35); // p_prj_id
    _csGetActivity.defineParameterType(6, OracleTypes.VARCHAR, 35); // p_act_id
    _csGetActivity.defineParameterType(7, OracleTypes.DATE, 0); // p_act_start_date_begin
    _csGetActivity.defineParameterType(8, OracleTypes.DATE, 0); // p_act_start_date_end
    _csGetActivity.defineParameterType(9, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx

    // GET ACTIVITY GROUP
    _csGetActivityGroup = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_activity_group(?, ?, ?, ?, ?)}");
    _csGetActivityGroup.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetActivityGroup.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetActivityGroup.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_org_id
    _csGetActivityGroup.defineParameterType(4, OracleTypes.VARCHAR, 50); // p_agtyp_name
    _csGetActivityGroup.defineParameterType(5, OracleTypes.VARCHAR, 35); // p_actgrp_id
    _csGetActivityGroup.defineParameterType(6, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx

    // GET DOMAIN VALUES
    _csGetDomainValues = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_domain_values(?, ?, ?)}");
    _csGetDomainValues.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetDomainValues.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetDomainValues.defineParameterType(3, OracleTypes.VARCHAR, 60); // p_element_name
    _csGetDomainValues.defineParameterType(4, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx

    // GET MONITORING LOCATION
    _csGetMonitoringLocation = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_monitoring_location(?, ?, ?, ?)}");
    _csGetMonitoringLocation.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetMonitoringLocation.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetMonitoringLocation.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_org_id
    _csGetMonitoringLocation.defineParameterType(4, OracleTypes.VARCHAR, 35); // p_mloc_id
    _csGetMonitoringLocation.defineParameterType(5, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx

    // GET PROCESSING REPORT
    _csGetProcessingReport = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_processing_report(?, ?)}");
    _csGetProcessingReport.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetProcessingReport.defineParameterType(2, OracleTypes.NUMBER, 20); // p_trlog_uid
    _csGetProcessingReport.defineParameterType(3, OracleTypes.VARCHAR, 10); // p_wqx_node_version

    // GET PROJECT
    _csGetProject = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_project(?, ?, ?, ?)}");
    _csGetProject.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetProject.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetProject.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_org_id
    _csGetProject.defineParameterType(4, OracleTypes.VARCHAR, 35); // p_prj_id
    _csGetProject.defineParameterType(5, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx

    // GET RESULT
    _csGetResult = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_result(?, ?, ?, ?, ?, ?, ?, ?)}");
    _csGetResult.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetResult.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetResult.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_org_id
    _csGetResult.defineParameterType(4, OracleTypes.VARCHAR, 35); // p_mloc_id
    _csGetResult.defineParameterType(5, OracleTypes.VARCHAR, 35); // p_prj_id
    _csGetResult.defineParameterType(6, OracleTypes.VARCHAR, 35); // p_act_id
    _csGetResult.defineParameterType(7, OracleTypes.DATE, 0); // p_act_start_date_begin
    _csGetResult.defineParameterType(8, OracleTypes.DATE, 0); // p_act_start_date_end
    _csGetResult.defineParameterType(9, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx

    // GET TRANSACTION HISTORY
    _csGetTransactionHistory = (OracleCallableStatement) _connection.prepareCall(
      "{? = call xml_query_pkg.get_transaction_history(?, ?, ?, ?, ?, ?, ?)}");
    _csGetTransactionHistory.registerOutParameter(1, OracleTypes.CLOB, 0); // return value
    _csGetTransactionHistory.defineParameterType(2, OracleTypes.NUMBER, 6); // p_trtyp_uid
    _csGetTransactionHistory.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_org_id
    _csGetTransactionHistory.defineParameterType(4, OracleTypes.VARCHAR, 100); // p_usr_naas_id
    _csGetTransactionHistory.defineParameterType(5, OracleTypes.VARCHAR, 100); // p_trlog_trans_id
    _csGetTransactionHistory.defineParameterType(6, OracleTypes.TIMESTAMP, 6); // p_trlog_start_time_begin
    _csGetTransactionHistory.defineParameterType(7, OracleTypes.TIMESTAMP, 6); // p_trlog_start_time_end
    _csGetTransactionHistory.defineParameterType(8, OracleTypes.VARCHAR, 100); // p_usr_naas_id_from_cdx
  }


  public String getActivity (  
      String trtypUid,
      String orgId,
      String mlocId,
      String prjId,
      String actId,
      Date actStartDateBegin,
      Date actStartDateEnd,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetActivity.setString(2, trtypUid);
    _csGetActivity.setString(3, orgId);
    _csGetActivity.setString(4, mlocId);
    _csGetActivity.setString(5, prjId);
    _csGetActivity.setString(6, actId);
    _csGetActivity.setDate(7, actStartDateBegin);
    _csGetActivity.setDate(8, actStartDateEnd);
    _csGetActivity.setString(9, usrNaasIdFromCdx);
    _csGetActivity.execute();
    // get out parameters and/or return value
    return _csGetActivity.getString(1);
  }

  public String getActivityGroup (  
      String trtypUid,
      String orgId,
      String agtypName,
      String actgrpId,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetActivityGroup.setString(2, trtypUid);
    _csGetActivityGroup.setString(3, orgId);
    _csGetActivityGroup.setString(4, agtypName);
    _csGetActivityGroup.setString(5, actgrpId);
    _csGetActivityGroup.setString(6, usrNaasIdFromCdx);
    _csGetActivityGroup.execute();
    // get out parameters and/or return value
    return _csGetActivityGroup.getString(1);
  }

  public String getDomainValues (  
      String trtypUid,
      String elementName,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetDomainValues.setString(2, trtypUid);
    _csGetDomainValues.setString(3, elementName);
    _csGetDomainValues.setString(4, usrNaasIdFromCdx);
    _csGetDomainValues.execute();
    // get out parameters and/or return value
    return _csGetDomainValues.getString(1);
  }

  public String getMonitoringLocation (  
      String trtypUid,
      String orgId,
      String mlocId,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetMonitoringLocation.setString(2, trtypUid);
    _csGetMonitoringLocation.setString(3, orgId);
    _csGetMonitoringLocation.setString(4, mlocId);
    _csGetMonitoringLocation.setString(5, usrNaasIdFromCdx);
    _csGetMonitoringLocation.execute();
    // get out parameters and/or return value
    return _csGetMonitoringLocation.getString(1);
  }

  public String getProcessingReport (  
      String trlogUid,
      String wqxNodeVersion)

      throws SQLException {

    // set parameter values and call procedure
    _csGetProcessingReport.setString(2, trlogUid);
    _csGetProcessingReport.setString(3, wqxNodeVersion);
    _csGetProcessingReport.execute();
    // get out parameters and/or return value
    return _csGetProcessingReport.getString(1);
  }

  public String getProject (  
      String trtypUid,
      String orgId,
      String prjId,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetProject.setString(2, trtypUid);
    _csGetProject.setString(3, orgId);
    _csGetProject.setString(4, prjId);
    _csGetProject.setString(5, usrNaasIdFromCdx);
    _csGetProject.execute();
    // get out parameters and/or return value
    return _csGetProject.getString(1);
  }

  public String getResult (  
      String trtypUid,
      String orgId,
      String mlocId,
      String prjId,
      String actId,
      Date actStartDateBegin,
      Date actStartDateEnd,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetResult.setString(2, trtypUid);
    _csGetResult.setString(3, orgId);
    _csGetResult.setString(4, mlocId);
    _csGetResult.setString(5, prjId);
    _csGetResult.setString(6, actId);
    _csGetResult.setDate(7, actStartDateBegin);
    _csGetResult.setDate(8, actStartDateEnd);
    _csGetResult.setString(9, usrNaasIdFromCdx);
    _csGetResult.execute();
    // get out parameters and/or return value
    return _csGetResult.getString(1);
  }

  public String getTransactionHistory (  
      String trtypUid,
      String orgId,
      String usrNaasId,
      String trlogTransId,
      Date trlogStartTimeBegin,
      Date trlogStartTimeEnd,
      String usrNaasIdFromCdx)

      throws SQLException {

    // set parameter values and call procedure
    _csGetTransactionHistory.setString(2, trtypUid);
    _csGetTransactionHistory.setString(3, orgId);
    _csGetTransactionHistory.setString(4, usrNaasId);
    _csGetTransactionHistory.setString(5, trlogTransId);
    _csGetTransactionHistory.setDate(6, trlogStartTimeBegin);
    _csGetTransactionHistory.setDate(7, trlogStartTimeEnd);
    _csGetTransactionHistory.setString(8, usrNaasIdFromCdx);
    _csGetTransactionHistory.execute();
    // get out parameters and/or return value
    return _csGetTransactionHistory.getString(1);
  }

}