----------------------------------------------
-- Export file for user WQX                 --
-- Created on 9/6/2006, 2:51:14 PM --
----------------------------------------------

prompt
prompt Creating table TRIBE
prompt ====================
prompt
create table TRIBE
(
  TRB_UID              NUMBER(6) not null,
  TRB_CD               VARCHAR2(3) not null,
  TRB_NAME             VARCHAR2(120) not null,
  TRB_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TRIBE
  add constraint TRB_PK primary key (TRB_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TRB_CD_UPPER_UK on TRIBE (UPPER(TRB_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TRB_NAME_UPPER_UK on TRIBE (UPPER(TRB_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ORGANIZATION
prompt ===========================
prompt
create table ORGANIZATION
(
  ORG_UID              NUMBER(20) not null,
  TRB_UID              NUMBER(6),
  ORG_ID               VARCHAR2(30) not null,
  ORG_NAME             VARCHAR2(120) not null,
  ORG_DESC             VARCHAR2(500),
  ORG_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ORGANIZATION
  add constraint ORG_PK primary key (ORG_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ORGANIZATION
  add constraint ORG_TRB_FK foreign key (TRB_UID)
  references TRIBE (TRB_UID);
create unique index ORG_ID_UPPER_UK on ORGANIZATION (UPPER(ORG_ID))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACCESS_TYPE
prompt ==========================
prompt
create table ACCESS_TYPE
(
  ACCTYP_UID              NUMBER(6) not null,
  ACCTYP_NAME             VARCHAR2(30) not null,
  ACCTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ACCESS_TYPE
  add constraint ACCTYP_PK primary key (ACCTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index ACCTYP_NAME_UPPER_UK on ACCESS_TYPE (UPPER(ACCTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_GROUP_TYPE
prompt ==================================
prompt
create table ACTIVITY_GROUP_TYPE
(
  AGTYP_UID              NUMBER(6) not null,
  AGTYP_NAME             VARCHAR2(50) not null,
  AGTYP_DESC             VARCHAR2(500),
  AGTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_GROUP_TYPE
  add constraint AGTYP_PK primary key (AGTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index AGTYP_NAME_UPPER_UK on ACTIVITY_GROUP_TYPE (UPPER(AGTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_MEDIA
prompt =============================
prompt
create table ACTIVITY_MEDIA
(
  ACMED_UID              NUMBER(6) not null,
  ACMED_NAME             VARCHAR2(20) not null,
  ACMED_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_MEDIA
  add constraint ACMED_PK primary key (ACMED_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index ACMED_NAME_UPPER_UK on ACTIVITY_MEDIA (UPPER(ACMED_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_MEDIA_SUBDIVISION
prompt =========================================
prompt
create table ACTIVITY_MEDIA_SUBDIVISION
(
  AMSUB_UID              NUMBER(6) not null,
  AMSUB_NAME             VARCHAR2(45) not null,
  AMSUB_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_MEDIA_SUBDIVISION
  add constraint AMSUB_PK primary key (AMSUB_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index AMSUB_NAME_UPPER_UK on ACTIVITY_MEDIA_SUBDIVISION (UPPER(AMSUB_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_TYPE
prompt ============================
prompt
create table ACTIVITY_TYPE
(
  ACTYP_UID              NUMBER(6) not null,
  ACTYP_CD               VARCHAR2(70) not null,
  ACTYP_DESC             VARCHAR2(400),
  ACTYP_ANL_MTH_REQ_YN   VARCHAR2(1) not null,
  ACTYP_MON_LOC_REQ_YN   VARCHAR2(1) not null,
  ACTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_TYPE
  add constraint ACTYP_PK primary key (ACTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index ACTYP_CD_UPPER_UK on ACTIVITY_TYPE (UPPER(ACTYP_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ADDRESS_TYPE
prompt ===========================
prompt
create table ADDRESS_TYPE
(
  ADDTYP_UID              NUMBER(6) not null,
  ADDTYP_NAME             VARCHAR2(8) not null,
  ADDTYP_DESC             VARCHAR2(200),
  ADDTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ADDRESS_TYPE
  add constraint ADDTYP_PK primary key (ADDTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index ADDTYP_NAME_UPPER_UK on ADDRESS_TYPE (UPPER(ADDTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ANALYTICAL_METHOD_CONTEXT
prompt ========================================
prompt
create table ANALYTICAL_METHOD_CONTEXT
(
  AMCTX_UID              NUMBER(6) not null,
  ORG_UID                NUMBER(6),
  AMCTX_CD               VARCHAR2(30) not null,
  AMCTX_NAME             VARCHAR2(120) not null,
  AMCTX_EPA_MANAGED_YN   VARCHAR2(1) not null,
  AMCTX_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ANALYTICAL_METHOD_CONTEXT
  add constraint AMCTX_PK primary key (AMCTX_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ANALYTICAL_METHOD_CONTEXT
  add constraint AMCTX_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
create unique index AMCTX_CD_UPPER_UK on ANALYTICAL_METHOD_CONTEXT (UPPER(AMCTX_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ANALYTICAL_METHOD
prompt ================================
prompt
create table ANALYTICAL_METHOD
(
  ANLMTH_UID              NUMBER(6) not null,
  AMCTX_UID               NUMBER(6) not null,
  ORG_UID                 NUMBER(6),
  ANLMTH_ID               VARCHAR2(20) not null,
  ANLMTH_NAME             VARCHAR2(120) not null,
  ANLMTH_DESC             VARCHAR2(500),
  ANLMTH_QUAL_TYPE        VARCHAR2(25),
  ANLMTH_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial 5M
    minextents 1
    maxextents unlimited
  );
alter table ANALYTICAL_METHOD
  add constraint ANLMTH_PK primary key (ANLMTH_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 512K
    minextents 1
    maxextents unlimited
  );
alter table ANALYTICAL_METHOD
  add constraint ANLMTH_AMCTX_FK foreign key (AMCTX_UID)
  references ANALYTICAL_METHOD_CONTEXT (AMCTX_UID);
alter table ANALYTICAL_METHOD
  add constraint ANLMTH_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
create unique index ANLMTH_ID_UPPER_UK on ANALYTICAL_METHOD (AMCTX_UID, UPPER(ANLMTH_ID))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 512K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table AUDIT_TYPE
prompt =========================
prompt
create table AUDIT_TYPE
(
  AUDTYP_UID              NUMBER(6) not null,
  AUDTYP_NAME             VARCHAR2(20) not null,
  AUDTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table AUDIT_TYPE
  add constraint AUDTYP_PK primary key (AUDTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index AUDTYP_NAME_UPPER_UK on AUDIT_TYPE (UPPER(AUDTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table CHARACTERISTIC
prompt =============================
prompt
create table CHARACTERISTIC
(
  CHR_UID                    NUMBER(6) not null,
  CHR_NAME                   VARCHAR2(120) not null,
  CHR_SRS_ID                 NUMBER(12),
  CHR_STORET_ID              NUMBER(12),
  CHR_SAMPLE_FRACTION_REQ_YN VARCHAR2(1) not null,
  CHR_PICK_LIST_YN           VARCHAR2(1),
  CHR_LAST_CHANGE_DATE       TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 256K
    minextents 1
    maxextents unlimited
  );
alter table CHARACTERISTIC
  add constraint CHR_PK primary key (CHR_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 152K
    minextents 1
    maxextents unlimited
  );
create unique index CHR_NAME_UPPER_UK on CHARACTERISTIC (UPPER(CHR_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial 152K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table CHARACTERISTIC_PICK_LIST_VALUE
prompt =============================================
prompt
create table CHARACTERISTIC_PICK_LIST_VALUE
(
  CPLVAL_UID              NUMBER(6) not null,
  CHR_UID                 NUMBER(6) not null,
  CPLVAL_CD               VARCHAR2(12) not null,
  CPLVAL_DESC             VARCHAR2(60),
  CPLVAL_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table CHARACTERISTIC_PICK_LIST_VALUE
  add constraint CPLVAL_PK primary key (CPLVAL_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table CHARACTERISTIC_PICK_LIST_VALUE
  add constraint CPLVAL_CHR_FK foreign key (CHR_UID)
  references CHARACTERISTIC (CHR_UID);
create unique index CPLVAL_CD_UPPER_UK on CHARACTERISTIC_PICK_LIST_VALUE (CHR_UID, UPPER(CPLVAL_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  )
  compress 1;

prompt
prompt Creating table CONFIG
prompt =====================
prompt
create table CONFIG
(
  CFG_CD               VARCHAR2(30) not null,
  CFG_DESC             VARCHAR2(250),
  CFG_VALUE            VARCHAR2(2000) not null,
  CFG_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table CONFIG
  add constraint CFG_PK primary key (CFG_CD)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table CONTAINER_COLOR
prompt ==============================
prompt
create table CONTAINER_COLOR
(
  CONCOL_UID              NUMBER(6) not null,
  CONCOL_NAME             VARCHAR2(15) not null,
  CONCOL_DESC             VARCHAR2(200),
  CONCOL_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table CONTAINER_COLOR
  add constraint CONCOL_PK primary key (CONCOL_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index CONCOL_NAME_UPPER_UK on CONTAINER_COLOR (UPPER(CONCOL_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table CONTAINER_TYPE
prompt =============================
prompt
create table CONTAINER_TYPE
(
  CONTYP_UID              NUMBER(6) not null,
  CONTYP_NAME             VARCHAR2(35) not null,
  CONTYP_DESC             VARCHAR2(200),
  CONTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table CONTAINER_TYPE
  add constraint CONTYP_PK primary key (CONTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index CONTYP_NAME_UPPER_UK on CONTAINER_TYPE (UPPER(CONTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table COUNTRY
prompt ======================
prompt
create table COUNTRY
(
  CNTRY_UID              NUMBER(6) not null,
  CNTRY_CD               VARCHAR2(2) not null,
  CNTRY_NAME             VARCHAR2(35) not null,
  CNTRY_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table COUNTRY
  add constraint CNTRY_PK2 primary key (CNTRY_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index CNTRY_CD_UPPER_UK on COUNTRY (UPPER(CNTRY_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index CNTRY_NAME_UPPER_UK on COUNTRY (UPPER(CNTRY_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table STATE
prompt ====================
prompt
create table STATE
(
  ST_UID              NUMBER(6) not null,
  CNTRY_UID           NUMBER(6) not null,
  ST_CD               VARCHAR2(2) not null,
  ST_NAME             VARCHAR2(35) not null,
  ST_FIPS_CD          NUMBER(4),
  ST_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table STATE
  add constraint ST_PK2 primary key (ST_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table STATE
  add constraint ST_CNTRY_FK2 foreign key (CNTRY_UID)
  references COUNTRY (CNTRY_UID);
create unique index ST_CD_UPPER_UK on STATE (UPPER(ST_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index ST_NAME_UPPER_UK on STATE (CNTRY_UID, UPPER(ST_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table COUNTY
prompt =====================
prompt
create table COUNTY
(
  CNTY_UID              NUMBER(6) not null,
  ST_UID                NUMBER(6) not null,
  CNTY_NAME             VARCHAR2(50) not null,
  CNTY_FIPS_CD          VARCHAR2(3) not null,
  CNTY_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table COUNTY
  add constraint CNTY_PK primary key (CNTY_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table COUNTY
  add constraint CNTY_FIPS_CD_UK unique (ST_UID, CNTY_FIPS_CD)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table COUNTY
  add constraint CNTY_ST_FK foreign key (ST_UID)
  references STATE (ST_UID);
create unique index CNTY_NAME_UPPER_UK on COUNTY (ST_UID, UPPER(CNTY_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table DETECTION_QUANT_LIMIT_TYPE
prompt =========================================
prompt
create table DETECTION_QUANT_LIMIT_TYPE
(
  DQLTYP_UID              NUMBER(6) not null,
  DQLTYP_NAME             VARCHAR2(35) not null,
  DQLTYP_DESC             VARCHAR2(200),
  DQLTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table DETECTION_QUANT_LIMIT_TYPE
  add constraint DQLTYP_PK primary key (DQLTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index DQLTYP_NAME_UPPER_UK on DETECTION_QUANT_LIMIT_TYPE (UPPER(DQLTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ELECTRONIC_ADDRESS_TYPE
prompt ======================================
prompt
create table ELECTRONIC_ADDRESS_TYPE
(
  EATYP_UID              NUMBER(6) not null,
  EATYP_NAME             VARCHAR2(20) not null,
  EATYP_DESC             VARCHAR2(500),
  EATYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table ELECTRONIC_ADDRESS_TYPE
  add constraint EATYP_PK primary key (EATYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index EATYP_NAME_UPPER_UK on ELECTRONIC_ADDRESS_TYPE (UPPER(EATYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table HORIZONTAL_COLLECTION_METHOD
prompt ===========================================
prompt
create table HORIZONTAL_COLLECTION_METHOD
(
  HCMTH_UID              NUMBER(6) not null,
  HCMTH_NAME             VARCHAR2(70) not null,
  HCMTH_DESC             VARCHAR2(150),
  HCMTH_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table HORIZONTAL_COLLECTION_METHOD
  add constraint HCMTH_PK primary key (HCMTH_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index HCMTH_NAME_UPPER_UK on HORIZONTAL_COLLECTION_METHOD (UPPER(HCMTH_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table HORIZONTAL_REFERENCE_DATUM
prompt =========================================
prompt
create table HORIZONTAL_REFERENCE_DATUM
(
  HRDAT_UID              NUMBER(6) not null,
  HRDAT_NAME             VARCHAR2(6) not null,
  HRDAT_DESC             VARCHAR2(45) not null,
  HRDAT_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table HORIZONTAL_REFERENCE_DATUM
  add constraint HRDAT_PK primary key (HRDAT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index HRDAT_NAME_UPPER_UK on HORIZONTAL_REFERENCE_DATUM (UPPER(HRDAT_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table MEASUREMENT_UNIT
prompt ===============================
prompt
create table MEASUREMENT_UNIT
(
  MSUNT_UID              NUMBER(6) not null,
  MSUNT_CD               VARCHAR2(12) not null,
  MSUNT_DESC             VARCHAR2(200),
  MSUNT_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table MEASUREMENT_UNIT
  add constraint MSUNT_PK primary key (MSUNT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index MSUNT_CD_UPPER_UK on MEASUREMENT_UNIT (UPPER(MSUNT_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table MONITORING_LOCATION_TYPE
prompt =======================================
prompt
create table MONITORING_LOCATION_TYPE
(
  MLTYP_UID              NUMBER(6) not null,
  MLTYP_NAME             VARCHAR2(45) not null,
  MLTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table MONITORING_LOCATION_TYPE
  add constraint MLTYP_PK primary key (MLTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index MLTYP_NAME_UPPER_UK on MONITORING_LOCATION_TYPE (UPPER(MLTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table PHONE_TYPE
prompt =========================
prompt
create table PHONE_TYPE
(
  PHTYP_UID              NUMBER(6) not null,
  PHTYP_NAME             VARCHAR2(6) not null,
  PHTYP_DESC             VARCHAR2(200),
  PHTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table PHONE_TYPE
  add constraint PHTYP_PK primary key (PHTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index PHTYP_NAME_UPPER_UK on PHONE_TYPE (UPPER(PHTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RELATIVE_DEPTH
prompt =============================
prompt
create table RELATIVE_DEPTH
(
  RELDPTH_UID              NUMBER(6) not null,
  RELDPTH_NAME             VARCHAR2(15) not null,
  RELDPTH_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RELATIVE_DEPTH
  add constraint RELDPTH_PK primary key (RELDPTH_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RELDPTH_NAME_UPPER_UK on RELATIVE_DEPTH (UPPER(RELDPTH_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_DETECTION_CONDITION
prompt =========================================
prompt
create table RESULT_DETECTION_CONDITION
(
  RDCND_UID              NUMBER(6) not null,
  RDCND_NAME             VARCHAR2(50) not null,
  RDCND_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_DETECTION_CONDITION
  add constraint RDCND_PK primary key (RDCND_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RDCND_NAME_UPPER_UK on RESULT_DETECTION_CONDITION (UPPER(RDCND_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_LAB_COMMENT
prompt =================================
prompt
create table RESULT_LAB_COMMENT
(
  RLCOM_UID              NUMBER(6) not null,
  RLCOM_CD               VARCHAR2(3) not null,
  RLCOM_DESC             VARCHAR2(100),
  RLCOM_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_LAB_COMMENT
  add constraint RLCOM_PK primary key (RLCOM_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RLCOM_CD_UPPER_UK on RESULT_LAB_COMMENT (UPPER(RLCOM_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_MEASURE_QUALIFIER
prompt =======================================
prompt
create table RESULT_MEASURE_QUALIFIER
(
  RMQLF_UID              NUMBER(6) not null,
  RMQLF_CD               VARCHAR2(5) not null,
  RMQLF_DESC             VARCHAR2(300),
  RMQLF_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_MEASURE_QUALIFIER
  add constraint RMQLF_PK primary key (RMQLF_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RMQLF_CD_UPPER_UK on RESULT_MEASURE_QUALIFIER (UPPER(RMQLF_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_STATISTICAL_BASE
prompt ======================================
prompt
create table RESULT_STATISTICAL_BASE
(
  RSBAS_UID              NUMBER(6) not null,
  RSBAS_CD               VARCHAR2(25) not null,
  RSBAS_DESC             VARCHAR2(200),
  RSBAS_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_STATISTICAL_BASE
  add constraint RSBAS_PK primary key (RSBAS_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RSBAS_CD_UPPER_UK on RESULT_STATISTICAL_BASE (UPPER(RSBAS_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_STATUS
prompt ============================
prompt
create table RESULT_STATUS
(
  RESSTA_UID              NUMBER(6) not null,
  RESSTA_NAME             VARCHAR2(12) not null,
  RESSTA_DESC             VARCHAR2(200),
  RESSTA_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_STATUS
  add constraint RESSTA_PK primary key (RESSTA_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RESSTA_NAME_UPPER_UK on RESULT_STATUS (UPPER(RESSTA_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_TEMPERATURE_BASIS
prompt =======================================
prompt
create table RESULT_TEMPERATURE_BASIS
(
  RTMPB_UID              NUMBER(6) not null,
  RTMPB_NAME             VARCHAR2(12) not null,
  RTMPB_DESC             VARCHAR2(200),
  RTMPB_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_TEMPERATURE_BASIS
  add constraint RTMPB_PK primary key (RTMPB_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RTMPB_NAME_UPPER_UK on RESULT_TEMPERATURE_BASIS (UPPER(RTMPB_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_TIME_BASIS
prompt ================================
prompt
create table RESULT_TIME_BASIS
(
  RTIMB_UID              NUMBER(6) not null,
  RTIMB_NAME             VARCHAR2(12) not null,
  RTIMB_DESC             VARCHAR2(200),
  RTIMB_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_TIME_BASIS
  add constraint RTIMB_PK primary key (RTIMB_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RTIMB_NAME_UPPER_UK on RESULT_TIME_BASIS (UPPER(RTIMB_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_VALUE_TYPE
prompt ================================
prompt
create table RESULT_VALUE_TYPE
(
  RVTYP_UID              NUMBER(6) not null,
  RVTYP_NAME             VARCHAR2(12) not null,
  RVTYP_DESC             VARCHAR2(200),
  RVTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_VALUE_TYPE
  add constraint RVTYP_PK primary key (RVTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RVTYP_NAME_UPPER_UK on RESULT_VALUE_TYPE (UPPER(RVTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_WEIGHT_BASIS
prompt ==================================
prompt
create table RESULT_WEIGHT_BASIS
(
  RWBAS_UID              NUMBER(6) not null,
  RWBAS_NAME             VARCHAR2(15) not null,
  RWBAS_DESC             VARCHAR2(200),
  RWBAS_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table RESULT_WEIGHT_BASIS
  add constraint RWBAS_PK primary key (RWBAS_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index RWBAS_NAME_UPPER_UK on RESULT_WEIGHT_BASIS (UPPER(RWBAS_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SAMPLE_COLLECTION_EQUIP_TYPE
prompt ===========================================
prompt
create table SAMPLE_COLLECTION_EQUIP_TYPE
(
  SCETYP_UID              NUMBER(6) not null,
  SCETYP_NAME             VARCHAR2(30) not null,
  SCETYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SAMPLE_COLLECTION_EQUIP_TYPE
  add constraint SCETYP_PK primary key (SCETYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index SCETYP_NAME_UPPER_UK on SAMPLE_COLLECTION_EQUIP_TYPE (UPPER(SCETYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SAMPLE_COLLECTION_EQUIP
prompt ======================================
prompt
create table SAMPLE_COLLECTION_EQUIP
(
  SCEQP_UID              NUMBER(6) not null,
  SCETYP_UID             NUMBER(6) not null,
  SCEQP_NAME             VARCHAR2(40) not null,
  SCEQP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SAMPLE_COLLECTION_EQUIP
  add constraint SCEQP_PK primary key (SCEQP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SAMPLE_COLLECTION_EQUIP
  add constraint SCEQP_SCETYP_FK foreign key (SCETYP_UID)
  references SAMPLE_COLLECTION_EQUIP_TYPE (SCETYP_UID);
create unique index SCEQP_NAME_UPPER_UK on SAMPLE_COLLECTION_EQUIP (UPPER(SCEQP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SAMPLE_FRACTION
prompt ==============================
prompt
create table SAMPLE_FRACTION
(
  SMFRC_UID              NUMBER(6) not null,
  SMFRC_NAME             VARCHAR2(25) not null,
  SMFRC_DESC             VARCHAR2(200),
  SMFRC_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SAMPLE_FRACTION
  add constraint SMFRC_PK primary key (SMFRC_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index SMFRC_NAME_UPPER_UK on SAMPLE_FRACTION (UPPER(SMFRC_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SAMPLE_TISSUE_ANATOMY
prompt ====================================
prompt
create table SAMPLE_TISSUE_ANATOMY
(
  STANT_UID              NUMBER(6) not null,
  STANT_NAME             VARCHAR2(30) not null,
  STANT_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SAMPLE_TISSUE_ANATOMY
  add constraint STANT_PK primary key (STANT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index STANT_NAME_UPPER_UK on SAMPLE_TISSUE_ANATOMY (UPPER(STANT_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TABLE_LIST
prompt =========================
prompt
create table TABLE_LIST
(
  TBL_UID              NUMBER(6) not null,
  TBL_NAME             VARCHAR2(30) not null,
  TBL_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TABLE_LIST
  add constraint TBL_PK primary key (TBL_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TBL_NAME_UPPER_UK on TABLE_LIST (UPPER(TBL_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TAXON_RANK
prompt =========================
prompt
create table TAXON_RANK
(
  TXRNK_UID              NUMBER(6) not null,
  TXRNK_NAME             VARCHAR2(20) not null,
  TXRNK_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TAXON_RANK
  add constraint TXRNK_PK primary key (TXRNK_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TXRNK_NAME_UPPER_UK on TAXON_RANK (UPPER(TXRNK_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TAXON
prompt ====================
prompt
create table TAXON
(
  TAX_UID              NUMBER(6) not null,
  TXRNK_UID            NUMBER(6) not null,
  TAX_NAME             VARCHAR2(120) not null,
  TAX_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 2M
    minextents 1
    maxextents unlimited
  );
alter table TAXON
  add constraint TAX_PK primary key (TAX_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 1M
    minextents 1
    maxextents unlimited
  );
alter table TAXON
  add constraint TAX_TXRNK_FK foreign key (TXRNK_UID)
  references TAXON_RANK (TXRNK_UID);
create unique index TAX_NAME_UPPER_UK on TAXON (UPPER(TAX_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial 1M
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table THERMAL_PRESERVATIVE
prompt ===================================
prompt
create table THERMAL_PRESERVATIVE
(
  THPRSV_UID              NUMBER(6) not null,
  THPRSV_NAME             VARCHAR2(25) not null,
  THPRSV_DESC             VARCHAR2(200),
  THPRSV_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table THERMAL_PRESERVATIVE
  add constraint THPRSV_PK primary key (THPRSV_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index THPRSV_NAME_UPPER_UK on THERMAL_PRESERVATIVE (UPPER(THPRSV_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TIME_ZONE
prompt ========================
prompt
create table TIME_ZONE
(
  TMZONE_UID              NUMBER(6) not null,
  TMZONE_CD               VARCHAR2(5) not null,
  TMZONE_NAME             VARCHAR2(80) not null,
  TMZONE_OFFSET           NUMBER(4,2) not null,
  TMZONE_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TIME_ZONE
  add constraint TMZONE_PK primary key (TMZONE_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TMZONE_CD_UPPER_UK on TIME_ZONE (UPPER(TMZONE_CD))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_LOG_DETAIL_TYPE
prompt ==========================================
prompt
create table TRANSACTION_LOG_DETAIL_TYPE
(
  TLDTYP_UID              NUMBER(6) not null,
  TLDTYP_NAME             VARCHAR2(25) not null,
  TLDTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG_DETAIL_TYPE
  add constraint TLDTYP_PK primary key (TLDTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TLDTYP_NAME_UPPER_UK on TRANSACTION_LOG_DETAIL_TYPE (UPPER(TLDTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_STATUS
prompt =================================
prompt
create table TRANSACTION_STATUS
(
  TRSTA_UID              NUMBER(6) not null,
  TRSTA_NAME             VARCHAR2(25) not null,
  TRSTA_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_STATUS
  add constraint TRSTA_PK primary key (TRSTA_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TRSTA_NAME_UPPER_UK on TRANSACTION_STATUS (UPPER(TRSTA_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_TYPE
prompt ===============================
prompt
create table TRANSACTION_TYPE
(
  TRTYP_UID              NUMBER(6) not null,
  TRTYP_NAME             VARCHAR2(30) not null,
  TRTYP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_TYPE
  add constraint TRTYP_PK primary key (TRTYP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index TRTYP_NAME_UPPER_UK on TRANSACTION_TYPE (UPPER(TRTYP_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table VERTICAL_COLLECTION_METHOD
prompt =========================================
prompt
create table VERTICAL_COLLECTION_METHOD
(
  VCMTH_UID              NUMBER(6) not null,
  VCMTH_NAME             VARCHAR2(50) not null,
  VCMTH_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table VERTICAL_COLLECTION_METHOD
  add constraint VCMTH_PK primary key (VCMTH_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index VCMTH_NAME_UPPER_UK on VERTICAL_COLLECTION_METHOD (UPPER(VCMTH_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table VERTICAL_REFERENCE_DATUM
prompt =======================================
prompt
create table VERTICAL_REFERENCE_DATUM
(
  VRDAT_UID              NUMBER(6) not null,
  VRDAT_NAME             VARCHAR2(6) not null,
  VRDAT_DESC             VARCHAR2(45) not null,
  VRDAT_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table VERTICAL_REFERENCE_DATUM
  add constraint VRDAT_PK primary key (VRDAT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create unique index VRDAT_NAME_UPPER_UK on VERTICAL_REFERENCE_DATUM (UPPER(VRDAT_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
