------------------------------------------------
-- Export file for user WQX                   --
-- Created by RyanJ on 11/21/2006, 1:41:04 AM --
------------------------------------------------

spool create_packages.log

prompt
prompt Creating package ACTIVITY_GROUP_PKG
prompt ===================================
prompt
CREATE OR REPLACE PACKAGE activity_group_pkg IS

/*----------------------------------------------------------------------------------------
  To insert or delete rows in the Activity Group table.
----------------------------------------------------------------------------------------*/

/****************************************************************************************
 *                               PUBLIC CONSTANTS AND TYPES                             *
 ****************************************************************************************/

/****************************************************************************************
 *                                    PUBLIC VARIABLES                                  *
 ****************************************************************************************/

/****************************************************************************************
 *                             PUBLIC PROCEDURES AND FUNCTIONS                          *
 ****************************************************************************************/

  PROCEDURE insert_update_row (
    p_context     IN transaction_log_detail.tldet_context%TYPE,
    p_actgrp_id   IN activity_group.actgrp_id%TYPE,
    p_actgrp_name IN activity_group.actgrp_name%TYPE,
    p_agtyp_name  IN activity_group_type.agtyp_name%TYPE,
    p_actgrp_uid  OUT activity_group.actgrp_uid%TYPE);

  PROCEDURE insert_detail_row (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_actgrp_uid IN activity_group.actgrp_uid%TYPE,
    p_act_id     IN activity.act_id%TYPE);

  PROCEDURE delete_row (
    p_context    IN  transaction_log_detail.tldet_context%TYPE,
    p_actgrp_uid IN  activity_group.actgrp_uid%TYPE,
    p_actgrp_id  IN  activity_group.actgrp_id%TYPE);
  
  PROCEDURE delete_row_by_actgrp_id (
    p_context    IN  transaction_log_detail.tldet_context%TYPE,
    p_actgrp_id  IN  activity_group.actgrp_id%TYPE);

  PROCEDURE delete_details_by_actgrp_uid (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_actgrp_uid IN activity_group.actgrp_uid%TYPE);
    
  PROCEDURE delete_details_by_act_uid (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid    IN activity_group_detail.act_uid%TYPE);    

END activity_group_pkg;
/

prompt
prompt Creating package ACTIVITY_PKG
prompt =============================
prompt
CREATE OR REPLACE PACKAGE activity_pkg AS

  /*----------------------------------------------------------------------------------------
    To insert, update or delete rows in the Activity table.
  ----------------------------------------------------------------------------------------*/

  /****************************************************************************************
                                 PUBLIC CONSTANTS AND TYPES                               
  ****************************************************************************************/

  /****************************************************************************************
                                      PUBLIC VARIABLES                                  
  ****************************************************************************************/

  /****************************************************************************************
                              PUBLIC PROCEDURES AND FUNCTIONS                              
  ****************************************************************************************/

  PROCEDURE insert_update_row (
    p_context                      IN transaction_log_detail.tldet_context%TYPE,
    p_acmed_name                   IN activity_media.acmed_name%TYPE,
    p_actyp_cd                     IN activity_type.actyp_cd%TYPE,
    p_act_comments                 IN activity.act_comments%TYPE,
    p_act_depth_height             IN activity.act_depth_height%TYPE,
    p_act_depth_height_bottom      IN activity.act_depth_height_bottom%TYPE,
    p_act_depth_altitude_ref_point IN activity.act_depth_altitude_ref_point%TYPE,
    p_act_depth_height_top         IN activity.act_depth_height_top%TYPE,
    p_act_end_date                 IN activity.act_end_date%TYPE,
    p_act_end_time                 IN activity.act_end_time%TYPE,
    p_act_id                       IN activity.act_id%TYPE,
    p_act_loc_latitude             IN activity.act_loc_latitude%TYPE,
    p_act_loc_longitude            IN activity.act_loc_longitude%TYPE,
    p_act_loc_source_map_scale     IN activity.act_loc_source_map_scale%TYPE,
    p_act_start_date               IN activity.act_start_date%TYPE,
    p_act_start_time               IN activity.act_start_time%TYPE,
    p_act_sam_collect_meth_id      IN activity.act_sam_collect_meth_id%TYPE,
    p_act_sam_collect_meth_context IN activity.act_sam_collect_meth_context%TYPE,
    p_act_sam_collect_meth_name    IN activity.act_sam_collect_meth_name%TYPE,
    p_act_sam_col_meth_qual_type   IN activity.act_sam_collect_meth_qual_type%TYPE,
    p_act_sam_collect_meth_desc    IN activity.act_sam_collect_meth_desc%TYPE,
    p_act_sam_col_equip_comments   IN activity.act_sam_collect_equip_comments%TYPE,
    p_act_sam_prep_meth_id         IN activity.act_sam_prep_meth_id%TYPE,
    p_act_sam_prep_meth_context    IN activity.act_sam_prep_meth_context%TYPE,
    p_act_sam_prep_meth_name       IN activity.act_sam_prep_meth_name%TYPE,
    p_act_sam_prep_meth_qual_type  IN activity.act_sam_prep_meth_qual_type%TYPE,
    p_act_sam_prep_meth_desc       IN activity.act_sam_prep_meth_desc%TYPE,
    p_act_sam_trans_stor_desc      IN activity.act_sam_transport_storage_desc%TYPE,
    p_act_sam_chem_preserv         IN activity.act_sam_chemical_preservative%TYPE,
    p_concol_name                  IN container_color.concol_name%TYPE,
    p_contyp_name                  IN container_type.contyp_name%TYPE,
    p_amsub_name                   IN activity_media_subdivision.amsub_name%TYPE,
    p_hcmth_name                   IN horizontal_collection_method.hcmth_name%TYPE,
    p_hrdat_name                   IN horizontal_reference_datum.hrdat_name%TYPE,
    p_mloc_id                      IN monitoring_location.mloc_id%TYPE,
    p_msunt_cd_depth_height        IN measurement_unit.msunt_cd%TYPE,
    p_msunt_cd_depth_height_bottom IN measurement_unit.msunt_cd%TYPE,
    p_msunt_cd_depth_height_top    IN measurement_unit.msunt_cd%TYPE,
    p_reldpth_name                 IN relative_depth.reldpth_name%TYPE,
    p_sceqp_name                   IN sample_collection_equip.sceqp_name%TYPE,
    p_stant_name                   IN sample_tissue_anatomy.stant_name%TYPE,
    p_tax_name                     IN taxon.tax_name%TYPE,
    p_thprsv_name                  IN thermal_preservative.thprsv_name%TYPE,
    p_tmzone_cd_start_time         IN time_zone.tmzone_cd%TYPE,
    p_tmzone_cd_end_time           IN time_zone.tmzone_cd%TYPE,
    p_act_uid                      OUT activity.act_uid%TYPE);

  PROCEDURE insert_project_ref (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_prj_id  IN project.prj_id%TYPE,
    p_act_uid IN activity.act_uid%TYPE);

  PROCEDURE insert_conducting_org (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid    IN activity.act_uid%TYPE,
    p_acorg_name IN activity_conducting_org.acorg_name%TYPE);

  PROCEDURE delete_row (
    p_context   IN  transaction_log_detail.tldet_context%TYPE,
    p_act_uid   IN  activity.act_uid%TYPE,
    p_act_id    IN  activity.act_id%TYPE := NULL);

  PROCEDURE delete_row_by_act_id (
    p_context   IN  transaction_log_detail.tldet_context%TYPE,
    p_act_id    IN  activity.act_id%TYPE);

  PROCEDURE delete_rows_by_mloc_uid (
    p_context   IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid  IN  monitoring_location.mloc_uid%TYPE);

  PROCEDURE delete_rows_by_prj_uid (
    p_context   IN  transaction_log_detail.tldet_context%TYPE,
    p_prj_uid   IN  project.prj_uid%TYPE);

  PROCEDURE delete_act_prj_rows (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid IN activity.act_uid%TYPE);

  PROCEDURE delete_conducting_org_rows (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid IN activity.act_uid%TYPE);

  FUNCTION get_act_uid (
    p_context               IN  transaction_log_detail.tldet_context%TYPE,
    p_act_id                IN  activity.act_id%TYPE)  
    RETURN NUMBER;
    
END activity_pkg;
/

prompt
prompt Creating package ATTACHED_OBJECT_PKG
prompt ====================================
prompt
CREATE OR REPLACE PACKAGE attached_object_pkg IS

/*----------------------------------------------------------------------------------------
  To insert large object data files into the database.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

  PROCEDURE insert_row (
    p_context             IN    transaction_log_detail.tldet_context%TYPE,
    p_atobj_file_name     IN    attached_object.atobj_file_name%TYPE,
    p_atobj_type          IN    attached_object.atobj_type%TYPE,
    p_ref_uid             IN    attached_object.ref_uid%TYPE,
    p_tbl_uid             IN    attached_object.tbl_uid%TYPE,
    p_atobj_uid           OUT   attached_object.atobj_uid%TYPE);
    
  PROCEDURE append_content(
    p_context           IN    transaction_log_detail.tldet_context%TYPE,
    p_atobj_uid         IN    attached_object.atobj_uid%TYPE, 
    p_atobj_content     IN    attached_object.atobj_content%TYPE);
    
  PROCEDURE delete_row (
    p_context     IN    transaction_log_detail.tldet_context%TYPE,
    p_atobj_uid   IN    attached_object.atobj_uid%TYPE);

  PROCEDURE delete_rows_by_table_ref(
    p_context           IN  transaction_log_detail.tldet_context%type, 
    p_ref_uid           IN  attached_object.ref_uid%TYPE,
    p_tbl_uid           IN  attached_object.tbl_uid%TYPE);

END attached_object_pkg;
/

prompt
prompt Creating package LIB_PKG
prompt ========================
prompt
CREATE OR REPLACE PACKAGE lib_pkg IS

/*----------------------------------------------------------------------------------------
   Library of constants, procedures, functions, etc
   used throughout the WQX application 
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
  ------------------- custom error codes --------------
  c_err_standard          CONSTANT NUMBER := -20999;
  c_err_logging           CONSTANT NUMBER := -20998;
  c_err_fatal             CONSTANT NUMBER := -20997;
  c_err_audit             CONSTANT NUMBER := -20996;
  -----------------------------------------------------
  
  c_context_max_length    CONSTANT NUMBER := 500;
  
  --------------------- lookup table values ---------------------------------------------  
  c_acctyp_read_only             CONSTANT  access_type.acctyp_uid%TYPE := 1;
  c_acctyp_full                  CONSTANT  access_type.acctyp_uid%TYPE := 2;
  
  c_audtyp_audit_insert          CONSTANT  audit_type.audtyp_uid%TYPE := 1;
  c_audtyp_audit_update          CONSTANT  audit_type.audtyp_uid%TYPE := 2;
  c_audtyp_audit_delete          CONSTANT  audit_type.audtyp_uid%TYPE := 3;
  
  c_tbl_project	                 CONSTANT  table_list.tbl_uid%TYPE := 1;
  c_tbl_monitoring_location	     CONSTANT  table_list.tbl_uid%TYPE := 2;
  c_tbl_activity	               CONSTANT  table_list.tbl_uid%TYPE := 3;
  c_tbl_activity_group	         CONSTANT  table_list.tbl_uid%TYPE := 4;
  c_tbl_result	                 CONSTANT  table_list.tbl_uid%TYPE := 5;
  c_tbl_org_address	             CONSTANT  table_list.tbl_uid%TYPE := 6;
  c_tbl_org_electronic_address	 CONSTANT  table_list.tbl_uid%TYPE := 7;
  c_tbl_org_phone	               CONSTANT  table_list.tbl_uid%TYPE := 8;
  c_tbl_attached_object	         CONSTANT  table_list.tbl_uid%TYPE := 9;
  
  c_tldtyp_error                 CONSTANT  transaction_log_detail_type.tldtyp_uid%TYPE := 1;
  c_tldtyp_warning               CONSTANT  transaction_log_detail_type.tldtyp_uid%TYPE := 2;
  c_tldtyp_message               CONSTANT  transaction_log_detail_type.tldtyp_uid%TYPE := 3;

  c_trsta_pending	               CONSTANT  transaction_status.trsta_uid%TYPE := 1;
  c_trsta_completed	             CONSTANT  transaction_status.trsta_uid%TYPE := 2;
  c_trsta_failed	               CONSTANT  transaction_status.trsta_uid%TYPE := 3;
  
  c_trtyp_submit                 CONSTANT  transaction_type.trtyp_uid%TYPE := 1;
  c_trtyp_solicit                CONSTANT  transaction_type.trtyp_uid%TYPE := 2;
  c_trtyp_query                  CONSTANT  transaction_type.trtyp_uid%TYPE := 3;
  
  c_hcmth_interpolation_map      CONSTANT  horizontal_collection_method.hcmth_uid%TYPE := 18;
  
  c_actyp_samp_intgrtd_vert_prof CONSTANT  activity_type.actyp_uid%TYPE := 8;
  ---------------------------------------------------------------------------------------
  
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/
  FUNCTION get_version RETURN VARCHAR2;
  
  FUNCTION get_config_value (
    p_config_cd       IN    config.cfg_cd%TYPE) RETURN config.cfg_value%TYPE;
  
  FUNCTION user_org_access_allowed (
    p_usr_uid     IN user_list.usr_uid%TYPE,
    p_org_uid     IN organization.org_uid%TYPE,
    p_acctyp_uid  IN access_type.acctyp_uid%TYPE)
    RETURN VARCHAR2;
    
  FUNCTION context_concat(
    p_orig     IN  transaction_log_detail.tldet_context%TYPE,
    p_new      IN  VARCHAR2) 
    RETURN VARCHAR2;
  
  PROCEDURE raise_error(
    p_context      IN  VARCHAR2,
    p_source       IN  VARCHAR2,
    p_error_msg    IN  VARCHAR2 := NULL,
    p_error_num    IN  NUMBER   := c_err_standard,
    p_sqlcode      IN  NUMBER   := SQLCODE,
    p_sqlerrm      IN  VARCHAR2 := SQLERRM,
    p_force_err_yn IN  VARCHAR2  := 'N');  

END lib_pkg;
/

prompt
prompt Creating package LOOKUP_TBL_PKG
prompt ===============================
prompt
CREATE OR REPLACE PACKAGE lookup_tbl_pkg IS

  /*----------------------------------------------------------------------------------------
     Centralized package to get data from lookup tables.
  ----------------------------------------------------------------------------------------*/

  /****************************************************************************************
                                 PUBLIC CONSTANTS AND TYPES                               
  ****************************************************************************************/

  /****************************************************************************************
                                      PUBLIC VARIABLES                                  
  ****************************************************************************************/

  /****************************************************************************************
                              PUBLIC PROCEDURES AND FUNCTIONS                              
  ****************************************************************************************/
  FUNCTION get_cntry_uid
  (
    p_context  IN VARCHAR2,
    p_cntry_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_st_uid
  (
    p_context IN VARCHAR2,
    p_st_cd   IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_cnty_uid
  (
    p_context      IN VARCHAR2,
    p_cnty_fips_cd IN VARCHAR2,
    p_st_uid       IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_mltyp_uid
  (
    p_context    IN VARCHAR2,
    p_mltyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_vcmth_uid
  (
    p_context    IN VARCHAR2,
    p_vcmth_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_vrdat_uid
  (
    p_context    IN VARCHAR2,
    p_vrdat_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_hcmth_uid
  (
    p_context    IN VARCHAR2,
    p_hcmth_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_hrdat_uid
  (
    p_context    IN VARCHAR2,
    p_hrdat_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_msunt_uid
  (
    p_context  IN VARCHAR2,
    p_msunt_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_actyp_uid
  (
    p_context  IN VARCHAR2,
    p_actyp_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_acmed_uid
  (
    p_context    IN VARCHAR2,
    p_acmed_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_amsub_uid
  (
    p_context    IN VARCHAR2,
    p_amsub_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_addtyp_uid
  (
    p_context     IN VARCHAR2,
    p_addtyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_trb_uid
  (
    p_context IN VARCHAR2,
    p_trb_cd  IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_eatyp_uid
  (
    p_context    IN VARCHAR2,
    p_eatyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_phtyp_uid
  (
    p_context    IN VARCHAR2,
    p_phtyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_sceqp_uid
  (
    p_context    IN VARCHAR2,
    p_sceqp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_stant_uid
  (
    p_context    IN VARCHAR2,
    p_stant_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_contyp_uid
  (
    p_context     IN VARCHAR2,
    p_contyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_thprsv_uid
  (
    p_context     IN VARCHAR2,
    p_thprsv_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_concol_uid
  (
    p_context     IN VARCHAR2,
    p_concol_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_chr_uid
  (
    p_context       IN VARCHAR2,
    p_chr_name      IN VARCHAR2,
    p_pick_list_yn  OUT VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_reldpth_uid
  (
    p_context      IN VARCHAR2,
    p_reldpth_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_ressta_uid
  (
    p_context     IN VARCHAR2,
    p_ressta_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rvtyp_uid
  (
    p_context    IN VARCHAR2,
    p_rvtyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rlcom_uid
  (
    p_context  IN VARCHAR2,
    p_rlcom_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rsbas_uid
  (
    p_context  IN VARCHAR2,
    p_rsbas_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rdcnd_uid
  (
    p_context    IN VARCHAR2,
    p_rdcnd_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_smfrc_uid
  (
    p_context    IN VARCHAR2,
    p_smfrc_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rtmpb_uid
  (
    p_context    IN VARCHAR2,
    p_rtmpb_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rtimb_uid
  (
    p_context    IN VARCHAR2,
    p_rtimb_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rwbas_uid
  (
    p_context    IN VARCHAR2,
    p_rwbas_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_dqltyp_uid
  (
    p_context     IN VARCHAR2,
    p_dqltyp_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_tax_uid
  (
    p_context  IN VARCHAR2,
    p_tax_name IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_tmzone_uid
  (
    p_context   IN VARCHAR2,
    p_tmzone_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_cplval_uid
  (
    p_context     IN VARCHAR2,
    p_chr_uid     IN VARCHAR2,
    p_cplval_cd   IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_rmqlf_uid
  (
    p_context  IN VARCHAR2,
    p_rmqlf_cd IN VARCHAR2
  ) RETURN NUMBER;

  FUNCTION get_usr_uid
  (
    p_context     IN VARCHAR2,
    p_usr_naas_id IN VARCHAR2
  ) RETURN NUMBER;
  
  FUNCTION get_anlmth_uid
  (
    p_context           IN VARCHAR2,
    p_amctx_cd          IN analytical_method_context.amctx_cd%TYPE,
    p_anlmth_id         IN analytical_method.anlmth_id%TYPE,
    p_anlmth_name       IN analytical_method.anlmth_name%TYPE := NULL,
    p_anlmth_desc       IN analytical_method.anlmth_desc%TYPE := NULL,
    p_anlmth_qual_type  IN analytical_method.anlmth_qual_type%TYPE := NULL 
  ) RETURN NUMBER;
  
  FUNCTION get_agtyp_uid
  (
    p_context      IN VARCHAR2,
    p_agtyp_name   IN VARCHAR2
  ) RETURN NUMBER;

END lookup_tbl_pkg;
/

prompt
prompt Creating package MONITORING_LOCATION_PKG
prompt ========================================
prompt
CREATE OR REPLACE PACKAGE monitoring_location_pkg AS

/*----------------------------------------------------------------------------------------
  To insert, update or delete rows in the monitoring_location table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

  PROCEDURE insert_update_row (
    p_context                IN   transaction_log_detail.tldet_context%TYPE,
    p_cntry_cd               IN   country.cntry_cd%TYPE,
    p_cnty_fips_cd           IN   county.cnty_fips_cd%TYPE,
    p_hcmth_name             IN   horizontal_collection_method.hcmth_name%TYPE,
    p_hrdat_name             IN   horizontal_reference_datum.hrdat_name%TYPE,
    p_mloc_desc              IN   monitoring_location.mloc_desc%TYPE,
    p_mloc_huc_12            IN   monitoring_location.mloc_huc_12%TYPE,
    p_mloc_huc_8             IN   monitoring_location.mloc_huc_8%TYPE,
    p_mloc_id                IN   monitoring_location.mloc_id%TYPE,
    p_mloc_latitude          IN   monitoring_location.mloc_latitude%TYPE,
    p_mloc_longitude         IN   monitoring_location.mloc_longitude%TYPE,
    p_mloc_name              IN   monitoring_location.mloc_name%TYPE,
    p_mloc_source_map_scale  IN   monitoring_location.mloc_source_map_scale%TYPE,
    p_mloc_tribal_land_name  IN   monitoring_location.mloc_tribal_land_name%TYPE,
    p_mloc_tribal_land_yn    IN   VARCHAR2, -- need to accomodate values other than Y/N
    p_mloc_vertical_measure  IN   monitoring_location.mloc_vertical_measure%TYPE,
    p_mltyp_name             IN   monitoring_location_type.mltyp_name%TYPE,
    p_msunt_cd               IN   measurement_unit.msunt_cd%TYPE,
    p_st_cd                  IN   state.st_cd%TYPE,
    p_vcmth_name             IN   vertical_collection_method.vcmth_name%TYPE,
    p_vrdat_name             IN   vertical_reference_datum.vrdat_name%TYPE,
    p_mloc_uid               OUT  monitoring_location.mloc_uid%TYPE);
    
  PROCEDURE alt_mloc_insert_row (
    p_context                IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid               IN  monitoring_location_alternate.mloc_uid%TYPE,
    p_mlalt_id               IN  monitoring_location_alternate.mlalt_id%TYPE,
    p_mlalt_context          IN  monitoring_location_alternate.mlalt_context%TYPE);
   
  PROCEDURE delete_row (
    p_context                IN   transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid               IN   monitoring_location.mloc_uid%TYPE,
    p_mloc_id                IN   monitoring_location.mloc_id%TYPE);  
    
  PROCEDURE delete_row_by_mloc_id (
    p_context                IN   transaction_log_detail.tldet_context%TYPE,
    p_mloc_id                IN   monitoring_location.mloc_id%TYPE);

  PROCEDURE delete_mloc_alt (
    p_context               IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid              IN  monitoring_location_alternate.mloc_uid%TYPE);

  FUNCTION get_mloc_uid (
    p_context               IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_id               IN  monitoring_location.mloc_id%TYPE)  
    RETURN NUMBER;
            
END monitoring_location_pkg;
/

prompt
prompt Creating package ORGANIZATION_PKG
prompt =================================
prompt
CREATE OR REPLACE PACKAGE organization_pkg AS

/*----------------------------------------------------------------------------------------
  To update a row in the organization table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/
  FUNCTION get_org_uid(
    p_org_id   IN organization.org_id%TYPE := NULL) RETURN organization.org_uid%TYPE;
    
  FUNCTION get_org_id RETURN organization.org_id%TYPE;    

  PROCEDURE update_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_org_id      IN   organization.org_id%TYPE,
    p_org_name    IN   organization.org_name%TYPE,
    p_org_desc    IN   organization.org_desc%TYPE,
    p_trb_cd      IN   tribe.trb_cd%TYPE,
    p_org_uid     OUT  organization.org_uid%TYPE);
    
END organization_pkg;
/

prompt
prompt Creating package ORG_ADDRESS_PKG
prompt ================================
prompt
CREATE OR REPLACE PACKAGE org_address_pkg AS

/*----------------------------------------------------------------------------------------
  To Insert or Delete a row in the org address table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

  PROCEDURE insert_row (
    p_context                      IN   transaction_log_detail.tldet_context%TYPE,
    p_addtyp_name                  IN   address_type.addtyp_name%TYPE,
    p_cntry_cd                     IN   country.cntry_cd%TYPE,
    p_cnty_fips_cd                 IN   county.cnty_fips_cd%TYPE,
    p_orgadd_address               IN   org_address.orgadd_address%TYPE,
    p_orgadd_address_supplemental  IN   org_address.orgadd_address_supplemental%TYPE,
    p_orgadd_locality_name         IN   org_address.orgadd_locality_name%TYPE,
    p_orgadd_postal_cd             IN   org_address.orgadd_postal_cd%TYPE,
    p_st_cd                        IN   state.st_cd%TYPE,
    p_orgadd_uid                   OUT  org_address.orgadd_uid%TYPE);

  PROCEDURE delete_row (
    p_context                   IN   transaction_log_detail.tldet_context%TYPE,
    p_orgadd_uid                IN   org_address.orgadd_uid%TYPE);
    
  PROCEDURE delete_rows_by_org_uid (
    p_context                   IN   transaction_log_detail.tldet_context%TYPE,
    p_org_uid                   IN   organization.org_uid%TYPE);
    
END org_address_pkg;
/

prompt
prompt Creating package ORG_ELECTRONIC_ADDRESS_PKG
prompt ===========================================
prompt
CREATE OR REPLACE PACKAGE org_electronic_address_pkg AS

/*----------------------------------------------------------------------------------------
  To Insert or Delete a row in the org electronic address table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

  PROCEDURE insert_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_eatyp_name  IN   electronic_address_type.eatyp_name%TYPE,
    p_orgea_text  IN   org_electronic_address.orgea_text%TYPE,
    p_orgea_uid   OUT  org_electronic_address.orgea_uid%TYPE);
    
  PROCEDURE delete_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_orgea_uid   IN   org_electronic_address.orgea_uid%TYPE);
    
  PROCEDURE delete_rows_by_org_uid (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_org_uid     IN   organization.org_uid%TYPE);
    
END org_electronic_address_pkg;
/

prompt
prompt Creating package ORG_PHONE_PKG
prompt ==============================
prompt
CREATE OR REPLACE PACKAGE org_phone_pkg AS

/*----------------------------------------------------------------------------------------
  To Insert or Delete a row in the org phone table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

  PROCEDURE insert_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_orgph_ext   IN   org_phone.orgph_ext%TYPE,
    p_orgph_num   IN   org_phone.orgph_num%TYPE,
    p_phtyp_name  IN   phone_type.phtyp_name%TYPE,
    p_orgph_uid   OUT  org_phone.orgph_uid%TYPE);
    
  PROCEDURE delete_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_orgph_uid   IN   org_phone.orgph_uid%TYPE);
    
  PROCEDURE delete_rows_by_org_uid (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_org_uid     IN   organization.org_uid%TYPE);
    
END org_phone_pkg;
/

prompt
prompt Creating package PROJECT_PKG
prompt ============================
prompt
CREATE OR REPLACE PACKAGE project_pkg AS

/*----------------------------------------------------------------------------------------
  To insert, update or delete rows in the project table.
----------------------------------------------------------------------------------------*/  
 
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

  PROCEDURE insert_update_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_prj_desc    IN   project.prj_desc%TYPE,
    p_prj_id      IN   project.prj_id%TYPE,
    p_prj_name    IN   project.prj_name%TYPE,
    p_prj_uid     OUT  project.prj_uid%TYPE);

  PROCEDURE delete_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_prj_uid     IN   project.prj_uid%TYPE,
    p_prj_id      IN   project.prj_id%TYPE);
    
  PROCEDURE delete_row_by_prj_id (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_prj_id      IN   project.prj_id%TYPE);
  
  FUNCTION get_prj_uid (
    p_context   IN  transaction_log_detail.tldet_context%TYPE,
    p_prj_id    IN  project.prj_id%TYPE)
    RETURN NUMBER;
  
END project_pkg;
/

prompt
prompt Creating package RESULT_DETECT_QUANT_LIMIT_PKG
prompt ==============================================
prompt
CREATE OR REPLACE PACKAGE result_detect_quant_limit_pkg AS

/*----------------------------------------------------------------------------------------
  To insert or delete rows in the result detect quant level table.
----------------------------------------------------------------------------------------*/

/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES
 ****************************************************************************************/

/****************************************************************************************
                                     PUBLIC VARIABLES
 ****************************************************************************************/

/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS
 ****************************************************************************************/

/****************************************************************************************
   Insert a new row
****************************************************************************************/

  PROCEDURE insert_row (
    p_context        IN   transaction_log_detail.tldet_context%TYPE,
    p_dqltyp_name    IN   detection_quant_limit_type.dqltyp_name%TYPE,
    p_msunt_cd       IN   measurement_unit.msunt_cd%TYPE,
    p_rdqlmt_measure  IN   result_detect_quant_limit.rdqlmt_measure%TYPE,
    p_res_uid        IN   result_detect_quant_limit.res_uid%TYPE,
    p_rdqlmt_uid      OUT  result_detect_quant_limit.rdqlmt_uid%TYPE);

/****************************************************************************************
   Delete a row
****************************************************************************************/
  PROCEDURE delete_row (
    p_context                    IN   transaction_log_detail.tldet_context%TYPE,
    p_rdqlmt_uid                  IN   result_detect_quant_limit.rdqlmt_uid%TYPE);

/****************************************************************************************
   Delete by result uid
****************************************************************************************/
  PROCEDURE delete_row_by_res_uid (
    p_context        IN   transaction_log_detail.tldet_context%TYPE,
    p_res_uid        IN   result_detect_quant_limit.res_uid%TYPE);


END result_detect_quant_limit_pkg;
/

prompt
prompt Creating package RESULT_LAB_SAMPLE_PREP_PKG
prompt ===========================================
prompt
CREATE OR REPLACE PACKAGE result_lab_sample_prep_pkg AS

/*----------------------------------------------------------------------------------------
  To insert or delete rows in the result lab sample prep table.
----------------------------------------------------------------------------------------*/

/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES
 ****************************************************************************************/

/****************************************************************************************
                                     PUBLIC VARIABLES
 ****************************************************************************************/

/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS
 ****************************************************************************************/

/****************************************************************************************
   Insert a new row
****************************************************************************************/
  PROCEDURE insert_row (
  p_context                   IN  transaction_log_detail.tldet_context%TYPE,
  p_res_uid                   IN  result_lab_sample_prep.res_uid%TYPE,
  p_rlsprp_end_date           IN  result_lab_sample_prep.rlsprp_end_date%TYPE,
  p_rlsprp_end_time           IN  result_lab_sample_prep.rlsprp_end_time%TYPE,
  p_rlsprp_method_context     IN  result_lab_sample_prep.rlsprp_method_context%TYPE,
  p_rlsprp_method_desc        IN  result_lab_sample_prep.rlsprp_method_desc%TYPE,
  p_rlsprp_method_id          IN  result_lab_sample_prep.rlsprp_method_id%TYPE,
  p_rlsprp_method_name        IN  result_lab_sample_prep.rlsprp_method_name%TYPE,
  p_rlsprp_method_qual_type   IN  result_lab_sample_prep.rlsprp_method_qual_type%TYPE,
  p_rlsprp_start_date         IN  result_lab_sample_prep.rlsprp_start_date%TYPE,
  p_rlsprp_start_time         IN  result_lab_sample_prep.rlsprp_start_time%TYPE,
  p_tmzone_uid_end_time       IN  result_lab_sample_prep.tmzone_uid_end_time%TYPE,
  p_tmzone_uid_start_time     IN  result_lab_sample_prep.tmzone_uid_start_time%TYPE,
  p_rlsprp_uid                OUT result_lab_sample_prep.rlsprp_uid%TYPE);

/****************************************************************************************
   Delete a row
****************************************************************************************/
  PROCEDURE delete_row (
    p_context                    IN   transaction_log_detail.tldet_context%TYPE,
    p_rlsprp_uid                 IN   result_lab_sample_prep.rlsprp_uid%TYPE);

/****************************************************************************************
   Delete by result uid
****************************************************************************************/
  PROCEDURE delete_row_by_res_uid (
    p_context                    IN   transaction_log_detail.tldet_context%TYPE,
    p_res_uid                    IN   result.res_uid%TYPE);


END result_lab_sample_prep_pkg;
/

prompt
prompt Creating package RESULT_PKG
prompt ===========================
prompt
CREATE OR REPLACE PACKAGE result_pkg AS

/*----------------------------------------------------------------------------------------
  To insert or delete rows in the result table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/

/****************************************************************************************
   Insert a new row
****************************************************************************************/
  PROCEDURE insert_row (
  p_context                         IN   transaction_log_detail.tldet_context%TYPE,
  p_act_uid                         IN   result.act_uid%TYPE,
  p_chr_name                        IN   characteristic.chr_name%TYPE,
  p_msunt_cd_dpth_ht                IN   measurement_unit.msunt_cd%TYPE,
  p_msunt_cd_measure                IN   measurement_unit.msunt_cd%TYPE,
  p_rdcnd_name                      IN   result_detection_condition.rdcnd_name%TYPE,
  p_anlmth_uid                      IN   analytical_method.anlmth_uid%TYPE,
  p_res_measure_bias                IN   result.res_measure_bias%TYPE,
  p_res_comments                    IN   result.res_comments%TYPE,
  p_res_data_logger_line            IN   result.res_data_logger_line%TYPE,
  p_res_depth_height                IN   result.res_depth_height%TYPE,
  p_res_depth_altitude_ref_point    IN   result.res_depth_altitude_ref_point%TYPE,
  p_res_lab_analysis_start_date     IN   result.res_lab_analysis_start_date%TYPE,
  p_res_lab_analysis_start_time     IN   result.res_lab_analysis_start_time%TYPE,
  p_res_lab_analysis_end_date       IN   result.res_lab_analysis_end_date%TYPE,
  p_res_lab_analysis_end_time       IN   result.res_lab_analysis_end_time%TYPE,
  p_tmzone_cd_lab_start             IN   time_zone.tmzone_cd%TYPE,
  p_tmzone_cd_lab_end               IN   time_zone.tmzone_cd%TYPE,
  p_res_lab_name                    IN   result.res_lab_name%TYPE,
  p_res_particle_size_basis         IN   result.res_particle_size_basis%TYPE,
  p_res_measure                     IN   result.res_measure%TYPE,
  p_res_measure_conf_interval       IN   result.res_measure_conf_interval%TYPE,
  p_res_measure_precision           IN   result.res_measure_precision%TYPE,
  p_res_measure_lower_conf_limit    IN   result.res_measure_lower_conf_limit%TYPE,
  p_res_measure_upper_conf_limit    IN   result.res_measure_upper_conf_limit%TYPE,
  p_rlcom_cd                        IN   result_lab_comment.rlcom_cd%TYPE,
  p_rmqlf_cd                        IN   result_measure_qualifier.rmqlf_cd%TYPE,
  p_rsbas_cd                        IN   result_statistical_base.rsbas_cd%TYPE,
  p_ressta_name                     IN   result_status.ressta_name%TYPE,
  p_rtimb_name                      IN   result_time_basis.rtimb_name%TYPE,
  p_rtmpb_name                      IN   result_temperature_basis.rtmpb_name%TYPE,
  p_rvtyp_name                      IN   result_value_type.rvtyp_name%TYPE,
  p_rwbas_name                      IN   result_weight_basis.rwbas_name%TYPE,
  p_smfrc_name                      IN   sample_fraction.smfrc_name%TYPE,
  p_res_uid                         OUT  result.res_uid%TYPE);

/****************************************************************************************
   Delete a row by unique key
****************************************************************************************/
  PROCEDURE delete_row (
    p_context                         IN   transaction_log_detail.tldet_context%TYPE,
    p_res_uid                         IN   result.res_uid%TYPE);
    
/****************************************************************************************
   Delete rows by Activity UID
****************************************************************************************/
  PROCEDURE delete_rows_by_act_uid (
    p_context                         IN   transaction_log_detail.tldet_context%TYPE,
    p_act_uid                         IN   activity.act_uid%TYPE);
     
END result_pkg;
/

prompt
prompt Creating package TRANSACTION_LOG_PKG
prompt ====================================
prompt
CREATE OR REPLACE PACKAGE transaction_log_pkg IS

/*----------------------------------------------------------------------------------------
  To insert rows in the transaction_log table.
----------------------------------------------------------------------------------------*/  
  
/****************************************************************************************
                                PUBLIC CONSTANTS AND TYPES                               
 ****************************************************************************************/
 
/****************************************************************************************
                                     PUBLIC VARIABLES                                  
 ****************************************************************************************/
   
/****************************************************************************************
                             PUBLIC PROCEDURES AND FUNCTIONS                              
 ****************************************************************************************/
  FUNCTION insert_audit (
    p_audtyp_uid        IN  transaction_log_audit.audtyp_uid%TYPE,
    p_tbl_uid           IN  transaction_log_audit.tbl_uid%TYPE,
    p_ref_uid           IN  transaction_log_audit.ref_uid%TYPE,
    p_ref_id            IN  transaction_log_audit.ref_id%TYPE := NULL,
    p_tlaud_success_yn  IN  transaction_log_audit.tlaud_success_yn%TYPE := 'P')
    RETURN transaction_log_audit.tlaud_uid%TYPE;
  
  PROCEDURE update_audit_pending (
    p_tlaud_success_yn   IN transaction_log_audit.tlaud_success_yn%TYPE);
    
  PROCEDURE insert_message (
    p_tldet_msg       IN  VARCHAR2);
    
  PROCEDURE insert_warning (
    p_tldet_msg       IN  VARCHAR2,
    p_tldet_context   IN  VARCHAR2);

  PROCEDURE insert_error (
    p_tldet_msg       IN  VARCHAR2,
    p_tldet_source    IN  VARCHAR2,
    p_tldet_context   IN  VARCHAR2);

  FUNCTION get_trlog_uid 
    RETURN transaction_log.trlog_uid%TYPE;
 
  PROCEDURE start_transaction (
    p_context                       IN   transaction_log_detail.tldet_context%TYPE,
    p_org_id                        IN   organization.org_id%TYPE := NULL,
    p_trtyp_uid                     IN   transaction_type.trtyp_uid%TYPE,
    p_usr_naas_id                   IN   user_list.usr_naas_id%TYPE,    
    p_trlog_trans_id                IN   transaction_log.trlog_trans_id%TYPE,
    p_trlog_doc_id                  IN   transaction_log.trlog_doc_id%TYPE,
    p_trlog_other                   IN   transaction_log.trlog_other%TYPE,    
    p_trhead_author                 IN   transaction_header.trhead_author%TYPE := NULL,
    p_trhead_comment                IN   transaction_header.trhead_comment%TYPE := NULL,
    p_trhead_contact_info           IN   transaction_header.trhead_contact_info%TYPE := NULL,
    p_trhead_creation_time          IN   transaction_header.trhead_creation_time%TYPE := NULL,
    p_trhead_id                     IN   transaction_header.trhead_id%TYPE := NULL,
    p_trhead_operation              IN   transaction_header.trhead_operation%TYPE := NULL,
    p_trhead_org_name               IN   transaction_header.trhead_org_name%TYPE := NULL,
    p_trhead_schema_ref             IN   transaction_header.trhead_schema_ref%TYPE := NULL,
    p_trhead_title                  IN   transaction_header.trhead_title%TYPE := NULL,
    p_trlog_start_time              IN   transaction_log.trlog_start_time%TYPE := SYSTIMESTAMP,
    p_trlog_uid                     OUT  transaction_log.trlog_uid%TYPE);

  FUNCTION get_error_count
    RETURN NUMBER;
             
  FUNCTION end_transaction (
    p_context               IN   transaction_log_detail.tldet_context%TYPE,
    p_end_time              IN   transaction_log.trlog_end_time%TYPE := SYSTIMESTAMP)
    RETURN transaction_log.trsta_uid%TYPE;
        
END transaction_log_pkg;
/

prompt
prompt Creating package XML_QUERY_PKG
prompt ==============================
prompt
CREATE OR REPLACE PACKAGE xml_query_pkg IS

/*--------------------------------------------------------------------------------------
  Generates XML for WQX Query/Solicit Web Services
  --------------------------------------------------------------------------------------*/

/****************************************************************************************
 *                               PUBLIC CONSTANTS AND TYPES                             *
 ****************************************************************************************/

/****************************************************************************************
 *                                    PUBLIC VARIABLES                                  *
 ****************************************************************************************/

/****************************************************************************************
 *                             PUBLIC PROCEDURES AND FUNCTIONS                          *
 ****************************************************************************************/
  FUNCTION get_domain_values (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_element_name          IN VARCHAR2  := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE) 
    RETURN CLOB;
  
  FUNCTION get_transaction_history (
    p_trtyp_uid               IN transaction_type.trtyp_uid%TYPE,
    p_org_id                  IN organization.org_id%TYPE := NULL,
    p_usr_naas_id             IN user_list.usr_naas_id%TYPE := NULL,
    p_trlog_trans_id          IN transaction_log.trlog_trans_id%TYPE := NULL,
    p_trlog_start_time_begin  IN transaction_log.trlog_start_time%TYPE := NULL,
    p_trlog_start_time_end    IN transaction_log.trlog_start_time%TYPE := NULL,
    p_usr_naas_id_from_cdx    IN user_list.usr_naas_id%TYPE) 
    RETURN CLOB;
  
  FUNCTION get_project (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_prj_id                IN project.prj_id%TYPE        := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE) 
    RETURN CLOB;
  
  FUNCTION get_monitoring_location (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_mloc_id               IN monitoring_location.mloc_id%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    RETURN CLOB;
  
  FUNCTION get_activity (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_mloc_id               IN monitoring_location.mloc_id%TYPE := NULL,
    p_prj_id                IN project.prj_id%TYPE := NULL,
    p_act_id                IN activity.act_id%TYPE := NULL,
    p_act_start_date_begin  IN activity.act_start_date%TYPE := NULL,
    p_act_start_date_end    IN activity.act_start_date%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    RETURN CLOB;
  
  FUNCTION get_result (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_mloc_id               IN monitoring_location.mloc_id%TYPE := NULL,
    p_prj_id                IN project.prj_id%TYPE := NULL,
    p_act_id                IN activity.act_id%TYPE := NULL,
    p_act_start_date_begin  IN activity.act_start_date%TYPE := NULL,
    p_act_start_date_end    IN activity.act_start_date%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    RETURN CLOB;
  
  FUNCTION get_activity_group (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_agtyp_name            IN activity_group_type.agtyp_name%TYPE := NULL, 
    p_actgrp_id             IN activity_group.actgrp_id%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    RETURN CLOB;
  
  FUNCTION get_processing_report(
    p_trlog_uid         IN transaction_log.trlog_uid%TYPE,
    p_wqx_node_version  IN VARCHAR) 
    RETURN CLOB;
     
END xml_query_pkg;
/

prompt
prompt Creating package body ACTIVITY_GROUP_PKG
prompt ========================================
prompt
CREATE OR REPLACE PACKAGE BODY activity_group_pkg IS

/****************************************************************************************
 *                                PRIVATE CONSTANTS AND TYPES                           *
 ****************************************************************************************/

/****************************************************************************************
 *                                     PRIVATE VARIABLES                                *
 ****************************************************************************************/
  v_context transaction_log_detail.tldet_context%TYPE;
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;

/****************************************************************************************
 *                                  PROCEDURES AND FUNCTIONS                            *
 ****************************************************************************************/

  /****************************************************************************************
   Insert or update an Activity Group row
  ****************************************************************************************/
  PROCEDURE insert_update_row (
    p_context     IN transaction_log_detail.tldet_context%TYPE,
    p_actgrp_id   IN activity_group.actgrp_id%TYPE,
    p_actgrp_name IN activity_group.actgrp_name%TYPE,
    p_agtyp_name  IN activity_group_type.agtyp_name%TYPE,
    p_actgrp_uid  OUT activity_group.actgrp_uid%TYPE) IS
  
    v_agtyp_uid  activity_group_type.agtyp_uid%TYPE;
    v_exists      BOOLEAN := FALSE;
  
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Activity Group Identifier = ' || p_actgrp_id);
    v_agtyp_uid := lookup_tbl_pkg.get_agtyp_uid(v_context, p_agtyp_name);
    --See if Activity Group already exists
    BEGIN
      SELECT actgrp_uid
        INTO p_actgrp_uid
        FROM activity_group
       WHERE upper(actgrp_id) = upper(p_actgrp_id)
         AND org_uid = organization_pkg.get_org_uid;
    EXCEPTION
      WHEN no_data_found THEN
        NULL;
    END;
    -- Get next sequence value and put into out parameter.
    IF p_actgrp_uid IS NULL THEN
      SELECT actgrp_seq.NEXTVAL
        INTO p_actgrp_uid
        FROM dual;
      INSERT INTO activity_group (
          actgrp_uid,
          agtyp_uid,
          org_uid,
          actgrp_id,
          actgrp_name,
          actgrp_last_change_date)
        VALUES (
          p_actgrp_uid,
          v_agtyp_uid,
          organization_pkg.get_org_uid,
          p_actgrp_id,
          p_actgrp_name,
          systimestamp);
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert,
        lib_pkg.c_tbl_activity_group,
        p_actgrp_uid,
        p_actgrp_id);
    ELSE
      v_exists := TRUE;
      -- Delete child rows
      delete_details_by_actgrp_uid(v_context, p_actgrp_uid);
      -- Exists, so update
      UPDATE activity_group
        SET agtyp_uid = v_agtyp_uid,
            org_uid = organization_pkg.get_org_uid,
            actgrp_id = p_actgrp_id,
            actgrp_name = p_actgrp_name,
            actgrp_last_change_date = systimestamp
        WHERE actgrp_uid = p_actgrp_uid;
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_update,
        lib_pkg.c_tbl_activity_group,
        p_actgrp_uid,
        p_actgrp_id); 
    END IF;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(v_context, 'activity_group_pkg.insert_row');
      IF v_exists THEN
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_update,
          lib_pkg.c_tbl_activity_group,
          p_actgrp_uid,
          p_actgrp_id,
          'N');
      ELSE
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_insert,
          lib_pkg.c_tbl_activity_group,
          p_actgrp_uid,
          p_actgrp_id,
          'N'); 
      END IF;     
  END insert_update_row;

  /****************************************************************************************
   Insert a detail row (and add an Activity ID to the group)
  ****************************************************************************************/
  PROCEDURE insert_detail_row (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_actgrp_uid IN activity_group.actgrp_uid%TYPE,
    p_act_id     IN activity.act_id%TYPE) IS
  
    v_act_uid activity.act_uid%TYPE;
  
  BEGIN
    IF p_act_id IS NULL THEN
      lib_pkg.raise_error(
        v_context, 
        'activity_group_pkg.insert_detail_row', 
        'Activity Identifier is required');
    END IF;
    v_act_uid := activity_pkg.get_act_uid(p_context, p_act_id);
    INSERT INTO activity_group_detail (
       actgrp_uid,
       act_uid,
       org_uid,
       agdet_last_change_date)
      VALUES (
        p_actgrp_uid,
        v_act_uid,
        organization_pkg.get_org_uid,
        systimestamp);
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_group_pkg.insert_detail_row');
    
  END insert_detail_row;

  /****************************************************************************************
   Delete a row
  ****************************************************************************************/
  PROCEDURE delete_row (
    p_context    IN  transaction_log_detail.tldet_context%TYPE,
    p_actgrp_uid IN  activity_group.actgrp_uid%TYPE,
    p_actgrp_id  IN  activity_group.actgrp_id%TYPE) IS
  
    v_actgrp_id activity_group.actgrp_id%TYPE;
    
  BEGIN
    -- Delete all child records first.
    delete_details_by_actgrp_uid(p_context, p_actgrp_uid);
    DELETE FROM activity_group
      WHERE actgrp_uid = p_actgrp_uid
      RETURNING actgrp_id INTO v_actgrp_id;
    IF SQL%ROWCOUNT > 0 THEN
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete,
        lib_pkg.c_tbl_activity_group,
        p_actgrp_uid,
        v_actgrp_id,
        'Y'); 
    END IF;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_group_pkg.delete_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete,
        lib_pkg.c_tbl_activity_group,
        p_actgrp_uid,
        p_actgrp_id,
        'N'); 
        
  END delete_row;

  /****************************************************************************************
   Delete a row by Activity Group ID
  ****************************************************************************************/
  PROCEDURE delete_row_by_actgrp_id (
    p_context    IN  transaction_log_detail.tldet_context%TYPE,
    p_actgrp_id  IN  activity_group.actgrp_id%TYPE) IS
  
    v_actgrp_uid  activity_group.actgrp_uid%TYPE;
    
  BEGIN
    SELECT actgrp_uid
      INTO v_actgrp_uid
      FROM activity_group a
      WHERE upper(a.actgrp_id) = upper(p_actgrp_id)
      AND a.org_uid = organization_pkg.get_org_uid;
    delete_row(p_context, v_actgrp_uid, p_actgrp_id);
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'activity_group_pkg.delete_row_by_actgrp_id',
        'Activity ID is invalid.');
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_group_pkg.delete_row_by_actgrp_id');
  
  END delete_row_by_actgrp_id;
 
  /****************************************************************************************
   Delete activity group detail rows by activity group UID
  ****************************************************************************************/
  PROCEDURE delete_details_by_actgrp_uid (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_actgrp_uid IN activity_group.actgrp_uid%TYPE) IS
  
  BEGIN
    DELETE FROM activity_group_detail a
      WHERE a.actgrp_uid = p_actgrp_uid;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_group_pkg.delete_details_by_actgrp_uid');
    
  END delete_details_by_actgrp_uid;

  /****************************************************************************************
   Delete activity group detail rows by activity UID
  ****************************************************************************************/
  PROCEDURE delete_details_by_act_uid (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid    IN activity_group_detail.act_uid%TYPE) IS
    
  BEGIN
    DELETE FROM activity_group_detail a
      WHERE a.act_uid = p_act_uid;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_group_pkg.delete_details_by_act_uid');
  
  END delete_details_by_act_uid;
        
END activity_group_pkg;
/

prompt
prompt Creating package body ACTIVITY_PKG
prompt ==================================
prompt
CREATE OR REPLACE PACKAGE BODY activity_pkg AS

/****************************************************************************************
 *                             PRIVATE CONSTANTS AND TYPES                              *  
 ****************************************************************************************/

/****************************************************************************************
 *                                  PRIVATE VARIABLES                                   *
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;

/****************************************************************************************
 *                              PROCEDURES AND FUNCTIONS                                *
 ****************************************************************************************/

  /****************************************************************************************
    Delete all data relating to an Activity (i.e. child rows)
  ****************************************************************************************/
  PROCEDURE delete_child_rows (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid IN activity.act_uid%TYPE) AS
  
  BEGIN
    -- cascade delete child records of the activity (via result)
    result_pkg.delete_rows_by_act_uid(p_context, p_act_uid);
    -- delete all activity project references
    delete_act_prj_rows(p_context, p_act_uid);
    -- delete conducting orgs list
    delete_conducting_org_rows(p_context, p_act_uid);
    -- delete attached objects for activity
    attached_object_pkg.delete_rows_by_table_ref(p_context, p_act_uid, lib_pkg.c_tbl_activity);
    -- delete activity from all activity groups
    activity_group_pkg.delete_details_by_act_uid(p_context, p_act_uid);
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_child_rows');
    
  END delete_child_rows;

  /****************************************************************************************
     Insert or Update a new row
  ****************************************************************************************/
  PROCEDURE insert_update_row (
    p_context                      IN transaction_log_detail.tldet_context%TYPE,
    p_acmed_name                   IN activity_media.acmed_name%TYPE,
    p_actyp_cd                     IN activity_type.actyp_cd%TYPE,
    p_act_comments                 IN activity.act_comments%TYPE,
    p_act_depth_height             IN activity.act_depth_height%TYPE,
    p_act_depth_height_bottom      IN activity.act_depth_height_bottom%TYPE,
    p_act_depth_altitude_ref_point IN activity.act_depth_altitude_ref_point%TYPE,
    p_act_depth_height_top         IN activity.act_depth_height_top%TYPE,
    p_act_end_date                 IN activity.act_end_date%TYPE,
    p_act_end_time                 IN activity.act_end_time%TYPE,
    p_act_id                       IN activity.act_id%TYPE,
    p_act_loc_latitude             IN activity.act_loc_latitude%TYPE,
    p_act_loc_longitude            IN activity.act_loc_longitude%TYPE,
    p_act_loc_source_map_scale     IN activity.act_loc_source_map_scale%TYPE,
    p_act_start_date               IN activity.act_start_date%TYPE,
    p_act_start_time               IN activity.act_start_time%TYPE,
    p_act_sam_collect_meth_id      IN activity.act_sam_collect_meth_id%TYPE,
    p_act_sam_collect_meth_context IN activity.act_sam_collect_meth_context%TYPE,
    p_act_sam_collect_meth_name    IN activity.act_sam_collect_meth_name%TYPE,
    p_act_sam_col_meth_qual_type   IN activity.act_sam_collect_meth_qual_type%TYPE,
    p_act_sam_collect_meth_desc    IN activity.act_sam_collect_meth_desc%TYPE,
    p_act_sam_col_equip_comments   IN activity.act_sam_collect_equip_comments%TYPE,
    p_act_sam_prep_meth_id         IN activity.act_sam_prep_meth_id%TYPE,
    p_act_sam_prep_meth_context    IN activity.act_sam_prep_meth_context%TYPE,
    p_act_sam_prep_meth_name       IN activity.act_sam_prep_meth_name%TYPE,
    p_act_sam_prep_meth_qual_type  IN activity.act_sam_prep_meth_qual_type%TYPE,
    p_act_sam_prep_meth_desc       IN activity.act_sam_prep_meth_desc%TYPE,
    p_act_sam_trans_stor_desc      IN activity.act_sam_transport_storage_desc%TYPE,
    p_act_sam_chem_preserv         IN activity.act_sam_chemical_preservative%TYPE,
    p_concol_name                  IN container_color.concol_name%TYPE,
    p_contyp_name                  IN container_type.contyp_name%TYPE,
    p_amsub_name                   IN activity_media_subdivision.amsub_name%TYPE,
    p_hcmth_name                   IN horizontal_collection_method.hcmth_name%TYPE,
    p_hrdat_name                   IN horizontal_reference_datum.hrdat_name%TYPE,
    p_mloc_id                      IN monitoring_location.mloc_id%TYPE,
    p_msunt_cd_depth_height        IN measurement_unit.msunt_cd%TYPE,
    p_msunt_cd_depth_height_bottom IN measurement_unit.msunt_cd%TYPE,
    p_msunt_cd_depth_height_top    IN measurement_unit.msunt_cd%TYPE,
    p_reldpth_name                 IN relative_depth.reldpth_name%TYPE,
    p_sceqp_name                   IN sample_collection_equip.sceqp_name%TYPE,
    p_stant_name                   IN sample_tissue_anatomy.stant_name%TYPE,
    p_tax_name                     IN taxon.tax_name%TYPE,
    p_thprsv_name                  IN thermal_preservative.thprsv_name%TYPE,
    p_tmzone_cd_start_time         IN time_zone.tmzone_cd%TYPE,
    p_tmzone_cd_end_time           IN time_zone.tmzone_cd%TYPE,
    p_act_uid                      OUT activity.act_uid%TYPE) AS
  
    v_context                transaction_log_detail.tldet_context%TYPE;
    v_acmed_uid              activity.acmed_uid%TYPE;
    v_actyp_uid              activity.actyp_uid%TYPE;
    v_actyp_cd               activity_type.actyp_cd%TYPE;
    v_amsub_uid              activity.amsub_uid%TYPE;
    v_hcmth_uid              activity.hcmth_uid%TYPE;
    v_hrdat_uid              activity.hrdat_uid%TYPE;
    v_msunt_uid_depth_height activity.msunt_uid_depth_height%TYPE;
    v_msunt_uid_dep_ht_bottom   activity.msunt_uid_depth_height_bottom%TYPE;
    v_msunt_uid_dep_ht_top   activity.msunt_uid_depth_height_top%TYPE;
    v_sceqp_uid              activity.sceqp_uid%TYPE;
    v_stant_uid              activity.stant_uid%TYPE;
    v_tax_uid                activity.tax_uid%TYPE;
    v_concol_uid             activity.concol_uid%TYPE;
    v_contyp_uid             activity.contyp_uid%TYPE;
    v_reldpth_uid            activity.reldpth_uid%TYPE;
    v_thprsv_uid             activity.thprsv_uid%TYPE;
    v_tmzone_uid_end_time    activity.tmzone_uid_end_time%TYPE;
    v_tmzone_uid_start_time  activity.tmzone_uid_start_time%TYPE;
    v_actyp_mloc_req         activity_type.actyp_mon_loc_req_yn%TYPE;
    v_act_end_time           activity.act_end_time%TYPE := NULL;
    v_act_start_time         activity.act_start_time%TYPE := NULL;
    v_exists                 BOOLEAN := FALSE;
    v_mloc_uid               monitoring_location.mloc_uid%TYPE;
    
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Activity ID = ' || p_act_id);
    -- validate parameters
    IF p_act_id IS NULL THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'Activity Identifier is required');
    END IF;
    IF p_act_sam_prep_meth_id IS NOT NULL THEN
      IF p_act_sam_chem_preserv IS NULL AND p_thprsv_name IS NULL THEN
        lib_pkg.raise_error(
          v_context,
          'activity_pkg.insert_update_row',
          'If Sample Preparation is reported then Chemical Preservative Used Name or '
            || 'Thermal Preservative Used Name must also be reported.');
      END IF;
    END IF;
    -- drop date portion of time-only fields
    IF p_act_start_time IS NOT NULL THEN
      v_act_start_time := to_date(
        '01/01/0001 ' || to_char(p_act_start_time, 'HH24:MI:SS'),'MM/DD/YYYY HH24:MI:SS');
    END IF;
    IF p_act_end_time IS NOT NULL THEN
      v_act_end_time := to_date('01/01/0001 ' || to_char(p_act_end_time, 'HH24:MI:SS'),
        'MM/DD/YYYY HH24:MI:SS');
    END IF;
    IF p_act_depth_height IS NOT NULL
        AND (p_act_depth_height_top IS NOT NULL OR p_act_depth_height_bottom IS NOT NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'You may provide the Activity Depth/Height in one of the following ways (but not both):  '
          || 'a single measurement or a range (Top/Botton)');
    END IF;
    /*    
    ELSIF  (p_act_depth_height IS NOT NULL AND p_msunt_cd_depth_height IS NULL) 
        OR (p_act_depth_height IS NULL AND p_msunt_cd_depth_height IS NOT NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'When ActivityTopDepthHeightMeasure is reported MeasureValue and MeasureUnitCode must be reported');
    */        
    -- Sample Tissue Taxonomic Name and Sample Tissue Anatomy Name both or none need to 
    -- be reported
    IF (p_tax_name IS NOT NULL AND p_stant_name IS NULL)
        OR (p_tax_name IS NULL AND p_stant_name IS NOT NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'When Sample Tissue Taxonomic Name or Anatomy Name are reported, both must be reported.');
    END IF;
    IF p_actyp_cd LIKE '%Sample%'
        AND p_act_sam_collect_meth_id IS NULL THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'When Activity Type Code contains the word "Sample", Sample Collection Method '
          || 'Identifier must be reported');
    END IF;
    -- Taxon Name and Anatomy Name must be included for Tissue Samples
    IF instr(upper(p_acmed_name), 'TISSUE') > 0
       AND (p_tax_name IS NULL AND p_stant_name IS NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'When Activity Media Name contains the word "Tissue", Sample Tissue Taxonomic Name'
          || ' and Sample Tissue Anatomy Name must be reported');
    END IF;
    -- Monitoring Location UID must be reported if it is required by Activity type code
    IF p_mloc_id IS NULL THEN
      SELECT actyp.actyp_mon_loc_req_yn, actyp.actyp_cd
        INTO v_actyp_mloc_req, v_actyp_cd
        FROM activity_type actyp
       WHERE actyp.actyp_cd = p_actyp_cd;
      IF v_actyp_mloc_req = 'Y' THEN
        lib_pkg.raise_error(
          v_context,
          'activity_pkg.insert_update_row',
          'A Monitoring Location Identifier is required when Activity Type Code = ' || v_actyp_cd);
      END IF;
    END IF;
  
    -- Get UIDs for lookup table values
    v_mloc_uid := monitoring_location_pkg.get_mloc_uid(v_context, p_mloc_id);
    v_acmed_uid := lookup_tbl_pkg.get_acmed_uid(v_context, p_acmed_name);
    v_actyp_uid := lookup_tbl_pkg.get_actyp_uid(v_context, p_actyp_cd);
    v_amsub_uid := lookup_tbl_pkg.get_amsub_uid(v_context, p_amsub_name);
    v_hcmth_uid := lookup_tbl_pkg.get_hcmth_uid(v_context, p_hcmth_name);
    v_hrdat_uid := lookup_tbl_pkg.get_hrdat_uid(v_context, p_hrdat_name);
    v_msunt_uid_depth_height := lookup_tbl_pkg.get_msunt_uid(
      v_context, p_msunt_cd_depth_height);
    v_msunt_uid_dep_ht_top := lookup_tbl_pkg.get_msunt_uid(
      v_context, p_msunt_cd_depth_height_top);  
    IF p_msunt_cd_depth_height_bottom = p_msunt_cd_depth_height_top THEN
      v_msunt_uid_dep_ht_bottom := v_msunt_uid_dep_ht_top;
    ELSE
      v_msunt_uid_dep_ht_bottom := lookup_tbl_pkg.get_msunt_uid(
        v_context, p_msunt_cd_depth_height_bottom);
    END IF;
    v_sceqp_uid := lookup_tbl_pkg.get_sceqp_uid(v_context, p_sceqp_name);
    v_stant_uid := lookup_tbl_pkg.get_stant_uid(v_context, p_stant_name);
    v_tax_uid := lookup_tbl_pkg.get_tax_uid(v_context, p_tax_name);
    v_concol_uid := lookup_tbl_pkg.get_concol_uid(v_context, p_concol_name);
    v_contyp_uid := lookup_tbl_pkg.get_contyp_uid(v_context, p_contyp_name);
    v_reldpth_uid := lookup_tbl_pkg.get_reldpth_uid(v_context, p_reldpth_name);
    v_thprsv_uid := lookup_tbl_pkg.get_thprsv_uid(v_context, p_thprsv_name);
    v_tmzone_uid_start_time := lookup_tbl_pkg.get_tmzone_uid(
      v_context, p_tmzone_cd_start_time);
    IF p_tmzone_cd_start_time = p_tmzone_cd_end_time THEN
      v_tmzone_uid_end_time := v_tmzone_uid_start_time;
    ELSE
      v_tmzone_uid_end_time := lookup_tbl_pkg.get_tmzone_uid(
        v_context, p_tmzone_cd_end_time);
    END IF;
    
    IF v_hcmth_uid = lib_pkg.c_hcmth_interpolation_map AND p_act_loc_source_map_scale IS NULL THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'If Horizontal Collection Method Name is "' || p_hcmth_name || '" then Source Map Scale'
          || ' must be provided');
    END IF;
    IF v_actyp_uid = lib_pkg.c_actyp_samp_intgrtd_vert_prof
        AND (p_act_depth_height_top IS NULL AND p_act_depth_height_bottom IS NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'activity_pkg.insert_update_row',
        'When the Activity Type is "' || p_actyp_cd || '" you must provide the Top and Bottom Depth/Height');
    END IF;
    
    -- Check to see if row already exists to determine insert or update.
    BEGIN
      SELECT act_uid
        INTO p_act_uid
        FROM activity
       WHERE act_id = p_act_id
         AND org_uid = organization_pkg.get_org_uid;
    EXCEPTION
      WHEN no_data_found THEN
        NULL;
    END;
    IF p_act_uid IS NULL THEN
      -- the uid couldn't be found, thus new record
      SELECT act_seq.NEXTVAL
        INTO p_act_uid
        FROM dual;
      INSERT INTO activity (
         acmed_uid,
         actyp_uid,
         act_comments,
         act_depth_altitude_ref_point,
         act_depth_height,
         act_depth_height_bottom,
         act_depth_height_top,
         act_end_date,
         act_end_time,
         act_id,
         act_last_change_date,
         act_loc_latitude,
         act_loc_longitude,
         act_loc_source_map_scale,
         act_sam_chemical_preservative,
         act_sam_collect_equip_comments,
         act_sam_collect_meth_context,
         act_sam_collect_meth_desc,
         act_sam_collect_meth_id,
         act_sam_collect_meth_name,
         act_sam_collect_meth_qual_type,
         act_sam_prep_meth_context,
         act_sam_prep_meth_desc,
         act_sam_prep_meth_id,
         act_sam_prep_meth_name,
         act_sam_prep_meth_qual_type,
         act_sam_transport_storage_desc,
         act_start_date,
         act_start_time,
         act_uid,
         amsub_uid,
         concol_uid,
         contyp_uid,
         hcmth_uid,
         hrdat_uid,
         mloc_uid,
         msunt_uid_depth_height,
         msunt_uid_depth_height_bottom,
         msunt_uid_depth_height_top,
         org_uid,
         reldpth_uid,
         sceqp_uid,
         stant_uid,
         tax_uid,
         thprsv_uid,
         tmzone_uid_end_time,
         tmzone_uid_start_time)
      VALUES (
         v_acmed_uid,
         v_actyp_uid,
         p_act_comments,
         p_act_depth_altitude_ref_point,
         p_act_depth_height,
         p_act_depth_height_bottom,
         p_act_depth_height_top,
         p_act_end_date,
         v_act_end_time,
         p_act_id,
         systimestamp,
         p_act_loc_latitude,
         p_act_loc_longitude,
         p_act_loc_source_map_scale,
         p_act_sam_chem_preserv,
         p_act_sam_col_equip_comments,
         p_act_sam_collect_meth_context,
         p_act_sam_collect_meth_desc,
         p_act_sam_collect_meth_id,
         p_act_sam_collect_meth_name,
         p_act_sam_col_meth_qual_type,
         p_act_sam_prep_meth_context,
         p_act_sam_prep_meth_desc,
         p_act_sam_prep_meth_id,
         p_act_sam_prep_meth_name,
         p_act_sam_prep_meth_qual_type,
         p_act_sam_trans_stor_desc,
         p_act_start_date,
         v_act_start_time,
         p_act_uid,
         v_amsub_uid,
         v_concol_uid,
         v_contyp_uid,
         v_hcmth_uid,
         v_hrdat_uid,
         v_mloc_uid,
         v_msunt_uid_depth_height,
         v_msunt_uid_dep_ht_bottom,
         v_msunt_uid_dep_ht_top,
         organization_pkg.get_org_uid,
         v_reldpth_uid,
         v_sceqp_uid,
         v_stant_uid,
         v_tax_uid,
         v_thprsv_uid,
         v_tmzone_uid_end_time,
         v_tmzone_uid_start_time);
    
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert,
        lib_pkg.c_tbl_activity,
        p_act_uid,
        p_act_id);
    ELSE
      -- existing row, so update it    
      v_exists := TRUE;
      -- delete all activity project references
      delete_act_prj_rows(p_context, p_act_uid);
      -- delete conducting orgs list
      delete_conducting_org_rows(p_context, p_act_uid);
      UPDATE activity
         SET acmed_uid = v_acmed_uid,
             actyp_uid = v_actyp_uid,
             act_comments = p_act_comments,
             act_depth_altitude_ref_point = p_act_depth_altitude_ref_point,
             act_depth_height = p_act_depth_height,
             act_depth_height_bottom = p_act_depth_height_bottom,
             act_depth_height_top = p_act_depth_height_top,
             act_end_date = p_act_end_date,
             act_end_time = v_act_end_time,
             act_id = p_act_id,
             act_last_change_date = systimestamp,
             act_loc_latitude = p_act_loc_latitude,
             act_loc_longitude = p_act_loc_longitude,
             act_loc_source_map_scale = p_act_loc_source_map_scale,
             act_sam_chemical_preservative = p_act_sam_chem_preserv,
             act_sam_collect_equip_comments = p_act_sam_col_equip_comments,
             act_sam_collect_meth_context = p_act_sam_collect_meth_context,
             act_sam_collect_meth_desc = p_act_sam_collect_meth_desc,
             act_sam_collect_meth_id = p_act_sam_collect_meth_id,
             act_sam_collect_meth_name = p_act_sam_collect_meth_name,
             act_sam_collect_meth_qual_type = p_act_sam_col_meth_qual_type,
             act_sam_prep_meth_context = p_act_sam_prep_meth_context,
             act_sam_prep_meth_desc = p_act_sam_prep_meth_desc,
             act_sam_prep_meth_id = p_act_sam_prep_meth_id,
             act_sam_prep_meth_name = p_act_sam_prep_meth_name,
             act_sam_prep_meth_qual_type = p_act_sam_prep_meth_qual_type,
             act_sam_transport_storage_desc = p_act_sam_trans_stor_desc,
             act_start_date = p_act_start_date,
             act_start_time = v_act_start_time,
             amsub_uid = v_amsub_uid,
             concol_uid = v_concol_uid,
             contyp_uid = v_contyp_uid,
             hcmth_uid = v_hcmth_uid,
             hrdat_uid = v_hrdat_uid,
             mloc_uid = v_mloc_uid,
             msunt_uid_depth_height = v_msunt_uid_depth_height,
             msunt_uid_depth_height_bottom = v_msunt_uid_dep_ht_bottom,
             msunt_uid_depth_height_top = v_msunt_uid_dep_ht_top,
             org_uid = organization_pkg.get_org_uid,
             reldpth_uid = v_reldpth_uid,
             sceqp_uid = v_sceqp_uid,
             stant_uid = v_stant_uid,
             tax_uid = v_tax_uid,
             thprsv_uid = v_thprsv_uid,
             tmzone_uid_end_time = v_tmzone_uid_end_time,
             tmzone_uid_start_time = v_tmzone_uid_start_time
       WHERE act_uid = p_act_uid;
    
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_update,
        lib_pkg.c_tbl_activity,
        p_act_uid,
        p_act_id);
    END IF;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(v_context, 'activity_pkg.insert_update_row');
      IF v_exists THEN
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_update,
          lib_pkg.c_tbl_activity,
          p_act_uid,
          p_act_id,
          'N');
      ELSE
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_insert,
          lib_pkg.c_tbl_activity,
          p_act_uid,
          p_act_id, 
          'N');
      END IF;
    
  END insert_update_row;

  /****************************************************************************************
   Insert rows into the activity_project table
  ****************************************************************************************/
  PROCEDURE insert_project_ref (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_prj_id  IN project.prj_id%TYPE,
    p_act_uid IN activity.act_uid%TYPE) AS
  
    v_context transaction_log_detail.tldet_context%TYPE;
    v_prj_uid project.prj_uid%TYPE;
  
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Project Identifier = ' || p_prj_id);
    v_prj_uid := project_pkg.get_prj_uid(p_context, p_prj_id);
    -- Insert row into activity_project table to link project with an activity
    IF v_prj_uid IS NOT NULL THEN
      INSERT INTO activity_project (
          act_uid,
          prj_uid,
          org_uid,
          actprj_last_change_date)
        VALUES (
          p_act_uid,
          v_prj_uid,
          organization_pkg.get_org_uid,
          systimestamp);
    END IF;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(v_context, 'activity_pkg.insert_project_ref');
    
  END insert_project_ref;

  /****************************************************************************************
   Insert rows into the activity_conducting_org table
  ****************************************************************************************/
  PROCEDURE insert_conducting_org
  (
    p_context    IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid    IN activity.act_uid%TYPE,
    p_acorg_name IN activity_conducting_org.acorg_name%TYPE
  ) AS
  
    --Add package and id detail to v_context
    v_context transaction_log_detail.tldet_context%TYPE := lib_pkg.context_concat(p_context,
                                                                                  'Conducting Org Name ' ||
                                                                                  p_acorg_name);
  
  BEGIN
    --Insert row into Activity_Conducting_org table 
    INSERT INTO activity_conducting_org
      (act_uid,
       org_uid,
       acorg_name,
       acorg_last_change_date)
    VALUES
      (p_act_uid,
       organization_pkg.get_org_uid,
       p_acorg_name,
       systimestamp);
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(v_context, 'activity_pkg.insert_conducting_org');
    
  END insert_conducting_org;

  /****************************************************************************************
   Delete a row by primary key
  ****************************************************************************************/
  PROCEDURE delete_row (
    p_context   IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid   IN activity.act_uid%TYPE,
    p_act_id    IN activity.act_id%TYPE := NULL) AS
  
    v_act_id activity.act_id%TYPE;
  
  BEGIN
    -- validate parameters
    IF p_act_uid IS NULL THEN
      lib_pkg.raise_error(
        p_context,
        'activity_pkg.delete_row',
        'Activity UID is required');
    ELSE 
      delete_child_rows(p_context, p_act_uid);
      -- delete the activity
      DELETE FROM activity
        WHERE act_uid = p_act_uid
        RETURNING act_id INTO v_act_id;
      IF SQL%ROWCOUNT > 0 THEN
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_delete,
          lib_pkg.c_tbl_activity,
          p_act_uid,
          v_act_id);
      END IF;
    END IF;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete,
        lib_pkg.c_tbl_activity,
        p_act_uid,
        p_act_id,
        'N');
        
  END delete_row;

  /****************************************************************************************
   Delete a row by unique key
  ****************************************************************************************/
  PROCEDURE delete_row_by_act_id (
    p_context   IN transaction_log_detail.tldet_context%TYPE,
    p_act_id    IN activity.act_id%TYPE) AS
  
    v_context transaction_log_detail.tldet_context%TYPE;
    v_act_uid activity.act_uid%TYPE;
  
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Activity Identifier = ' || p_act_id);
    BEGIN
      SELECT act_uid
        INTO v_act_uid
        FROM activity
        WHERE upper(act_id) = upper(p_act_id)
          AND org_uid = organization_pkg.get_org_uid;
      delete_row(v_context, v_act_uid, p_act_id);
    EXCEPTION
      WHEN no_data_found THEN
        transaction_log_pkg.insert_warning(
          'Activity could not be deleted.  ' ||
          'Activity Identifier "' || p_act_id || '" not found.',
          v_context);
    END;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_row_by_act_id');
    
  END delete_row_by_act_id;

  /****************************************************************************************
   Delete a row by monitoring location uid
  ****************************************************************************************/
  PROCEDURE delete_rows_by_mloc_uid (
    p_context   IN transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid  IN monitoring_location.mloc_uid%TYPE) AS
    
  BEGIN
    FOR del_rec IN (SELECT act_uid, act_id
                      FROM activity
                     WHERE mloc_uid = p_mloc_uid) LOOP
      delete_row(p_context, del_rec.act_uid, del_rec.act_id);
    END LOOP;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_row_by_mloc_uid');
    
  END delete_rows_by_mloc_uid;

  /****************************************************************************************
    Delete all the Activities for a Project
    However, if the Activity relates to multiple Projects, just delete the link
      between it and this project (don't actually delete the Activity, so it will 
      remain related to all other projects)
  ****************************************************************************************/
  PROCEDURE delete_rows_by_prj_uid (
    p_context    IN  transaction_log_detail.tldet_context%TYPE,
    p_prj_uid    IN  project.prj_uid%TYPE) AS
    
  BEGIN
    FOR act_prj_rec IN (SELECT act_uid,  
                         (SELECT COUNT(*)
                            FROM activity_project
                            WHERE act_uid = ap.act_uid) prj_count
                         FROM activity_project ap
                         WHERE prj_uid = p_prj_uid) LOOP
      -- if activity only relates to this project, then delete it
      IF act_prj_rec.prj_count = 1 THEN
        delete_row(p_context, act_prj_rec.act_uid, NULL);
        -- otherwise, just delete the reference to it
      ELSE
        DELETE FROM activity_project
          WHERE act_uid = act_prj_rec.act_uid
            AND prj_uid = p_prj_uid;
      END IF;
    END LOOP;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_row_by_prj_uid');
    
  END delete_rows_by_prj_uid;

  /****************************************************************************************
    Delete rows from Activity_Project table
  ****************************************************************************************/
  PROCEDURE delete_act_prj_rows (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid IN activity.act_uid%TYPE) AS
  
  BEGIN
    -- delete all activity project references
    DELETE FROM activity_project
      WHERE act_uid = p_act_uid;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_act_prj_rows');
    
  END delete_act_prj_rows;

  /****************************************************************************************
    Delete rows from Activity_Conducting_Org table
  ****************************************************************************************/
  PROCEDURE delete_conducting_org_rows (
    p_context IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid IN activity.act_uid%TYPE) AS
  
  BEGIN
    -- delete all activity project references
    DELETE FROM activity_conducting_org
     WHERE act_uid = p_act_uid;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.delete_conducting_org_rows');
    
  END delete_conducting_org_rows;

  /****************************************************************************************
    Get Activity UID given an ID
  ****************************************************************************************/ 
  FUNCTION get_act_uid (
    p_context               IN  transaction_log_detail.tldet_context%TYPE,
    p_act_id                IN  activity.act_id%TYPE)
    
    RETURN NUMBER IS
  
    v_act_uid  activity.act_uid%TYPE;
  
  BEGIN
    IF p_act_id IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT act.act_uid
      INTO v_act_uid
      FROM activity act
      WHERE upper(act.act_id) = upper(p_act_id)
        AND act.org_uid = organization_pkg.get_org_uid;
    RETURN v_act_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'activity_pkg.get_act_uid', 
        'Activity Identifier "' || p_act_id || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'activity_pkg.get_act_uid');
      RETURN NULL;
    
  END get_act_uid;

END activity_pkg;
/

prompt
prompt Creating package body ATTACHED_OBJECT_PKG
prompt =========================================
prompt
CREATE OR REPLACE PACKAGE BODY attached_object_pkg IS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
  
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

/****************************************************************************************
  Procedure to insert a new row into the Attached Object table
 ****************************************************************************************/
  PROCEDURE insert_row (
    p_context             IN    transaction_log_detail.tldet_context%TYPE,
    p_atobj_file_name     IN    attached_object.atobj_file_name%TYPE,
    p_atobj_type          IN    attached_object.atobj_type%TYPE,
    p_ref_uid             IN    attached_object.ref_uid%TYPE,
    p_tbl_uid             IN    attached_object.tbl_uid%TYPE,
    p_atobj_uid           OUT   attached_object.atobj_uid%TYPE) IS
         
  BEGIN
    SELECT atobj_seq.NEXTVAL
      INTO p_atobj_uid
      FROM dual;
    INSERT INTO attached_object (
        atobj_uid,
        org_uid,
        atobj_file_name,
        atobj_type,
        atobj_content,
        ref_uid,
        tbl_uid,
        atobj_last_change_date)
      VALUES (
        p_atobj_uid,
        organization_pkg.get_org_uid,
        p_atobj_file_name,
        p_atobj_type,
        empty_blob(),
        p_ref_uid,
        p_tbl_uid,
        SYSTIMESTAMP);
      
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_insert, 
      lib_pkg.c_tbl_attached_object, 
      p_atobj_uid,
      NULL);
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context, 
        'attached_object_pkg.insert_row'); 
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert, 
        lib_pkg.c_tbl_attached_object, 
        p_atobj_uid,
        NULL,
        'N');
        
  END insert_row;

/****************************************************************************************
  Procedure to append lob content for data file
****************************************************************************************/
  PROCEDURE append_content(
    p_context           IN    transaction_log_detail.tldet_context%TYPE,
    p_atobj_uid         IN    attached_object.atobj_uid%TYPE, 
    p_atobj_content     IN    attached_object.atobj_content%TYPE) IS
  
    v_dest_content  attached_object.atobj_content%TYPE;
    v_src_content   attached_object.atobj_content%TYPE;
        
  BEGIN
    --Get current atobj_content from database
    SELECT atobj_content
      INTO v_dest_content
      FROM attached_object
      WHERE atobj_uid = p_atobj_uid FOR UPDATE;   
    v_src_content := p_atobj_content;
    --Open LOB destination and source
    dbms_lob.OPEN(v_dest_content, dbms_lob.lob_readwrite);
    dbms_lob.OPEN(v_src_content, dbms_lob.lob_readonly); 
    --Append source to the end of destination LOB
    dbms_lob.append(v_dest_content, v_src_content);
    --Close both dest and src LOB's
    dbms_lob.CLOSE(v_dest_content);
    dbms_lob.CLOSE(v_src_content);
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context, 
        'attached_object_pkg.append_content');
  
  END append_content; 
  
/****************************************************************************************
  Procedure to delete a row in attached object table
****************************************************************************************/
  PROCEDURE delete_row (
    p_context     IN    transaction_log_detail.tldet_context%TYPE,
    p_atobj_uid   IN    attached_object.atobj_uid%TYPE) AS
        
  BEGIN
    DELETE 
      FROM attached_object
      WHERE atobj_uid = p_atobj_uid;
    IF SQL%ROWCOUNT > 0 THEN
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_attached_object, 
        p_atobj_uid,
        NULL);
    END IF;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context, 
        'attached_object_pkg.delete_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_attached_object, 
        p_atobj_uid,
        NULL,
        'N');
        
  END delete_row;

/****************************************************************************************
  Procedure to delete rows by table reference and table uid in attached object table
****************************************************************************************/    
  PROCEDURE delete_rows_by_table_ref(
    p_context           IN  transaction_log_detail.tldet_context%type, 
    p_ref_uid           IN  attached_object.ref_uid%TYPE,
    p_tbl_uid           IN  attached_object.tbl_uid%TYPE) AS
  
    v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
    
  BEGIN
    IF p_ref_uid IS NULL OR p_tbl_uid IS NULL THEN
      lib_pkg.raise_error(
        p_context, 
        'attached_object_pkg.delete_rows_by_table_ref', 
        'ref_uid and tbl_uid are required');
    END IF;
    FOR rec IN (SELECT atobj_uid
                  FROM attached_object
                  WHERE ref_uid = p_ref_uid
                  AND tbl_uid = p_tbl_uid) LOOP
      delete_row(p_context, rec.atobj_uid);
    END LOOP;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'attached_object_pkg.delete_rows_by_table_ref');

  END delete_rows_by_table_ref;                                       
    
END attached_object_pkg;
/

prompt
prompt Creating package body LIB_PKG
prompt =============================
prompt
CREATE OR REPLACE PACKAGE BODY lib_pkg IS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

/****************************************************************************************
  DB and Packages Version (to be updated with each release of the software)
 ****************************************************************************************/
FUNCTION get_version RETURN VARCHAR2 IS

BEGIN
  RETURN '1.00';
END get_version;
   
/****************************************************************************************
  Function to return a value from the config table
 ****************************************************************************************/
FUNCTION get_config_value (
  p_config_cd IN  config.cfg_cd%TYPE) 
  
  RETURN config.cfg_value%TYPE AS
  
  v_config_code     config.cfg_cd%TYPE := p_config_cd;
  v_config_value    config.cfg_value%TYPE;
  
BEGIN
  SELECT c.cfg_value
    INTO v_config_value
    FROM config c
    WHERE c.cfg_cd = v_config_code;
  RETURN v_config_value;
END get_config_value;

/****************************************************************************************
  Check whether a user has access to a specific organization or not.
  Returns 'Y' or 'N'
****************************************************************************************/
FUNCTION user_org_access_allowed (
  p_usr_uid     IN user_list.usr_uid%TYPE,
  p_org_uid     IN organization.org_uid%TYPE,
  p_acctyp_uid  IN access_type.acctyp_uid%TYPE)
  
  RETURN VARCHAR2 IS

  v_acctyp_uid  access_type.acctyp_uid%TYPE;
  
BEGIN
  BEGIN
    SELECT acctyp_uid
      INTO v_acctyp_uid
      FROM user_org_access a
      WHERE a.usr_uid = p_usr_uid
        AND a.org_uid = p_org_uid;
  EXCEPTION 
    WHEN OTHERS THEN 
      NULL;
  END;
  IF v_acctyp_uid IS NULL THEN
    -- no access allowed
    RETURN 'N';
  ELSIF p_acctyp_uid = v_acctyp_uid OR p_acctyp_uid = lib_pkg.c_acctyp_read_only THEN
    -- access is same level or higher than requested (so access granted)
    RETURN 'Y';
  ELSE
    -- access is lower than requested
    RETURN 'N';
  END IF;
END user_org_access_allowed;
  
/****************************************************************************************
  Function to modify context to fit the column size in the trans log table.
****************************************************************************************/
FUNCTION context_concat (
  p_orig     IN  transaction_log_detail.tldet_context%TYPE,
  p_new      IN  VARCHAR2) 
  
  RETURN VARCHAR2 IS

  v_context_length  NUMBER(4);
  v_context         VARCHAR2(1000);
  
BEGIN
  v_context := p_orig;
  IF p_new IS NOT NULL THEN
    v_context := v_context || ', ' || p_new;
    v_context_length := length(v_context);
    IF v_context_length > c_context_max_length THEN
      v_context := substr(v_context, v_context_length - c_context_max_length, c_context_max_length);
    END IF;
  END IF;
  RETURN v_context;
END context_concat;

/****************************************************************************************
  standard procedure for raising and handling application errors.
  Values for p_sqlcode and p_sqlerrm parameters should not be passed in explicitely.
  They are assigned default values of SQLCODE and SQLERRM respectively.
 ****************************************************************************************/
PROCEDURE raise_error ( 
  p_context      IN  VARCHAR2,
  p_source       IN  VARCHAR2,
  p_error_msg    IN  VARCHAR2 := NULL,
  p_error_num    IN  NUMBER   := c_err_standard,
  p_sqlcode      IN  NUMBER   := SQLCODE,
  p_sqlerrm      IN  VARCHAR2 := SQLERRM,
  p_force_err_yn IN  VARCHAR2 := 'N') AS
  
  v_start       NUMBER := 0;
  v_error_msg   VARCHAR2(2000) := p_error_msg;
     
BEGIN
  IF v_error_msg IS NULL THEN 
    -- if no custom error message was passed in, use SQLERRM
    v_error_msg := p_sqlerrm;
  END IF;
  -- previously raised application error
  IF p_sqlcode BETWEEN -20999 AND -20000 THEN
    -- Oracle adds the error # to the error message each time it's raised
    -- To prevent a string of #s in the message when errors keep cascading,       
    --   strip the previous error # from the error message
    v_start := instr(p_sqlerrm,'ORA' || p_sqlcode);      
    IF v_start < 5 THEN
      v_start := v_start + 11;
    ELSE
      v_start := 1;
    END IF;
    v_error_msg := substr(p_sqlerrm,v_start,2000); 
    raise_application_error(
      p_sqlcode, 
      substr(v_error_msg,1,2000), 
      FALSE);
  ELSE
    -- new error
    IF NOT p_error_num IN (c_err_logging, c_err_fatal)
        AND NOT p_sqlcode IN (c_err_logging, c_err_fatal)
        AND transaction_log_pkg.get_trlog_uid IS NOT NULL THEN
      -- as long as this isn't a log error, write the error message to the log 
      transaction_log_pkg.insert_error(v_error_msg, p_source, p_context);
    END IF;
  END IF;
  IF p_error_num IN (c_err_logging, c_err_audit, c_err_fatal) OR p_force_err_yn = 'Y' THEN
    raise_application_error(
      p_error_num, 
      substr(v_error_msg,1,2000), 
      FALSE);
  END IF;
END raise_error;

END lib_pkg;
/

prompt
prompt Creating package body LOOKUP_TBL_PKG
prompt ====================================
prompt
CREATE OR REPLACE PACKAGE BODY lookup_tbl_pkg IS

  /****************************************************************************************
                                PRIVATE CONSTANTS AND TYPES                                
  ****************************************************************************************/

  /****************************************************************************************
                                     PRIVATE VARIABLES                                  
  ****************************************************************************************/

  /****************************************************************************************
                                 PROCEDURES AND FUNCTIONS                                
  ****************************************************************************************/

  /****************************************************************************************
   Get Country UID based on Country code
  ****************************************************************************************/
  FUNCTION get_cntry_uid
  (
    p_context  IN VARCHAR2,
    p_cntry_cd IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_cntry_uid country.cntry_uid%TYPE;
  
  BEGIN
    IF p_cntry_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT cntry.cntry_uid
      INTO v_cntry_uid
      FROM country cntry
     WHERE upper(cntry.cntry_cd) = upper(p_cntry_cd);
    RETURN v_cntry_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_country_uid', 
        'Country Code "' || p_cntry_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_country_uid');
      RETURN NULL;
    
  END get_cntry_uid;

  /****************************************************************************************
   Get State UID based on State code
  ****************************************************************************************/
  FUNCTION get_st_uid
  (
    p_context IN VARCHAR2,
    p_st_cd   IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_st_uid state.st_uid%TYPE;
  
  BEGIN
    IF p_st_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT st.st_uid
      INTO v_st_uid
      FROM state st
     WHERE upper(st.st_cd) = upper(p_st_cd);
    RETURN v_st_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_st_uid', 
        'State Code "' || p_st_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_st_uid');
      RETURN NULL;
    
  END get_st_uid;

  /****************************************************************************************
   Get County UID based on county fips code
  ****************************************************************************************/
  FUNCTION get_cnty_uid
  (
    p_context      IN VARCHAR2,
    p_cnty_fips_cd IN VARCHAR2,
    p_st_uid       IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_cnty_uid county.cnty_uid%TYPE;
  
  BEGIN
    IF p_cnty_fips_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT cnty.cnty_uid
      INTO v_cnty_uid
      FROM county cnty
     WHERE cnty.st_uid = p_st_uid
       AND upper(cnty.cnty_fips_cd) = upper(p_cnty_fips_cd);
    RETURN v_cnty_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_county_uid', 
        'County Code "' || p_cnty_fips_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_county_uid');
      RETURN NULL;
    
  END get_cnty_uid;

  /****************************************************************************************
    Get Monitoring Location Type UID based on type name
  ****************************************************************************************/
  FUNCTION get_mltyp_uid
  (
    p_context    IN VARCHAR2,
    p_mltyp_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_mltyp_uid monitoring_location_type.mltyp_uid%TYPE;
  
  BEGIN
    IF p_mltyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT mltyp.mltyp_uid
      INTO v_mltyp_uid
      FROM monitoring_location_type mltyp
     WHERE upper(mltyp.mltyp_name) = upper(p_mltyp_name);
    RETURN v_mltyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_mltyp_uid', 
        'Monitoring Location Type Name "' || p_mltyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_mltyp_uid');
      RETURN NULL;
    
  END get_mltyp_uid;

  /****************************************************************************************
     Get Vertical Collection Method UID based on method name
  ****************************************************************************************/
  FUNCTION get_vcmth_uid
  (
    p_context    IN VARCHAR2,
    p_vcmth_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_vcmth_uid vertical_collection_method.vcmth_uid%TYPE;
  
  BEGIN
    IF p_vcmth_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT vcmth.vcmth_uid
      INTO v_vcmth_uid
      FROM vertical_collection_method vcmth
     WHERE upper(vcmth.vcmth_name) = upper(p_vcmth_name);
    RETURN v_vcmth_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_vcmth_uid', 
        'Vertical Collection Method Name "' || p_vcmth_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_vcmth_uid');
      RETURN NULL;
    
  END get_vcmth_uid;

  /****************************************************************************************
     Get Vertical Reference Datum UID based on Datum Code
  ****************************************************************************************/
  FUNCTION get_vrdat_uid
  (
    p_context    IN VARCHAR2,
    p_vrdat_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_vrdat_uid vertical_reference_datum.vrdat_uid%TYPE;
  
  BEGIN
    IF p_vrdat_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT vrdat.vrdat_uid
      INTO v_vrdat_uid
      FROM vertical_reference_datum vrdat
     WHERE upper(vrdat.vrdat_name) = upper(p_vrdat_name);
    RETURN v_vrdat_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_vrdat_uid', 
        'Vertical Reference Datum Code "' || p_vrdat_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_vrdat_uid');
      RETURN NULL;
    
  END get_vrdat_uid;

  /****************************************************************************************
     Get Horizontal Collection Method UID based on Method name
  ****************************************************************************************/
  FUNCTION get_hcmth_uid
  (
    p_context    IN VARCHAR2,
    p_hcmth_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_hcmth_uid horizontal_collection_method.hcmth_uid%TYPE;
  
  BEGIN
    IF p_hcmth_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT hcmth.hcmth_uid
      INTO v_hcmth_uid
      FROM horizontal_collection_method hcmth
     WHERE upper(hcmth.hcmth_name) = upper(p_hcmth_name);
    RETURN v_hcmth_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_hcmth_uid', 
        'Horizontal Collection Method Name "' || p_hcmth_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_hcmth_uid');
      RETURN NULL;
    
  END get_hcmth_uid;

  /****************************************************************************************
     Get Horizontal Reference Datum UID based on datum code
  ****************************************************************************************/
  FUNCTION get_hrdat_uid
  (
    p_context    IN VARCHAR2,
    p_hrdat_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_hrdat_uid horizontal_reference_datum.hrdat_uid%TYPE;
  
  BEGIN
    IF p_hrdat_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT hrdat.hrdat_uid
      INTO v_hrdat_uid
      FROM horizontal_reference_datum hrdat
     WHERE upper(hrdat.hrdat_name) = upper(p_hrdat_name);
    RETURN v_hrdat_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_hrdat_uid', 
        'Horizontal Reference Datum Code "' || p_hrdat_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_hrdat.uid');
      RETURN NULL;
    
  END get_hrdat_uid;

  /****************************************************************************************
     Get Measurement Unit UID based on unit code
  ****************************************************************************************/
  FUNCTION get_msunt_uid
  (
    p_context  IN VARCHAR2,
    p_msunt_cd IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_msunt_uid measurement_unit.msunt_uid%TYPE;
  
  BEGIN
    IF p_msunt_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT msunt.msunt_uid
      INTO v_msunt_uid
      FROM measurement_unit msunt
     WHERE upper(msunt.msunt_cd) = upper(p_msunt_cd);
    RETURN v_msunt_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_msunt_uid', 
        'Measurement Unit Code "' || p_msunt_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_msunt_uid');
      RETURN NULL;
    
  END get_msunt_uid;

  /****************************************************************************************
     Get Activity Type UID based on type code
  ****************************************************************************************/
  FUNCTION get_actyp_uid
  (
    p_context  IN VARCHAR2,
    p_actyp_cd IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_actyp_uid activity_type.actyp_uid%TYPE;
  
  BEGIN
    IF p_actyp_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT actyp.actyp_uid
      INTO v_actyp_uid
      FROM activity_type actyp
     WHERE upper(actyp.actyp_cd) = upper(p_actyp_cd);
    RETURN v_actyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_actyp_uid', 
        'Activity Type Code "' || p_actyp_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_actyp_uid');
      RETURN NULL;
    
  END get_actyp_uid;

  /****************************************************************************************
     Get Activity Media UID based on name
  ****************************************************************************************/
  FUNCTION get_acmed_uid
  (
    p_context    IN VARCHAR2,
    p_acmed_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_acmed_uid activity_media.acmed_uid%TYPE;
  
  BEGIN
    IF p_acmed_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT acmed.acmed_uid
      INTO v_acmed_uid
      FROM activity_media acmed
     WHERE upper(acmed.acmed_name) = upper(p_acmed_name);
    RETURN v_acmed_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_acmed_uid', 
        'Activity Media Name "' || p_acmed_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_acmed_uid');
      RETURN NULL;
    
  END get_acmed_uid;

  /****************************************************************************************
     Get Activity media subdivision UID based on name
  ****************************************************************************************/
  FUNCTION get_amsub_uid
  (
    p_context    IN VARCHAR2,
    p_amsub_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_amsub_uid activity_media_subdivision.amsub_uid%TYPE;
  
  BEGIN
    IF p_amsub_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT amsub.amsub_uid
      INTO v_amsub_uid
      FROM activity_media_subdivision amsub
     WHERE upper(amsub.amsub_name) = upper(p_amsub_name);
    RETURN v_amsub_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_amsub_uid', 
        'Activity Media Subdivison Name "' || p_amsub_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_amsub_uid');
      RETURN NULL;
    
  END get_amsub_uid;

  /****************************************************************************************
     Get Address Type UID based on name
  ****************************************************************************************/
  FUNCTION get_addtyp_uid
  (
    p_context     IN VARCHAR2,
    p_addtyp_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_addtyp_uid address_type.addtyp_uid%TYPE;
  
  BEGIN
    IF p_addtyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT addtyp.addtyp_uid
      INTO v_addtyp_uid
      FROM address_type addtyp
     WHERE upper(addtyp.addtyp_name) = upper(p_addtyp_name);
    RETURN v_addtyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_addtyp_uid', 
        'Address Type Name "' || p_addtyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_addtyp_uid');
      RETURN NULL;
    
  END get_addtyp_uid;

  /****************************************************************************************
     Get Tribe UID based on code
  ****************************************************************************************/
  FUNCTION get_trb_uid
  (
    p_context IN VARCHAR2,
    p_trb_cd  IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_trb_uid tribe.trb_uid%TYPE;
  
  BEGIN
    IF p_trb_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT trb.trb_uid
      INTO v_trb_uid
      FROM tribe trb
     WHERE upper(trb.trb_cd) = upper(p_trb_cd);
    RETURN v_trb_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_trb_uid', 
        'Tribal Code "' || p_trb_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_trb_uid');
      RETURN NULL;
    
  END get_trb_uid;

  /****************************************************************************************
     Get Electronic Address Type UID based on name
  ****************************************************************************************/
  FUNCTION get_eatyp_uid
  (
    p_context    IN VARCHAR2,
    p_eatyp_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_eatyp_uid electronic_address_type.eatyp_uid%TYPE;
  
  BEGIN
    IF p_eatyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT eatyp.eatyp_uid
      INTO v_eatyp_uid
      FROM electronic_address_type eatyp
     WHERE upper(eatyp.eatyp_name) = upper(p_eatyp_name);
    RETURN v_eatyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_eatyp_uid', 
        'Electronic Address Type Name "' || p_eatyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_eatyp_uid');
      RETURN NULL;
    
  END get_eatyp_uid;

  /****************************************************************************************
     Get Phone type UID based on type name
  ****************************************************************************************/
  FUNCTION get_phtyp_uid
  (
    p_context    IN VARCHAR2,
    p_phtyp_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_phtyp_uid phone_type.phtyp_uid%TYPE;
  
  BEGIN
    IF p_phtyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT phtyp.phtyp_uid
      INTO v_phtyp_uid
      FROM phone_type phtyp
     WHERE upper(phtyp.phtyp_name) = upper(p_phtyp_name);
    RETURN v_phtyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_phtyp_uid', 
        'Phone Type Name "' || p_phtyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_phtyp_uid');
      RETURN NULL;
    
  END get_phtyp_uid;

  /****************************************************************************************
     Get Sample Collection Equip UID based on name
  ****************************************************************************************/
  FUNCTION get_sceqp_uid
  (
    p_context    IN VARCHAR2,
    p_sceqp_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_sceqp_uid sample_collection_equip.sceqp_uid%TYPE;
  
  BEGIN
    IF p_sceqp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT sceqp.sceqp_uid
      INTO v_sceqp_uid
      FROM sample_collection_equip sceqp
     WHERE upper(sceqp.sceqp_name) = upper(p_sceqp_name);
    RETURN v_sceqp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_sceqp_uid', 
        'Sample Collection Equipment Name "' || p_sceqp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_sceqp_uid');
      RETURN NULL;
    
  END get_sceqp_uid;

  /****************************************************************************************
     Get Sample Tissue Anatomy UID based on name
  ****************************************************************************************/
  FUNCTION get_stant_uid
  (
    p_context    IN VARCHAR2,
    p_stant_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_stant_uid sample_tissue_anatomy.stant_uid%TYPE;
  
  BEGIN
    IF p_stant_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT stant.stant_uid
      INTO v_stant_uid
      FROM sample_tissue_anatomy stant
     WHERE upper(stant.stant_name) = upper(p_stant_name);
    RETURN v_stant_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_stant_uid', 
        'Sample Tissue Anatomy Name "' || p_stant_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_stant_uid');
      RETURN NULL;
    
  END get_stant_uid;

  /****************************************************************************************
     Get Container Type UID based on name
  ****************************************************************************************/
  FUNCTION get_contyp_uid
  (
    p_context     IN VARCHAR2,
    p_contyp_name IN VARCHAR2
  ) RETURN NUMBER IS
  
    v_contyp_uid container_type.contyp_uid%TYPE;
  
  BEGIN
    IF p_contyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT contyp.contyp_uid
      INTO v_contyp_uid
      FROM container_type contyp
     WHERE upper(contyp.contyp_name) = upper(p_contyp_name);
    RETURN v_contyp_uid;
    
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_contyp_uid', 
        'Sample Container Type Name "' || p_contyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_contyp_uid');
      RETURN NULL;
    
  END get_contyp_uid;

  /****************************************************************************************
     Get Thermal Preservative UID based on method name
  ****************************************************************************************/
  FUNCTION get_thprsv_uid
  (
    p_context     IN VARCHAR2,
    p_thprsv_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_thprsv_uid thermal_preservative.thprsv_uid%TYPE;
  
  BEGIN
    IF p_thprsv_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT thprsv.thprsv_uid
      INTO v_thprsv_uid
      FROM thermal_preservative thprsv
     WHERE upper(thprsv.thprsv_name) = upper(p_thprsv_name);
    RETURN v_thprsv_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_tpmth_uid', 
        'Thermal Preservative Used Name "' || p_thprsv_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_thprsv_uid');
      RETURN NULL;
    
  END get_thprsv_uid;

  /****************************************************************************************
     Get Container Color UID based on name
  ****************************************************************************************/
  FUNCTION get_concol_uid
  (
    p_context     IN VARCHAR2,
    p_concol_name IN VARCHAR2
  ) RETURN NUMBER IS
  
    v_concol_uid container_color.concol_uid%TYPE;
  
  BEGIN
    IF p_concol_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT concol.concol_uid
      INTO v_concol_uid
      FROM container_color concol
     WHERE upper(concol.concol_name) = upper(p_concol_name);
    RETURN v_concol_uid;
    
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_concol_uid', 'Container Color Name "' ||
                           p_concol_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_concol_uid');
      RETURN NULL;
    
  END get_concol_uid;
  /****************************************************************************************
     Get Characteristic UID based on name
  ****************************************************************************************/
  FUNCTION get_chr_uid (
    p_context      IN VARCHAR2,
    p_chr_name     IN VARCHAR2,
    p_pick_list_yn OUT VARCHAR2)
  
    RETURN NUMBER IS
  
    v_chr_uid         characteristic.chr_uid%TYPE;
    v_pick_list_yn    characteristic.chr_pick_list_yn%TYPE;
  
  BEGIN
    IF p_chr_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT chr.chr_uid, chr.chr_pick_list_yn
      INTO v_chr_uid, v_pick_list_yn
      FROM characteristic chr
      WHERE upper(chr.chr_name) = upper(p_chr_name);
    p_pick_list_yn := v_pick_list_yn;
    RETURN v_chr_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_chr_uid', 
        'Characteristic Name "' || p_chr_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_chr_uid');
      RETURN NULL;
    
  END get_chr_uid;

  /****************************************************************************************
     Get Relative Depth UID based on name
  ****************************************************************************************/
  FUNCTION get_reldpth_uid
  (
    p_context      IN VARCHAR2,
    p_reldpth_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_reldpth_uid relative_depth.reldpth_uid%TYPE;
  
  BEGIN
    IF p_reldpth_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT reldpth.reldpth_uid
      INTO v_reldpth_uid
      FROM relative_depth reldpth
     WHERE upper(reldpth.reldpth_name) = upper(p_reldpth_name);
    RETURN v_reldpth_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_reldpth_uid', 'Relative Depth Name "' ||
                           p_reldpth_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_reldpth_uid');
      RETURN NULL;
    
  END get_reldpth_uid;

  /****************************************************************************************
     Get Result status UID based on name
  ****************************************************************************************/
  FUNCTION get_ressta_uid
  (
    p_context     IN VARCHAR2,
    p_ressta_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_ressta_uid result_status.ressta_uid%TYPE;
  
  BEGIN
    IF p_ressta_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT ressta.ressta_uid
      INTO v_ressta_uid
      FROM result_status ressta
     WHERE upper(ressta.ressta_name) = upper(p_ressta_name);
    RETURN v_ressta_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_ressta_uid', 'Result Status Name "' ||
                           p_ressta_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_ressta_uid');
      RETURN NULL;
    
  END get_ressta_uid;

  /****************************************************************************************
     Get Result value type UID based on name
  ****************************************************************************************/
  FUNCTION get_rvtyp_uid
  (
    p_context    IN VARCHAR2,
    p_rvtyp_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rvtyp_uid result_value_type.rvtyp_uid%TYPE;
  
  BEGIN
    IF p_rvtyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rvtyp.rvtyp_uid
      INTO v_rvtyp_uid
      FROM result_value_type rvtyp
     WHERE upper(rvtyp.rvtyp_name) = upper(p_rvtyp_name);
    RETURN v_rvtyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rvtyp_uid', 'Result Value Type Name "' ||
                           p_rvtyp_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rvtyp_uid');
      RETURN NULL;
    
  END get_rvtyp_uid;

  /****************************************************************************************
     Get Result Lab Comment UID based on code
  ****************************************************************************************/
  FUNCTION get_rlcom_uid
  (
    p_context  IN VARCHAR2,
    p_rlcom_cd IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rlcom_uid result_lab_comment.rlcom_uid%TYPE;
  
  BEGIN
    IF p_rlcom_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rlcom.rlcom_uid
      INTO v_rlcom_uid
      FROM result_lab_comment rlcom
     WHERE upper(rlcom.rlcom_cd) = upper(p_rlcom_cd);
    RETURN v_rlcom_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rlcom_uid', 'Result Lab Comment code "' ||
                           p_rlcom_cd ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rlcom_uid');
      RETURN NULL;
    
  END get_rlcom_uid;

  /****************************************************************************************
     Get Result statistical base UID based on code
  ****************************************************************************************/
  FUNCTION get_rsbas_uid
  (
    p_context  IN VARCHAR2,
    p_rsbas_cd IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rsbas_uid result_statistical_base.rsbas_uid%TYPE;
  
  BEGIN
    IF p_rsbas_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rsbas.rsbas_uid
      INTO v_rsbas_uid
      FROM result_statistical_base rsbas
     WHERE upper(rsbas.rsbas_cd) = upper(p_rsbas_cd);
    RETURN v_rsbas_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_rsbas_uid', 
        'Result Statistical Base Code "' || p_rsbas_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rsbas_uid');
      RETURN NULL;
    
  END get_rsbas_uid;

  /****************************************************************************************
     Get Result detection condition UID based on code
  ****************************************************************************************/
  FUNCTION get_rdcnd_uid
  (
    p_context    IN VARCHAR2,
    p_rdcnd_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rdcnd_uid result_detection_condition.rdcnd_uid%TYPE;
  
  BEGIN
    IF p_rdcnd_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rdcnd.rdcnd_uid
      INTO v_rdcnd_uid
      FROM result_detection_condition rdcnd
     WHERE upper(rdcnd.rdcnd_name) = upper(p_rdcnd_name);
    RETURN v_rdcnd_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_rdcnd_uid', 
        'Result Detection Condition Name "' || p_rdcnd_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rdcnd_uid');
      RETURN NULL;
    
  END get_rdcnd_uid;

  /****************************************************************************************
     Get Sample fraction UID based on name
  ****************************************************************************************/
  FUNCTION get_smfrc_uid
  (
    p_context    IN VARCHAR2,
    p_smfrc_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_smfrc_uid sample_fraction.smfrc_uid%TYPE;
  
  BEGIN
    IF p_smfrc_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT smfrc.smfrc_uid
      INTO v_smfrc_uid
      FROM sample_fraction smfrc
     WHERE upper(smfrc.smfrc_name) = upper(p_smfrc_name);
    RETURN v_smfrc_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_smfrc_uid', 'Sample Fraction Name "' ||
                           p_smfrc_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_smfrc_uid');
      RETURN NULL;
    
  END get_smfrc_uid;

  /****************************************************************************************
     Get Result temperature basis UID based on name
  ****************************************************************************************/
  FUNCTION get_rtmpb_uid
  (
    p_context    IN VARCHAR2,
    p_rtmpb_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rtmpb_uid result_temperature_basis.rtmpb_uid%TYPE;
  
  BEGIN
    IF p_rtmpb_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rtmpb.rtmpb_uid
      INTO v_rtmpb_uid
      FROM result_temperature_basis rtmpb
     WHERE upper(rtmpb.rtmpb_name) = upper(p_rtmpb_name);
    RETURN v_rtmpb_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rtmpb_uid', 'Result Temp Basis "' ||
                           p_rtmpb_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rtmpb_uid');
      RETURN NULL;
    
  END get_rtmpb_uid;

  /****************************************************************************************
     Get Result time basis UID based on name
  ****************************************************************************************/
  FUNCTION get_rtimb_uid
  (
    p_context    IN VARCHAR2,
    p_rtimb_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rtimb_uid result_time_basis.rtimb_uid%TYPE;
  
  BEGIN
    IF p_rtimb_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rtimb.rtimb_uid
      INTO v_rtimb_uid
      FROM result_time_basis rtimb
     WHERE upper(rtimb.rtimb_name) = upper(p_rtimb_name);
    RETURN v_rtimb_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rtimb_uid', 'Result Time Basis Name "' ||
                           p_rtimb_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rtimb_uid');
      RETURN NULL;
    
  END get_rtimb_uid;

  /****************************************************************************************
     Get Result weight basis UID based on name
  ****************************************************************************************/
  FUNCTION get_rwbas_uid
  (
    p_context    IN VARCHAR2,
    p_rwbas_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_rwbas_uid result_weight_basis.rwbas_uid%TYPE;
  
  BEGIN
    IF p_rwbas_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rwbas.rwbas_uid
      INTO v_rwbas_uid
      FROM result_weight_basis rwbas
     WHERE upper(rwbas.rwbas_name) = upper(p_rwbas_name);
    RETURN v_rwbas_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_rwbas_uid', 
        'Result Weight Basis Name "' || p_rwbas_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rwbas_uid');
      RETURN NULL;
    
  END get_rwbas_uid;

  /****************************************************************************************
   Get Detection Quantitation Limit Type UID based on name
  ****************************************************************************************/
  FUNCTION get_dqltyp_uid (
    p_context     IN VARCHAR2,
    p_dqltyp_name IN VARCHAR2)
  
    RETURN NUMBER IS
  
    v_dqltyp_uid detection_quant_limit_type.dqltyp_uid%TYPE;
  
  BEGIN
    IF p_dqltyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT dqltyp.dqltyp_uid
      INTO v_dqltyp_uid
      FROM detection_quant_limit_type dqltyp
     WHERE upper(dqltyp.dqltyp_name) = upper(p_dqltyp_name);
    RETURN v_dqltyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_dqltyp_uid', 
        'Detection Quantitation Limit Type Name "' || p_dqltyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_dqltyp_uid');
      RETURN NULL;
    
  END get_dqltyp_uid;

  /****************************************************************************************
     Get Taxon UID based on name
  ****************************************************************************************/
  FUNCTION get_tax_uid
  (
    p_context  IN VARCHAR2,
    p_tax_name IN VARCHAR2
  )
  
   RETURN NUMBER IS
  
    v_tax_uid taxon.tax_uid%TYPE;
  
  BEGIN
    IF p_tax_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT tax.tax_uid
      INTO v_tax_uid
      FROM taxon tax
     WHERE upper(tax.tax_name) = upper(p_tax_name);
    RETURN v_tax_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_tax_uid', 'Taxon Name "' ||
                           p_tax_name ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_tax_uid');
      RETURN NULL;
    
  END get_tax_uid;

  /****************************************************************************************
     Get Time Zone UID based on code
  ****************************************************************************************/
  FUNCTION get_tmzone_uid
  (
    p_context   IN VARCHAR2,
    p_tmzone_cd IN VARCHAR2
  ) RETURN NUMBER IS
  
    v_tmzone_uid time_zone.tmzone_uid%TYPE;
  
  BEGIN
    IF p_tmzone_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT tmzone.tmzone_uid
      INTO v_tmzone_uid
      FROM time_zone tmzone
     WHERE upper(tmzone.tmzone_cd) = upper(p_tmzone_cd);
    RETURN v_tmzone_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_tmzone_uid', 'Time Zone Code "' ||
                           p_tmzone_cd ||
                           '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_tmzone_uid');
      RETURN NULL;
    
  END get_tmzone_uid;

  /****************************************************************************************
   Get Characteristic Pick List Value UID based on code
  ****************************************************************************************/
  FUNCTION get_cplval_uid (
    p_context     IN VARCHAR2,
    p_chr_uid     IN VARCHAR2,
    p_cplval_cd   IN VARCHAR2) 
    
    RETURN NUMBER IS
  
    v_cplval_uid characteristic_pick_list_value.cplval_uid%TYPE;
  
  BEGIN
    IF p_cplval_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT cplval.cplval_uid
      INTO v_cplval_uid
      FROM characteristic_pick_list_value cplval
      WHERE cplval.chr_uid = p_chr_uid
        AND upper(cplval.cplval_cd) = upper(p_cplval_cd);
    RETURN v_cplval_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_cplval_uid', 
        'Result Measure Value "' || p_cplval_cd || '" does not match a value in the '
          || 'Characteristic Pick List');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_cplval_uid');
      RETURN NULL;
    
  END get_cplval_uid;

  /****************************************************************************************
     Get Result Measure Qualifier UID based on code
  ****************************************************************************************/
  FUNCTION get_rmqlf_uid (
    p_context  IN VARCHAR2,
    p_rmqlf_cd IN VARCHAR2) 
    
    RETURN NUMBER IS
  
    v_rmqlf_uid result_measure_qualifier.rmqlf_uid%TYPE;
  
  BEGIN
    IF p_rmqlf_cd IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT rmqlf.rmqlf_uid
      INTO v_rmqlf_uid
      FROM result_measure_qualifier rmqlf
     WHERE upper(rmqlf.rmqlf_cd) = upper(p_rmqlf_cd);
    RETURN v_rmqlf_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_rmqlf_uid', 
        'Result Measure Qualifier Code "' || p_rmqlf_cd || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_rmqlf_uid');
      RETURN NULL;
    
  END get_rmqlf_uid;

  /****************************************************************************************
   Get USER UID based on NAAS ID
  ****************************************************************************************/
  FUNCTION get_usr_uid (
    p_context     IN VARCHAR2,
    p_usr_naas_id IN VARCHAR2) 
    
    RETURN NUMBER IS
  
    v_usr_uid user_list.usr_uid%TYPE;
    v_context transaction_log_detail.tldet_context%TYPE;
  
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'User NAAS ID = "' || p_usr_naas_id || '"');
    IF p_usr_naas_id IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT u.usr_uid
      INTO v_usr_uid
      FROM user_list u
     WHERE upper(u.usr_naas_id) = upper(p_usr_naas_id);
    RETURN v_usr_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        v_context, 
        'lookup_tbl_pkg.get_usr_uid', 
        'Unauthorized User "' || p_usr_naas_id || '".  Before you can submit data to WQX your CDX user name must be '
          || 'added to the WQX system, your organization must be added to the system, ' 
          || 'and you must be granted rights to that organization.  Contact STORET/WQX '
          || 'Support for assistance.',
        lib_pkg.c_err_fatal);
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'lookup_tbl_pkg.get_usr_uid');
      RETURN NULL;
    
  END get_usr_uid;
  
  /****************************************************************************************
     Get Analytical Method UID based on Context code and Analytical Method ID
  ****************************************************************************************/
  FUNCTION get_anlmth_uid
  (
    p_context          IN VARCHAR2,
    p_amctx_cd         IN analytical_method_context.amctx_cd%TYPE,
    p_anlmth_id        IN analytical_method.anlmth_id%TYPE,
    p_anlmth_name      IN analytical_method.anlmth_name%TYPE := NULL,
    p_anlmth_desc      IN analytical_method.anlmth_desc%TYPE := NULL,
    p_anlmth_qual_type IN analytical_method.anlmth_qual_type%TYPE := NULL
  ) RETURN NUMBER IS
  
    v_amctx_uid            analytical_method_context.amctx_uid%TYPE := NULL;
    v_amctx_name           analytical_method_context.amctx_name%TYPE;
    v_anlmth_uid           analytical_method.anlmth_uid%TYPE := NULL;
    v_amctx_epa_managed_yn analytical_method_context.amctx_epa_managed_yn%TYPE := 'N';
    v_new_context          BOOLEAN;
  
  BEGIN
    IF p_amctx_cd IS NULL AND p_anlmth_id IS NULL THEN
      RETURN NULL;
    END IF;
    -- lookup the analytical method context
    BEGIN
      SELECT c.amctx_uid,
             c.amctx_name,
             c.amctx_epa_managed_yn
        INTO v_amctx_uid,
             v_amctx_name, 
             v_amctx_epa_managed_yn
        FROM analytical_method_context c
        WHERE upper(c.amctx_cd) = upper(p_amctx_cd)
          AND (c.amctx_epa_managed_yn = 'Y' 
               OR c.org_uid = organization_pkg.get_org_uid);
      v_new_context := FALSE;
    EXCEPTION
      WHEN no_data_found THEN
        IF p_amctx_cd = organization_pkg.get_org_id THEN
          v_new_context := TRUE;
          v_amctx_epa_managed_yn := 'N';
        ELSE
          lib_pkg.raise_error(
            p_context, 
            'lookup_tbl_pkg.get_anlmth_uid', 
            'Analytical Method Identifier Context (' || p_amctx_cd || ') is invalid.  '
              || 'The value must match a value from the domain list or be the same as your '
              || 'Organization Identifier if it''s your own private method).');
          RETURN NULL;
        END IF;
    END;
    IF v_amctx_epa_managed_yn = 'N' AND p_anlmth_name IS NULL THEN
      lib_pkg.raise_error(
        p_context,
        'lookup_tbl_pkg.get_anlmth_uid',
        'Method Name is required for Result Analytical Method when the '
          || 'Method Identifier Context belongs to your organization');
      RETURN NULL;
    END IF;  
    -- insert/update the analytical method context
    IF v_new_context THEN
      SELECT org.org_name
        INTO v_amctx_name
        FROM organization org
        WHERE org.org_id = p_amctx_cd;
      INSERT INTO analytical_method_context
        (amctx_uid,
         org_uid,
         amctx_cd,
         amctx_name,
         amctx_epa_managed_yn,
         amctx_last_change_date)
      VALUES
        (amctx_seq.NEXTVAL,
         organization_pkg.get_org_uid,
         p_amctx_cd,
         v_amctx_name,
         'N',
         systimestamp)
      RETURNING amctx_uid INTO v_amctx_uid;
    ELSIF v_amctx_epa_managed_yn = 'N' THEN
      -- can only update analytical method context if not EPA managed
      UPDATE analytical_method_context
        SET org_uid = organization_pkg.get_org_uid,
            amctx_cd = p_amctx_cd,
            amctx_name = v_amctx_name,
            amctx_epa_managed_yn = v_amctx_epa_managed_yn,
            amctx_last_change_date = systimestamp
        WHERE amctx_uid = v_amctx_uid;
    END IF;
    -- look up the analytical method
    BEGIN
      SELECT anlmth.anlmth_uid
        INTO v_anlmth_uid
        FROM analytical_method anlmth
       WHERE upper(anlmth.anlmth_id) = upper(p_anlmth_id)
         AND anlmth.amctx_uid = v_amctx_uid;
      IF v_amctx_epa_managed_yn = 'Y' THEN
        -- can't update EPA managed analytical methods
        RETURN v_anlmth_uid;
      ELSE
        -- otherwise update org. analytical method
        UPDATE analytical_method
           SET org_uid = organization_pkg.get_org_uid,
               anlmth_id = p_anlmth_id,
               anlmth_name = p_anlmth_name,
               anlmth_desc = p_anlmth_desc,
               anlmth_qual_type = p_anlmth_qual_type,
               anlmth_last_change_date = systimestamp
         WHERE anlmth_uid = v_anlmth_uid;
        RETURN v_anlmth_uid;
      END IF;
      
    EXCEPTION
      WHEN no_data_found THEN
        IF v_amctx_epa_managed_yn = 'Y' THEN
          lib_pkg.raise_error(
            p_context, 
            'lookup_tbl_pkg.get_anlmth_uid', 
            'Analytical Method Identifier (' || p_anlmth_id || ') is invalid for the '
              || 'context provided (' || p_amctx_cd || ')');
        ELSE
          INSERT INTO analytical_method (
              anlmth_uid,
              amctx_uid,
              org_uid,
              anlmth_id,
              anlmth_name,
              anlmth_desc,
              anlmth_qual_type,
              anlmth_last_change_date)
            VALUES (
              anlmth_seq.NEXTVAL,
              v_amctx_uid,
              organization_pkg.get_org_uid,
              p_anlmth_id,
              p_anlmth_name,
              p_anlmth_desc,
              p_anlmth_qual_type,
              systimestamp) 
            RETURNING anlmth_uid INTO v_anlmth_uid;
          RETURN v_anlmth_uid;
        END IF;
    END;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_anlmth_uid');
      RETURN NULL;
    
  END get_anlmth_uid;
  
  /****************************************************************************************
   Get Activity Group Type UID
  ****************************************************************************************/
  FUNCTION get_agtyp_uid (
    p_context      IN VARCHAR2,
    p_agtyp_name   IN VARCHAR2) 
    RETURN NUMBER IS
  
    v_agtyp_uid activity_group_type.agtyp_uid%TYPE;
    
  BEGIN
    IF p_agtyp_name IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT agtyp.agtyp_uid
      INTO v_agtyp_uid
      FROM activity_group_type agtyp
      WHERE upper(agtyp.agtyp_name) = upper(p_agtyp_name);
    RETURN v_agtyp_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'lookup_tbl_pkg.get_agtyp_uid', 
        'Activity Group Type Code "' || p_agtyp_name || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'lookup_tbl_pkg.get_agtyp_uid');
      RETURN NULL;
      
  END get_agtyp_uid;
    
END lookup_tbl_pkg;
/

prompt
prompt Creating package body MONITORING_LOCATION_PKG
prompt =============================================
prompt
CREATE OR REPLACE PACKAGE BODY monitoring_location_pkg AS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
    
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

  /****************************************************************************************
     Insert or Update a new row in to the Monitoring Location table.
  ****************************************************************************************/
  PROCEDURE insert_update_row (
    p_context                IN   transaction_log_detail.tldet_context%TYPE,
    p_cntry_cd               IN   country.cntry_cd%TYPE,
    p_cnty_fips_cd           IN   county.cnty_fips_cd%TYPE,
    p_hcmth_name             IN   horizontal_collection_method.hcmth_name%TYPE,
    p_hrdat_name             IN   horizontal_reference_datum.hrdat_name%TYPE,
    p_mloc_desc              IN   monitoring_location.mloc_desc%TYPE,
    p_mloc_huc_12            IN   monitoring_location.mloc_huc_12%TYPE,
    p_mloc_huc_8             IN   monitoring_location.mloc_huc_8%TYPE,
    p_mloc_id                IN   monitoring_location.mloc_id%TYPE,
    p_mloc_latitude          IN   monitoring_location.mloc_latitude%TYPE,
    p_mloc_longitude         IN   monitoring_location.mloc_longitude%TYPE,
    p_mloc_name              IN   monitoring_location.mloc_name%TYPE,
    p_mloc_source_map_scale  IN   monitoring_location.mloc_source_map_scale%TYPE,
    p_mloc_tribal_land_name  IN   monitoring_location.mloc_tribal_land_name%TYPE,
    p_mloc_tribal_land_yn    IN   VARCHAR2, -- need to accomodate values other than Y/N
    p_mloc_vertical_measure  IN   monitoring_location.mloc_vertical_measure%TYPE,
    p_mltyp_name             IN   monitoring_location_type.mltyp_name%TYPE,
    p_msunt_cd               IN   measurement_unit.msunt_cd%TYPE,
    p_st_cd                  IN   state.st_cd%TYPE,
    p_vcmth_name             IN   vertical_collection_method.vcmth_name%TYPE,
    p_vrdat_name             IN   vertical_reference_datum.vrdat_name%TYPE,
    p_mloc_uid               OUT  monitoring_location.mloc_uid%TYPE) AS

    v_context               transaction_log_detail.tldet_context%TYPE;
    v_cntry_uid             monitoring_location.cntry_uid%TYPE;
    v_cnty_uid              monitoring_location.cnty_uid%TYPE;
    v_st_uid                monitoring_location.st_uid%TYPE;
    v_hcmth_uid             monitoring_location.hcmth_uid%TYPE;
    v_hrdat_uid             monitoring_location.hrdat_uid%TYPE;
    v_mltyp_uid             monitoring_location.mltyp_uid%TYPE;
    v_msunt_uid             monitoring_location.msunt_uid%TYPE;
    v_vcmth_uid             monitoring_location.vcmth_uid%TYPE;
    v_vrdat_uid             monitoring_location.vrdat_uid%TYPE;
    v_mloc_tribal_land_yn   monitoring_location.mloc_tribal_land_yn%TYPE;
    v_exists                BOOLEAN := FALSE;
    
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Monitoring Location ID =' || p_mloc_id);
    -- validate parameters
    IF p_mloc_id IS NULL THEN
     lib_pkg.raise_error(
       v_context, 
       'monitoring_location_pkg.insert_update_row', 
       'Monitoring Location ID cannot be blank');
    END IF;
    BEGIN 
      -- Check to see if row already exists to determine insert or update.
      SELECT mloc_uid
        INTO p_mloc_uid    
        FROM monitoring_location
       WHERE mloc_id = p_mloc_id
         AND org_uid = organization_pkg.get_org_uid;
    EXCEPTION
      WHEN no_data_found THEN
        NULL;
    END;
    -- If Vertical Measure value is provided then Measure Unit Code, Vertical Collection 
    -- Method Name, and Vertical Coordinate Reference System Datum Name must be provided.*/
    IF p_mloc_vertical_measure IS NOT NULL THEN
      IF p_msunt_cd IS NULL OR p_vcmth_name IS NULL OR p_vrdat_name IS NULL THEN
        lib_pkg.raise_error(
          v_context,
          'monitoring_location_pkg.insert_update_row',
          'When Vertical Measure''s Measure Value is reported, the following also must be '
            || 'reported: Vertical Measure''s Measure Unit Code, Vertical Collection '
            || 'Method Name, and Vertical Coordinate Reference System Datum Name.');
      END IF;
    END IF;
    -- handle all possible y/n values for tribal land indicator
    IF upper(p_mloc_tribal_land_yn) IN ('TRUE','1','Y') THEN
      v_mloc_tribal_land_yn := 'Y';
    ELSIF upper(p_mloc_tribal_land_yn) IN ('FALSE','0','N') THEN
      v_mloc_tribal_land_yn := 'N';
    ELSIF p_mloc_tribal_land_yn IS NULL THEN
      v_mloc_tribal_land_yn := NULL;
    ELSE
      lib_pkg.raise_error(
        v_context,
        'monitoring_location_pkg.insert_update_row',
        'Invalid value for Tribal Land Indicator (' || p_mloc_tribal_land_yn 
          || ').  Must be true or false. ');
    END IF;    
  
    -- Initalize variables with UID's from lookup tables.
    v_cntry_uid   := lookup_tbl_pkg.get_cntry_uid(v_context, p_cntry_cd);
    v_st_uid      := lookup_tbl_pkg.get_st_uid(v_context, p_st_cd);
    v_cnty_uid    := lookup_tbl_pkg.get_cnty_uid(v_context, p_cnty_fips_cd, v_st_uid);
    v_hcmth_uid   := lookup_tbl_pkg.get_hcmth_uid(v_context, p_hcmth_name);
    v_hrdat_uid   := lookup_tbl_pkg.get_hrdat_uid(v_context, p_hrdat_name);
    v_mltyp_uid   := lookup_tbl_pkg.get_mltyp_uid(v_context, p_mltyp_name);
    v_msunt_uid   := lookup_tbl_pkg.get_msunt_uid(v_context, p_msunt_cd);
    v_vcmth_uid   := lookup_tbl_pkg.get_vcmth_uid(v_context, p_vcmth_name);
    v_vrdat_uid   := lookup_tbl_pkg.get_vrdat_uid(v_context, p_vrdat_name);
  
    IF v_hcmth_uid = lib_pkg.c_hcmth_interpolation_map AND p_mloc_source_map_scale IS NULL THEN
      lib_pkg.raise_error(
        v_context,
        'monitoring_location_pkg.insert_update_row',
        'If Horizontal Collection Method Name is "' || p_hcmth_name || '" then Source Map Scale'
          || ' must be provided');
    END IF;
    
    IF p_mloc_uid IS NULL THEN  
      -- Get next sequence value and put into out parameter.
      SELECT mloc_seq.NEXTVAL
        INTO p_mloc_uid
        FROM dual; 
      INSERT INTO monitoring_location (
         cntry_uid,
         cnty_uid,
         hcmth_uid,
         hrdat_uid,
         mloc_desc,
         mloc_huc_12,
         mloc_huc_8,
         mloc_id,
         mloc_last_change_date,
         mloc_latitude,
         mloc_longitude,
         mloc_name,
         mloc_source_map_scale,
         mloc_tribal_land_name,
         mloc_tribal_land_yn,
         mloc_uid,
         mloc_vertical_measure,
         mltyp_uid,
         msunt_uid,
         org_uid,
         st_uid,
         vcmth_uid,
         vrdat_uid)
       VALUES (
         v_cntry_uid,
         v_cnty_uid,
         v_hcmth_uid,
         v_hrdat_uid,
         p_mloc_desc,
         p_mloc_huc_12,
         p_mloc_huc_8,
         p_mloc_id,
         SYSTIMESTAMP, 
         p_mloc_latitude,
         p_mloc_longitude,
         p_mloc_name,
         p_mloc_source_map_scale,
         p_mloc_tribal_land_name,
         v_mloc_tribal_land_yn,
         p_mloc_uid,
         p_mloc_vertical_measure,
         v_mltyp_uid,
         v_msunt_uid,
         organization_pkg.get_org_uid,
         v_st_uid,
         v_vcmth_uid,
         v_vrdat_uid);

      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert, 
        lib_pkg.c_tbl_monitoring_location, 
        p_mloc_uid,
        p_mloc_id);
    ELSE
      v_exists := TRUE;
      -- Delete child records
      delete_mloc_alt(v_context,p_mloc_uid);
        
      UPDATE monitoring_location
        SET cntry_uid             = v_cntry_uid,
            cnty_uid              = v_cnty_uid,
            hcmth_uid             = v_hcmth_uid,
            hrdat_uid             = v_hrdat_uid,
            mloc_desc             = p_mloc_desc,
            mloc_huc_12           = p_mloc_huc_12,
            mloc_huc_8            = p_mloc_huc_8,
            mloc_id               = p_mloc_id,
            mloc_last_change_date = SYSTIMESTAMP,
            mloc_latitude         = p_mloc_latitude,
            mloc_longitude        = p_mloc_longitude,
            mloc_name             = p_mloc_name,
            mloc_source_map_scale = p_mloc_source_map_scale,
            mloc_tribal_land_name = p_mloc_tribal_land_name,
            mloc_tribal_land_yn   = v_mloc_tribal_land_yn,
            mloc_vertical_measure = p_mloc_vertical_measure,
            mltyp_uid             = v_mltyp_uid,
            msunt_uid             = v_msunt_uid,
            org_uid               = organization_pkg.get_org_uid,
            st_uid                = v_st_uid,
            vcmth_uid             = v_vcmth_uid,
            vrdat_uid             = v_vrdat_uid
        WHERE mloc_uid = p_mloc_uid;       
    
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_update, 
        lib_pkg.c_tbl_monitoring_location, 
        p_mloc_uid,
        p_mloc_id);
    END IF;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'monitoring_location_pkg.insert_update_row');
      IF v_exists THEN
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_update, 
          lib_pkg.c_tbl_monitoring_location, 
          p_mloc_uid,
          p_mloc_id,
          'N');
      ELSE 
        v_tlaud_uid := transaction_log_pkg.insert_audit(
          lib_pkg.c_audtyp_audit_insert, 
          lib_pkg.c_tbl_monitoring_location, 
          p_mloc_uid,
          p_mloc_id,
          'N');      
      END IF;
      
  END insert_update_row;
  
  /****************************************************************************************
     Insert a new row in to the Monitoring Location Alternate table.
  ****************************************************************************************/
  PROCEDURE alt_mloc_insert_row (
    p_context                IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid               IN  monitoring_location_alternate.mloc_uid%TYPE,
    p_mlalt_id               IN  monitoring_location_alternate.mlalt_id%TYPE,
    p_mlalt_context          IN  monitoring_location_alternate.mlalt_context%TYPE) AS
    
    v_context       transaction_log_detail.tldet_context%TYPE;
     
  BEGIN
    v_context := lib_pkg.context_concat(
      p_context, 
      'Alternate Monitoring Location Identifier =' || p_mlalt_id); 
    IF p_mloc_uid IS NULL THEN
      lib_pkg.raise_error(
        p_context, 
        'monitoring_location_pkg.alt_mloc_insert_row', 
        'Monitoring Location UID is required');
    END IF;
    IF p_mlalt_id IS NULL THEN
      lib_pkg.raise_error(
        p_context, 
        'monitoring_location_pkg.alt_mloc_insert_row', 
        'Alternate Monitoring Location Identifier is required');
    END IF;
    INSERT INTO monitoring_location_alternate (
        mloc_uid, 
        org_uid, 
        mlalt_id, 
        mlalt_context, 
        mlalt_last_change_date)
      VALUES (
        p_mloc_uid,
        organization_pkg.get_org_uid,
        p_mlalt_id,
        p_mlalt_context,
        SYSTIMESTAMP);
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'monitoring_location_pkg.alt_mloc_insert_row');
  
  END alt_mloc_insert_row;   
  
  /****************************************************************************************
   Delete a row in Monitoring Location by primary key 
  ****************************************************************************************/
  PROCEDURE delete_row (
    p_context                IN   transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid               IN   monitoring_location.mloc_uid%TYPE,
    p_mloc_id                IN   monitoring_location.mloc_id%TYPE) AS
  
    v_mloc_id     monitoring_location.mloc_id%TYPE;
      
  BEGIN
    -- validate parameters
    IF p_mloc_uid IS NULL THEN
      lib_pkg.raise_error(
        p_context, 
        'monitoring_location_pkg.delete_row', 
        'Monitoring Location UID is required');
    END IF;
    -- delete Child Records first if needed
    activity_pkg.delete_rows_by_mloc_uid(p_context, p_mloc_uid);
    
    -- delete alternate locations
    delete_mloc_alt(p_context, p_mloc_uid);
    
    -- delete attached objects for mloc uid
    attached_object_pkg.delete_rows_by_table_ref(
      p_context, p_mloc_uid, 2);
    DELETE
      FROM monitoring_location
      WHERE mloc_uid = p_mloc_uid
      RETURN mloc_id INTO v_mloc_id;
    IF SQL%ROWCOUNT > 0 THEN
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_monitoring_location,
        p_mloc_uid,
        v_mloc_id);
    END IF;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context, 
        'monitoring_location_pkg.delete_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_monitoring_location,
        p_mloc_uid,
        p_mloc_id,
        'N');
  
  END delete_row;
  
  /****************************************************************************************
   Delete row by Monitoring Location ID
  ****************************************************************************************/ 
  PROCEDURE delete_row_by_mloc_id (
    p_context                IN   transaction_log_detail.tldet_context%TYPE,
    p_mloc_id                IN   monitoring_location.mloc_id%TYPE) AS
    
    v_context   transaction_log_detail.tldet_context%TYPE;
    v_mloc_uid  monitoring_location.mloc_uid%TYPE;                                                    
    
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Monitoring Location Identifier = ' 
      || p_mloc_id);
    BEGIN
      SELECT mloc_uid
        INTO v_mloc_uid
        FROM monitoring_location
        WHERE upper(mloc_id) = upper(p_mloc_id)
          AND org_uid = organization_pkg.get_org_uid;
      delete_row(p_context, v_mloc_uid, p_mloc_id); 
    EXCEPTION
      WHEN OTHERS THEN
        transaction_log_pkg.insert_warning(
          'Monitoring Location could not be deleted.  Monitoring Location Identifier "' 
            || p_mloc_id || '" not found.', v_context);
    END;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'monitoring_location_pkg.delete_row_by_mloc_id');
  
  END delete_row_by_mloc_id;  
  
  /****************************************************************************************
     Delete Monitoring Location Alternate rows
  ****************************************************************************************/ 
  PROCEDURE delete_mloc_alt (
    p_context               IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_uid              IN  monitoring_location_alternate.mloc_uid%TYPE) AS
  
  BEGIN
    DELETE 
      FROM monitoring_location_alternate mlalt
      WHERE mlalt.mloc_uid = p_mloc_uid;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'monitoring_location_pkg.delete_mloc_alt');
  
  END delete_mloc_alt;   
  
  /****************************************************************************************
    Get Monitoring Location UID given an ID
  ****************************************************************************************/ 
  FUNCTION get_mloc_uid (
    p_context               IN  transaction_log_detail.tldet_context%TYPE,
    p_mloc_id               IN  monitoring_location.mloc_id%TYPE)
    
    RETURN NUMBER IS
  
    v_mloc_uid  monitoring_location.mloc_uid%TYPE;
  
  BEGIN
    IF p_mloc_id IS NULL THEN
      RETURN NULL;
    END IF;
    SELECT mloc.mloc_uid
      INTO v_mloc_uid
      FROM monitoring_location mloc
      WHERE upper(mloc.mloc_id) = upper(p_mloc_id)
        AND mloc.org_uid = organization_pkg.get_org_uid;
    RETURN v_mloc_uid;
  
  EXCEPTION
    WHEN no_data_found THEN
      lib_pkg.raise_error(
        p_context, 
        'monitoring_location_pkg.get_mloc_uid', 
        'Monitoring Location ID "' || p_mloc_id || '" is invalid');
      RETURN NULL;
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'monitoring_location_pkg.get_mloc_uid');
      RETURN NULL;
    
  END get_mloc_uid;

END monitoring_location_pkg;
/

prompt
prompt Creating package body ORGANIZATION_PKG
prompt ======================================
prompt
CREATE OR REPLACE PACKAGE BODY organization_pkg AS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_org_uid   organization.org_uid%TYPE;
  v_org_id    organization.org_id%TYPE;
   
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/
  
/****************************************************************************************
  Function to return the Org UID from the organization table.                                                             
 ****************************************************************************************/
FUNCTION get_org_uid(
  p_org_id  IN organization.org_id%TYPE := NULL) 
  
  RETURN organization.org_uid%TYPE AS
  
BEGIN
  IF p_org_id IS NOT NULL THEN
    IF v_org_id IS NOT NULL THEN
      IF p_org_id = v_org_id THEN
        -- don't bother looking it up we already have it.
        RETURN v_org_uid;
      END IF;
    END IF;
    SELECT org_uid
      INTO v_org_uid
      FROM organization
      WHERE org_id = upper(p_org_id);
    v_org_id := p_org_id;
  END IF;
  
  RETURN v_org_uid;
  
EXCEPTION 
  WHEN no_data_found THEN
    lib_pkg.raise_error(
      'Organization Identifier =' || p_org_id,
      'organization_pkg.get_org_uid',
      'Organization Identifier "' || p_org_id || '" is invalid.  '
        || 'Before you can submit data to WQX your CDX user name must be '
        || 'added to the WQX system, your organization must be added to the system, ' 
        || 'and you must be granted rights to that organization.  Contact STORET/WQX '
        || 'Support for assistance.');   
      
END get_org_uid;

/****************************************************************************************
  Function to return the Org UID from the organization table.                                                             
 ****************************************************************************************/
FUNCTION get_org_id 
  RETURN organization.org_id%TYPE AS

BEGIN
  RETURN v_org_id;
END;

/****************************************************************************************
  Update a new row into the Organization table.
 ****************************************************************************************/
PROCEDURE update_row (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_org_id      IN   organization.org_id%TYPE,
  p_org_name    IN   organization.org_name%TYPE,
  p_org_desc    IN   organization.org_desc%TYPE,
  p_trb_cd      IN   tribe.trb_cd%TYPE,
  p_org_uid     OUT  organization.org_uid%TYPE) AS

  v_context   transaction_log_detail.tldet_context%TYPE;
  v_temp      organization.org_uid%TYPE;
  v_trb_uid   tribe.trb_uid%TYPE;
  
BEGIN
  v_context := lib_pkg.context_concat(p_context, 'Org ID = ' || p_org_id);
  -- make sure Org ID is valid
  v_temp := get_org_uid(p_org_id);
  v_trb_uid := lookup_tbl_pkg.get_trb_uid(v_context,p_trb_cd);
  -----------------------------------------------------------------------------------
  -- Update row in database.
  -----------------------------------------------------------------------------------
  UPDATE organization
    SET org_name = p_org_name,
        org_desc = p_org_desc,
        trb_uid = v_trb_uid,
        org_last_change_date = SYSTIMESTAMP
    WHERE org_uid = v_org_uid;
  p_org_uid := v_org_uid;
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      v_context, 
      'organization_pkg.update_row');

END update_row;

END organization_pkg;
/

prompt
prompt Creating package body ORG_ADDRESS_PKG
prompt =====================================
prompt
CREATE OR REPLACE PACKAGE BODY org_address_pkg AS
  
/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
  
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

  /****************************************************************************************
     Insert a new row
  ****************************************************************************************/
  PROCEDURE insert_row (
    p_context                      IN   transaction_log_detail.tldet_context%TYPE,
    p_addtyp_name                  IN   address_type.addtyp_name%TYPE,
    p_cntry_cd                     IN   country.cntry_cd%TYPE,
    p_cnty_fips_cd                 IN   county.cnty_fips_cd%TYPE,
    p_orgadd_address               IN   org_address.orgadd_address%TYPE,
    p_orgadd_address_supplemental  IN   org_address.orgadd_address_supplemental%TYPE,
    p_orgadd_locality_name         IN   org_address.orgadd_locality_name%TYPE,
    p_orgadd_postal_cd             IN   org_address.orgadd_postal_cd%TYPE,
    p_st_cd                        IN   state.st_cd%TYPE,
    p_orgadd_uid                   OUT  org_address.orgadd_uid%TYPE) AS
  
    v_context       transaction_log_detail.tldet_context%TYPE;      
    v_addtyp_uid    org_address.addtyp_uid%TYPE;
    v_cnty_uid      org_address.cnty_uid%TYPE;
    v_st_uid        state.st_uid%TYPE;
    v_cntry_uid     country.cntry_uid%TYPE;
    
  BEGIN
    v_context := lib_pkg.context_concat(
      p_context, 'Organization UID = ' || organization_pkg.get_org_uid);
    -- If Addresss Text or Address Type Name is reported then both must be reported.
    IF (p_orgadd_address IS NOT NULL AND p_addtyp_name IS NULL) OR 
        (p_orgadd_address IS NULL AND p_addtyp_name IS NOT NULL) THEN 
      lib_pkg.raise_error(
        v_context, 
        'org_address_pkg.insert_row',
        'If Addresss Text or Address Type Name is reported then both must be reported.');
    END IF;
    -- get lookup table UIDs
    v_addtyp_uid := lookup_tbl_pkg.get_addtyp_uid(v_context, p_addtyp_name);
    v_cntry_uid := lookup_tbl_pkg.get_cntry_uid(v_context, p_cntry_cd);
    v_st_uid := lookup_tbl_pkg.get_st_uid(v_context, p_st_cd);
    v_cnty_uid := lookup_tbl_pkg.get_cnty_uid(v_context, p_cnty_fips_cd, v_st_uid);  
    SELECT orgadd_seq.NEXTVAL
      INTO p_orgadd_uid
      FROM dual;
    INSERT INTO org_address (
        orgadd_uid, 
        addtyp_uid, 
        cntry_uid, 
        cnty_uid, 
        org_uid, 
        st_uid, 
        orgadd_address, 
        orgadd_address_supplemental, 
        orgadd_locality_name, 
        orgadd_postal_cd, 
        orgadd_last_change_date)
      VALUES (
        p_orgadd_uid,
        v_addtyp_uid,
        v_cntry_uid,
        v_cnty_uid,
        organization_pkg.get_org_uid,
        v_st_uid,
        p_orgadd_address,
        p_orgadd_address_supplemental,
        p_orgadd_locality_name,
        p_orgadd_postal_cd,
        SYSTIMESTAMP);
     
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_insert, 
      lib_pkg.c_tbl_org_address,
      p_orgadd_uid,
      NULL);
      
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'org_address_pkg.insert_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert, 
        lib_pkg.c_tbl_org_address,
        p_orgadd_uid,
        NULL,
        'N');
  
  END insert_row;
  
  /****************************************************************************************
   Delete a row 
  ****************************************************************************************/
  PROCEDURE delete_row (
    p_context                   IN   transaction_log_detail.tldet_context%TYPE,
    p_orgadd_uid                IN   org_address.orgadd_uid%TYPE) AS
  
  BEGIN
    DELETE
      FROM org_address
      WHERE orgadd_uid = p_orgadd_uid;
    IF SQL%ROWCOUNT > 0 THEN
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_org_address,
        p_orgadd_uid,
        NULL);
    END IF;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'org_address_pkg.delete_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_org_address,
        p_orgadd_uid,
        NULL,
        'N');
        
  END delete_row;
  
  /****************************************************************************************
   Delete by org uid
  ****************************************************************************************/
  PROCEDURE delete_rows_by_org_uid (
    p_context                   IN   transaction_log_detail.tldet_context%TYPE,
    p_org_uid                   IN   organization.org_uid%TYPE) AS
    
    v_context    transaction_log_detail.tldet_context%TYPE;
    v_tlaud_uid  transaction_log_audit.tlaud_uid%TYPE;
    
  BEGIN
    v_context := lib_pkg.context_concat(
      p_context, 'Organization UID = ' || p_org_uid);
    FOR del_orgadd_rec IN (SELECT orgadd_uid
                             FROM org_address
                             WHERE org_uid = p_org_uid) LOOP
      delete_row(v_context, del_orgadd_rec.orgadd_uid);
    END LOOP;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'org_address_pkg.delete_rows_by_org_uid');
     
  END delete_rows_by_org_uid;

END org_address_pkg;
/

prompt
prompt Creating package body ORG_ELECTRONIC_ADDRESS_PKG
prompt ================================================
prompt
CREATE OR REPLACE PACKAGE BODY org_electronic_address_pkg AS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
  
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

  /****************************************************************************************
     Insert a new row in to the org electronic address table
  ****************************************************************************************/
  PROCEDURE insert_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_eatyp_name  IN   electronic_address_type.eatyp_name%TYPE,
    p_orgea_text  IN   org_electronic_address.orgea_text%TYPE,
    p_orgea_uid   OUT  org_electronic_address.orgea_uid%TYPE) AS
  
    v_context     transaction_log_detail.tldet_context%TYPE;
    v_eatyp_uid   org_electronic_address.eatyp_uid%TYPE;
    
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Organization ID = ' 
      || organization_pkg.get_org_uid);
    -- If Electronic Addresss Text or Electronic Address Type Name is reported then both must be reported.
    IF (p_orgea_text IS NOT NULL AND p_eatyp_name IS NULL) OR 
        (p_orgea_text IS NULL AND p_eatyp_name IS NOT NULL) THEN
      lib_pkg.raise_error(
        v_context, 
        'org_electronic_address_pkg.insert_row',
        'If Electronic Addresss Text or Electronic Address Type Name is reported then both must be reported.');
    END IF;
    -- get lookup table UIDs
    v_eatyp_uid := lookup_tbl_pkg.get_eatyp_uid(v_context, p_eatyp_name);
    SELECT orgea_seq.NEXTVAL
      INTO p_orgea_uid
      FROM dual;
    INSERT INTO org_electronic_address (
      orgea_uid,
      eatyp_uid,
      orgea_text,
      org_uid,
      orgea_last_change_date)
    VALUES (
      p_orgea_uid,
      v_eatyp_uid,
      p_orgea_text,
      organization_pkg.get_org_uid,
      SYSTIMESTAMP);
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_insert, 
      lib_pkg.c_tbl_org_electronic_address, 
      p_orgea_uid);
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'org_electronic_address_pkg.insert_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert, 
        lib_pkg.c_tbl_org_electronic_address, 
        p_orgea_uid,
        NULL,
        'N');  
  
  END insert_row;
  
  /****************************************************************************************
   Delete a row by unique key
  ****************************************************************************************/
  PROCEDURE delete_row (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_orgea_uid   IN   org_electronic_address.orgea_uid%TYPE) AS
    
  BEGIN
    DELETE
      FROM org_electronic_address
      WHERE orgea_uid = p_orgea_uid;
    IF SQL%ROWCOUNT > 0 THEN
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_org_electronic_address, 
        p_orgea_uid);
    END IF;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context, 
        'org_electronic_address_pkg.delete_row');
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_org_electronic_address, 
        p_orgea_uid,
        NULL,
        'N');
  
  END delete_row;
  
  /****************************************************************************************
   Delete by org uid
  ****************************************************************************************/
  PROCEDURE delete_rows_by_org_uid (
    p_context     IN   transaction_log_detail.tldet_context%TYPE,
    p_org_uid     IN   organization.org_uid%TYPE) AS
  
    v_context   transaction_log_detail.tldet_context%TYPE;
    v_tlaud_uid transaction_log_audit.tlaud_uid%TYPE;
    
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Organization UID = ' || p_org_uid);
    FOR del_orgea_rec IN (SELECT orgea_uid
                            FROM org_electronic_address
                            WHERE org_uid = p_org_uid) LOOP                    
      delete_row(v_context, del_orgea_rec.orgea_uid);
    END LOOP;  
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context, 
        'org_electronic_address_pkg.delete_rows_by_org_uid');
    
  END delete_rows_by_org_uid;

END org_electronic_address_pkg;
/

prompt
prompt Creating package body ORG_PHONE_PKG
prompt ===================================
prompt
CREATE OR REPLACE PACKAGE BODY org_phone_pkg AS
  
/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
  
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

/****************************************************************************************
   Insert a new row in to the org phone table
****************************************************************************************/
PROCEDURE insert_row (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_orgph_ext   IN   org_phone.orgph_ext%TYPE,
  p_orgph_num   IN   org_phone.orgph_num%TYPE,
  p_phtyp_name  IN   phone_type.phtyp_name%TYPE,
  p_orgph_uid   OUT  org_phone.orgph_uid%TYPE) AS

  v_context     transaction_log_detail.tldet_context%TYPE;
  v_phtyp_uid   org_phone.phtyp_uid%TYPE;

BEGIN
  v_context := lib_pkg.context_concat(
    p_context, 
    'Organization ID = ' || organization_pkg.get_org_uid);
  -- If Telephone Number or Telephone Type Name is reported then both must be reported
  IF (p_orgph_num IS NOT NULL AND p_phtyp_name IS NULL) OR 
      (p_orgph_num IS NULL AND p_phtyp_name IS NOT NULL) THEN
    lib_pkg.raise_error(
      v_context, 
      'org_phone_pkg.insert_row',
      'If Telephone Number or Telephone Type Name is reported then both must be reported.');
  END IF;
  -- get UID from lookup tables
  v_phtyp_uid := lookup_tbl_pkg.get_phtyp_uid(v_context, p_phtyp_name);
  SELECT orgph_seq.NEXTVAL
    INTO p_orgph_uid
    FROM dual;
  INSERT INTO org_phone (
      orgph_uid,
      orgph_ext,
      orgph_num,
      org_uid,
      phtyp_uid,
      orgph_last_change_date)
    VALUES (
      p_orgph_uid,
      p_orgph_ext,
      p_orgph_num,
      organization_pkg.get_org_uid,
      v_phtyp_uid,
      SYSTIMESTAMP);
  v_tlaud_uid := transaction_log_pkg.insert_audit(
    lib_pkg.c_audtyp_audit_insert, 
    lib_pkg.c_tbl_org_phone, 
    p_orgph_uid);
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      v_context, 
      'org_phone_pkg.insert_row');
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_insert, 
      lib_pkg.c_tbl_org_phone, 
      p_orgph_uid,
      NULL,
      'N');
    
END insert_row;

/****************************************************************************************
 Delete a row by unique key
****************************************************************************************/
PROCEDURE delete_row (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_orgph_uid   IN   org_phone.orgph_uid%TYPE) AS

BEGIN
  DELETE
    FROM org_phone
    WHERE orgph_uid = p_orgph_uid;
  IF SQL%ROWCOUNT > 0 THEN
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_delete, 
      lib_pkg.c_tbl_org_phone, 
      p_orgph_uid);
  END IF;
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context, 
      'org_phone_pkg.delete_row');
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_delete, 
      lib_pkg.c_tbl_org_phone, 
      p_orgph_uid,
      NULL,
      'N');
      
END delete_row;

/****************************************************************************************
 Delete by org uid
****************************************************************************************/
PROCEDURE delete_rows_by_org_uid (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_org_uid     IN   organization.org_uid%TYPE) AS

  v_context  transaction_log_detail.tldet_context%TYPE;
  v_tlaud_uid transaction_log_audit.tlaud_uid%TYPE;
  
BEGIN
  v_context := lib_pkg.context_concat(p_context, 'Organization UID = ' || p_org_uid);
  FOR del_orgph_rec IN (SELECT orgph_uid
                          FROM org_phone
                          WHERE org_uid = p_org_uid) LOOP
    delete_row(v_context, del_orgph_rec.orgph_uid);
  END LOOP;   
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context, 
      'org_phone_pkg.delete_rows_by_org_uid');
      
END delete_rows_by_org_uid;

END org_phone_pkg;
/

prompt
prompt Creating package body PROJECT_PKG
prompt =================================
prompt
CREATE OR REPLACE PACKAGE BODY project_pkg AS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_tlaud_uid   transaction_log_audit.tlaud_uid%TYPE;
    
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

/****************************************************************************************
   Insert or Update a new row in to the Project table
****************************************************************************************/
PROCEDURE insert_update_row (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_prj_desc    IN   project.prj_desc%TYPE,
  p_prj_id      IN   project.prj_id%TYPE,
  p_prj_name    IN   project.prj_name%TYPE,
  p_prj_uid     OUT  project.prj_uid%TYPE) AS

  v_context  transaction_log_detail.tldet_context%TYPE;
  v_exists    BOOLEAN := FALSE;
    
 BEGIN
  v_context := lib_pkg.context_concat(p_context, 'Project Identifier = ' || p_prj_id);
  -- validate parameters
  IF p_prj_id IS NULL THEN
    lib_pkg.raise_error(
      v_context, 
      'project_pkg.insert_update_row', 
      'Project Identifier is required');
  END IF;
  BEGIN 
    -- Check to see if row already exists to determine insert or update.
    SELECT prj_uid
      INTO p_prj_uid     
      FROM project
      WHERE prj_id = p_prj_id
        AND org_uid = organization_pkg.get_org_uid;
  EXCEPTION
    WHEN no_data_found THEN
      NULL;
  END;
  IF p_prj_uid IS NULL THEN 
    -- Get next sequence value and put into out parameter.
    SELECT prj_seq.NEXTVAL
      INTO p_prj_uid
      FROM dual;
    INSERT INTO project (
      prj_uid,
      org_uid,
      prj_desc,
      prj_id,
      prj_name,
      prj_last_change_date)
    VALUES (
      p_prj_uid,
      organization_pkg.get_org_uid,
      p_prj_desc,
      p_prj_id,
      p_prj_name,
      SYSTIMESTAMP);
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_insert, 
      lib_pkg.c_tbl_project, 
      p_prj_uid,
      p_prj_id);
  ELSE
    v_exists := TRUE;
    UPDATE project
      SET org_uid   = organization_pkg.get_org_uid,
         prj_desc  = p_prj_desc,
         prj_id    = p_prj_id,
         prj_name  = p_prj_name
      WHERE prj_uid = p_prj_uid;
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_update, 
      lib_pkg.c_tbl_project, 
      p_prj_uid,
      p_prj_id);
  END IF;
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      v_context, 
      'project_pkg.insert_update_row');
    IF v_exists THEN 
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_update, 
        lib_pkg.c_tbl_project, 
        p_prj_uid,
        p_prj_id,
        'N');
    ELSE
      v_tlaud_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert, 
        lib_pkg.c_tbl_project, 
        p_prj_uid,
        p_prj_id,
        'N');
    END IF;

END insert_update_row;

/****************************************************************************************
 Delete a row by unique key
****************************************************************************************/
PROCEDURE delete_row (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_prj_uid     IN   project.prj_uid%TYPE,
  p_prj_id      IN   project.prj_id%TYPE) AS
 
  v_prj_id      project.prj_id%TYPE;
    
BEGIN
  -- validate parameters
  IF p_prj_uid IS NULL THEN
    lib_pkg.raise_error(
      p_context, 
      'project_pkg.delete_row', 
      'Project UID cannot be blank');
  END IF;
  -- cascade delete child activities
  activity_pkg.delete_rows_by_prj_uid(p_context, p_prj_uid);   
  -- delete attached objects for the project
  attached_object_pkg.delete_rows_by_table_ref(p_context, p_prj_uid, 1);
  -- delete the project
  DELETE
    FROM project
    WHERE prj_uid = p_prj_uid
    RETURNING prj_id INTO v_prj_id;
  IF SQL%ROWCOUNT > 0 THEN
    -- Project delete was successful so write to audit log.
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_delete, 
      lib_pkg.c_tbl_project, 
      p_prj_uid,
      v_prj_id);
  END IF;
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context, 
      'project_pkg.delete_row');
    v_tlaud_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_delete, 
      lib_pkg.c_tbl_project, 
      p_prj_uid,
      p_prj_id,
      'N');
      
END delete_row;

/****************************************************************************************
 Delete a row by unique key
****************************************************************************************/
PROCEDURE delete_row_by_prj_id (
  p_context     IN   transaction_log_detail.tldet_context%TYPE,
  p_prj_id      IN   project.prj_id%TYPE) AS
  
  v_context   transaction_log_detail.tldet_context%TYPE;
  v_prj_uid   project.prj_uid%TYPE;
                                                 
BEGIN
  v_context := lib_pkg.context_concat(p_context, 'Project Identifier = ' || p_prj_id);
  BEGIN
    SELECT prj_uid
      INTO v_prj_uid
      FROM project
      WHERE upper(prj_id) = upper(p_prj_id)
        AND org_uid = organization_pkg.get_org_uid;
    delete_row(v_context, v_prj_uid, p_prj_id); 

  EXCEPTION
    WHEN no_data_found THEN
      transaction_log_pkg.insert_warning(
        'Project could not be deleted.  Project Identifier "' || p_prj_id 
        || '" could not be found.', v_context);
  END;
  
EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context, 
      'project_pkg.delete_row_by_prj_id');
  
END delete_row_by_prj_id;

/****************************************************************************************
  Get Project UID given an ID
****************************************************************************************/ 
FUNCTION get_prj_uid (
  p_context   IN  transaction_log_detail.tldet_context%TYPE,
  p_prj_id    IN  project.prj_id%TYPE)
  
  RETURN NUMBER IS

  v_prj_uid  project.prj_uid%TYPE;

BEGIN
  IF p_prj_id IS NULL THEN
    RETURN NULL;
  END IF;
  SELECT prj.prj_uid
    INTO v_prj_uid
    FROM project prj
    WHERE upper(prj.prj_id) = upper(p_prj_id)
      AND prj.org_uid = organization_pkg.get_org_uid;
  RETURN v_prj_uid;

EXCEPTION
  WHEN no_data_found THEN
    lib_pkg.raise_error(
      p_context, 
      'project_pkg.get_prj_uid', 
      'Project Identifier "' || p_prj_id || '" is invalid');
    RETURN NULL;
  WHEN OTHERS THEN
    lib_pkg.raise_error(p_context, 'project_pkg.get_prj_uid');
    RETURN NULL;
  
END get_prj_uid;

END project_pkg;
/

prompt
prompt Creating package body RESULT_DETECT_QUANT_LIMIT_PKG
prompt ===================================================
prompt
CREATE OR REPLACE PACKAGE BODY result_detect_quant_limit_pkg AS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES
 ****************************************************************************************/

/****************************************************************************************
                                PROCEDURES AND FUNCTIONS
 ****************************************************************************************/

/****************************************************************************************
   Insert a new row
****************************************************************************************/
PROCEDURE insert_row (
  p_context        IN   transaction_log_detail.tldet_context%TYPE,
  p_dqltyp_name    IN   detection_quant_limit_type.dqltyp_name%TYPE,
  p_msunt_cd       IN   measurement_unit.msunt_cd%TYPE,
  p_rdqlmt_measure IN   result_detect_quant_limit.rdqlmt_measure%TYPE,
  p_res_uid        IN   result_detect_quant_limit.res_uid%TYPE,
  p_rdqlmt_uid     OUT  result_detect_quant_limit.rdqlmt_uid%TYPE) AS

  v_context       transaction_log_detail.tldet_context%TYPE;
  v_dqltyp_uid    result_detect_quant_limit.dqltyp_uid%TYPE;
  v_msunt_uid     result_detect_quant_limit.msunt_uid%TYPE;

BEGIN
  v_context := lib_pkg.context_concat(p_context, 'Result ID = ' || p_res_uid);
  -- Initalize variables with UID's from lookup tables.
  v_dqltyp_uid    := lookup_tbl_pkg.get_dqltyp_uid(v_context, p_dqltyp_name);
  v_msunt_uid     := lookup_tbl_pkg.get_msunt_uid(v_context, p_msunt_cd);
  IF (p_msunt_cd IS NULL AND p_rdqlmt_measure IS NOT NULL) 
      OR (p_rdqlmt_measure IS NULL AND p_msunt_cd IS NOT NULL) THEN
    lib_pkg.raise_error(
      v_context,
      'result_detect_quant_limit_pkg.insert_row',
      'When DetectionQuantitationLimit''s MeasureValue is reported, '
        || 'DetectionQuantitationLimit''s MeasureUnitCode must be reported.');
  END IF;  
  -- Get next sequence value and put into out parameter.
  SELECT rdqlmt_seq.NEXTVAL
    INTO p_rdqlmt_uid
    FROM dual;
  INSERT INTO result_detect_quant_limit (
    rdqlmt_uid,
    dqltyp_uid,
    msunt_uid,
    org_uid,
    rdqlmt_measure,
    rdqlmt_last_change_date,
    res_uid)
  VALUES (
    p_rdqlmt_uid,
    v_dqltyp_uid,
    v_msunt_uid,
    organization_pkg.get_org_uid,
    p_rdqlmt_measure,
    SYSTIMESTAMP,
    p_res_uid);

EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
    v_context,
    'result_detect_quant_limit_pkg.insert_row');
    

END insert_row;

/****************************************************************************************
 Delete row
****************************************************************************************/
PROCEDURE delete_row (
  p_context        IN   transaction_log_detail.tldet_context%TYPE,
  p_rdqlmt_uid      IN   result_detect_quant_limit.rdqlmt_uid%TYPE) AS

BEGIN
  DELETE
    FROM result_detect_quant_limit
    WHERE rdqlmt_uid = p_rdqlmt_uid;

EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context,
      'result_detect_quant_limit_pkg.delete_row');

END delete_row;

/****************************************************************************************
 Delete by result uid
****************************************************************************************/
PROCEDURE delete_row_by_res_uid (
  p_context                    IN   transaction_log_detail.tldet_context%TYPE,
  p_res_uid                    IN   result_detect_quant_limit.res_uid%TYPE) AS

BEGIN
  FOR del_rdqlmt_rec IN (SELECT rdqlmt_uid
                          FROM result_detect_quant_limit
                          WHERE res_uid = p_res_uid) LOOP
    delete_row(p_context, del_rdqlmt_rec.rdqlmt_uid);
  END LOOP;

EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context,
      'result_lab_sample_prep_pkg.delete_row_by_res_uid');

END delete_row_by_res_uid;

END result_detect_quant_limit_pkg;
/

prompt
prompt Creating package body RESULT_LAB_SAMPLE_PREP_PKG
prompt ================================================
prompt
CREATE OR REPLACE PACKAGE BODY result_lab_sample_prep_pkg AS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES
 ****************************************************************************************/

/****************************************************************************************
                                PROCEDURES AND FUNCTIONS
 ****************************************************************************************/

/****************************************************************************************
   Insert or Update a new row
****************************************************************************************/

PROCEDURE insert_row (
  p_context                   IN  transaction_log_detail.tldet_context%TYPE,
  p_res_uid                   IN  result_lab_sample_prep.res_uid%TYPE,
  p_rlsprp_end_date           IN  result_lab_sample_prep.rlsprp_end_date%TYPE,
  p_rlsprp_end_time           IN  result_lab_sample_prep.rlsprp_end_time%TYPE,
  p_rlsprp_method_context     IN  result_lab_sample_prep.rlsprp_method_context%TYPE,
  p_rlsprp_method_desc        IN  result_lab_sample_prep.rlsprp_method_desc%TYPE,
  p_rlsprp_method_id          IN  result_lab_sample_prep.rlsprp_method_id%TYPE,
  p_rlsprp_method_name        IN  result_lab_sample_prep.rlsprp_method_name%TYPE,
  p_rlsprp_method_qual_type   IN  result_lab_sample_prep.rlsprp_method_qual_type%TYPE,
  p_rlsprp_start_date         IN  result_lab_sample_prep.rlsprp_start_date%TYPE,
  p_rlsprp_start_time         IN  result_lab_sample_prep.rlsprp_start_time%TYPE,
  p_tmzone_uid_end_time       IN  result_lab_sample_prep.tmzone_uid_end_time%TYPE,
  p_tmzone_uid_start_time     IN  result_lab_sample_prep.tmzone_uid_start_time%TYPE,
  p_rlsprp_uid                OUT result_lab_sample_prep.rlsprp_uid%TYPE) AS

  v_context               transaction_log_detail.tldet_context%TYPE;
  v_rlsprp_start_time     result_lab_sample_prep.rlsprp_start_time%TYPE := NULL;
  v_rlsprp_end_time       result_lab_sample_prep.rlsprp_end_time%TYPE := NULL;
  v_tmzone_uid_start_time result_lab_sample_prep.tmzone_uid_start_time%TYPE;
  v_tmzone_uid_end_time   result_lab_sample_prep.tmzone_uid_end_time%TYPE;

BEGIN
  v_context := lib_pkg.context_concat(p_context, 'Result ID = ' || p_res_uid);

  --Lookup values
  v_tmzone_uid_start_time  := lookup_tbl_pkg.get_tmzone_uid(v_context, p_tmzone_uid_start_time);
  IF p_tmzone_uid_start_time = p_tmzone_uid_end_time THEN
    v_tmzone_uid_end_time := v_tmzone_uid_start_time;
  ELSE
    v_tmzone_uid_end_time := lookup_tbl_pkg.get_tmzone_uid(v_context, p_tmzone_uid_end_time);
  END IF;

  -- drop date portion of time-only fields
  IF p_rlsprp_start_time IS NOT NULL THEN
    v_rlsprp_start_time := to_date('01/01/0001 ' || to_char(p_rlsprp_start_time,'HH24:MI:SS'),'MM/DD/YYYY HH24:MI:SS');
  END IF;
  IF p_rlsprp_end_time IS NOT NULL THEN
    v_rlsprp_end_time := to_date('01/01/0001 ' || to_char(p_rlsprp_end_time,'HH24:MI:SS'),'MM/DD/YYYY HH24:MI:SS');
  END IF;

  -- Get next sequence value and put into out parameter.
  SELECT rlsprp_seq.NEXTVAL
    INTO p_rlsprp_uid
    FROM dual;
  INSERT INTO result_lab_sample_prep (
    rlsprp_uid,
    org_uid,
    res_uid,
    rlsprp_end_date,
    rlsprp_end_time,
    rlsprp_last_change_date,
    rlsprp_method_context,
    rlsprp_method_desc,
    rlsprp_method_id,
    rlsprp_method_name,
    rlsprp_method_qual_type,
    rlsprp_start_date,
    rlsprp_start_time,
    tmzone_uid_end_time,
    tmzone_uid_start_time)
  VALUES (
    p_rlsprp_uid,
    organization_pkg.get_org_uid,
    p_res_uid,
    p_rlsprp_end_date,
    v_rlsprp_end_time,
    SYSTIMESTAMP,
    p_rlsprp_method_context,
    p_rlsprp_method_desc,
    p_rlsprp_method_id,
    p_rlsprp_method_name,
    p_rlsprp_method_qual_type,
    p_rlsprp_start_date,
    v_rlsprp_start_time,
    v_tmzone_uid_end_time,
    v_tmzone_uid_start_time);

EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      v_context,
      'result_lab_sample_prep_pkg.insert_row');

END insert_row;

/****************************************************************************************
 Delete a row in result lab sample prep table
****************************************************************************************/
PROCEDURE delete_row (
  p_context                    IN   transaction_log_detail.tldet_context%TYPE,
  p_rlsprp_uid                 IN   result_lab_sample_prep.rlsprp_uid%TYPE) AS

BEGIN
  DELETE
    FROM result_lab_sample_prep
    WHERE rlsprp_uid = p_rlsprp_uid;

EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
    p_context,
    'result_lab_sample_prep_pkg.delete_row');

END delete_row;

/****************************************************************************************
 Delete by result uid
****************************************************************************************/
PROCEDURE delete_row_by_res_uid (
  p_context                    IN   transaction_log_detail.tldet_context%TYPE,
  p_res_uid                    IN   result.res_uid%TYPE) AS

BEGIN
  FOR del_rlsprp_rec IN (SELECT rlsprp_uid
                           FROM result_lab_sample_prep
                           WHERE res_uid = p_res_uid) LOOP
    delete_row(p_context, del_rlsprp_rec.rlsprp_uid);
  END LOOP;

EXCEPTION
  WHEN OTHERS THEN
    lib_pkg.raise_error(
      p_context,
      'result_lab_sample_prep_pkg.delete_row_by_res_uid');

END delete_row_by_res_uid;

END result_lab_sample_prep_pkg;
/

prompt
prompt Creating package body RESULT_PKG
prompt ================================
prompt
CREATE OR REPLACE PACKAGE BODY result_pkg AS
  
/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/

/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_trans_audit_uid     transaction_log_audit.tlaud_uid%TYPE;
  
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/

  /****************************************************************************************
     Insert a new row
  ****************************************************************************************/
  PROCEDURE insert_row (
    p_context                         IN   transaction_log_detail.tldet_context%TYPE,
    p_act_uid                         IN   result.act_uid%TYPE,
    p_chr_name                        IN   characteristic.chr_name%TYPE,
    p_msunt_cd_dpth_ht                IN   measurement_unit.msunt_cd%TYPE,
    p_msunt_cd_measure                IN   measurement_unit.msunt_cd%TYPE,
    p_rdcnd_name                      IN   result_detection_condition.rdcnd_name%TYPE,
    p_anlmth_uid                      IN   analytical_method.anlmth_uid%TYPE,
    p_res_measure_bias                IN   result.res_measure_bias%TYPE,
    p_res_comments                    IN   result.res_comments%TYPE,
    p_res_data_logger_line            IN   result.res_data_logger_line%TYPE,
    p_res_depth_height                IN   result.res_depth_height%TYPE,
    p_res_depth_altitude_ref_point    IN   result.res_depth_altitude_ref_point%TYPE,
    p_res_lab_analysis_start_date     IN   result.res_lab_analysis_start_date%TYPE,
    p_res_lab_analysis_start_time     IN   result.res_lab_analysis_start_time%TYPE,
    p_res_lab_analysis_end_date       IN   result.res_lab_analysis_end_date%TYPE,
    p_res_lab_analysis_end_time       IN   result.res_lab_analysis_end_time%TYPE,
    p_tmzone_cd_lab_start             IN   time_zone.tmzone_cd%TYPE,
    p_tmzone_cd_lab_end               IN   time_zone.tmzone_cd%TYPE,
    p_res_lab_name                    IN   result.res_lab_name%TYPE,
    p_res_particle_size_basis         IN   result.res_particle_size_basis%TYPE,
    p_res_measure                     IN   result.res_measure%TYPE,
    p_res_measure_conf_interval       IN   result.res_measure_conf_interval%TYPE,
    p_res_measure_precision           IN   result.res_measure_precision%TYPE,
    p_res_measure_lower_conf_limit    IN   result.res_measure_lower_conf_limit%TYPE,
    p_res_measure_upper_conf_limit    IN   result.res_measure_upper_conf_limit%TYPE,
    p_rlcom_cd                        IN   result_lab_comment.rlcom_cd%TYPE,
    p_rmqlf_cd                        IN   result_measure_qualifier.rmqlf_cd%TYPE,
    p_rsbas_cd                        IN   result_statistical_base.rsbas_cd%TYPE,
    p_ressta_name                     IN   result_status.ressta_name%TYPE,
    p_rtimb_name                      IN   result_time_basis.rtimb_name%TYPE,
    p_rtmpb_name                      IN   result_temperature_basis.rtmpb_name%TYPE,
    p_rvtyp_name                      IN   result_value_type.rvtyp_name%TYPE,
    p_rwbas_name                      IN   result_weight_basis.rwbas_name%TYPE,
    p_smfrc_name                      IN   sample_fraction.smfrc_name%TYPE,
    p_res_uid                         OUT  result.res_uid%TYPE) AS
  
    v_context                       transaction_log_detail.tldet_context%TYPE;                                                       
    v_chr_uid                       result.chr_uid%TYPE;
    v_cplval_uid                    result.cplval_uid%TYPE;
    v_msunt_uid_dpth_ht             result.msunt_uid_depth_height%TYPE;
    v_msunt_uid_measure             result.msunt_uid_measure%TYPE;
    v_rdcnd_uid                     result.rdcnd_uid%TYPE;
    v_rlcom_uid                     result.rlcom_uid%TYPE;
    v_rmqlf_uid                     result.rmqlf_uid%TYPE;
    v_rsbas_uid                     result.rsbas_uid%TYPE;
    v_ressta_uid                    result.ressta_uid%TYPE;
    v_rtimb_uid                     result.rtimb_uid%TYPE;
    v_rtmpb_uid                     result.rtmpb_uid%TYPE;
    v_rvtyp_uid                     result.rvtyp_uid%TYPE;
    v_rwbas_uid                     result.rwbas_uid%TYPE;
    v_smfrc_uid                     result.smfrc_uid%TYPE;
    v_tmzone_uid_lab_end            result.tmzone_uid_lab_analysis_end%TYPE;
    v_tmzone_uid_lab_start          result.tmzone_uid_lab_analysis_start%TYPE;
    v_actyp_anlmth_req              activity_type.actyp_anl_mth_req_yn%TYPE;
    v_actyp_cd                      activity_type.actyp_cd%TYPE;
    v_chr_smfrc_req                 characteristic.chr_sample_fraction_req_yn%TYPE;
    v_pick_list_yn                  characteristic.chr_pick_list_yn%TYPE;
    v_res_lab_analysis_start_time   result.res_lab_analysis_start_time%TYPE := NULL;
    v_res_lab_analysis_end_time     result.res_lab_analysis_end_time%TYPE := NULL;
    
  BEGIN
    v_context  := lib_pkg.context_concat(
      p_context, 'Activity UID = ' || p_act_uid);
    
    IF p_res_measure IS NOT NULL AND (p_chr_name IS NULL OR p_ressta_name IS NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'result_pkg.insert_row', 
        'Characteristic Name and Result Status Identifier must be reported when Result '
          || 'Measure is reported');
    END IF;   

    IF (p_res_measure IS NOT NULL AND p_rdcnd_name IS NOT NULL) THEN
      lib_pkg.raise_error(
        v_context,
        'result_pkg.insert_row', 
        'Either Result Measure Value or Result Detection Condition Text can be reported '
          || 'but not both.');
    END IF;
    
    -- Analytical Method UID must be reported if it is required by Activity type code
    IF p_anlmth_uid IS NULL THEN
      SELECT actyp.actyp_anl_mth_req_yn, actyp.actyp_cd
        INTO v_actyp_anlmth_req, v_actyp_cd
        FROM activity_type actyp, activity act
        WHERE act.act_uid = p_act_uid
        AND act.actyp_uid = actyp.actyp_uid;
      IF v_actyp_anlmth_req = 'Y' THEN
        lib_pkg.raise_error(
          v_context, 
          'activity_pkg.insert_update_row',  
          'Analytical Method Identifier is required when Activity Type Code = ' || v_actyp_cd);
      END IF;
    END IF;   
    
    v_chr_uid := lookup_tbl_pkg.get_chr_uid(v_context, p_chr_name, v_pick_list_yn);
    
    -- Sample Fraction must be reported if it is required by Characteristic Name.
    IF p_smfrc_name IS NULL AND v_chr_uid IS NOT NULL THEN 
      SELECT chr.chr_sample_fraction_req_yn
        INTO v_chr_smfrc_req
        FROM characteristic chr
        WHERE chr.chr_uid = v_chr_uid;
      IF v_chr_smfrc_req = 'Y' THEN
         lib_pkg.raise_error(
          v_context, 
          'activity_pkg.insert_update_row',
          'Sample Fraction Name is required when Characteristic Name = "'
            || p_chr_name || '"');
      END IF;
    END IF;                                                               

    -- Check if characteristic has a pick list
    IF v_pick_list_yn = 'Y' THEN
      v_cplval_uid := lookup_tbl_pkg.get_cplval_uid(v_context,v_chr_uid, p_res_measure);
    END IF;
    
    v_msunt_uid_dpth_ht := lookup_tbl_pkg.get_msunt_uid(v_context, p_msunt_cd_dpth_ht);
    IF p_msunt_cd_dpth_ht = p_msunt_cd_measure THEN
      v_msunt_uid_measure := v_msunt_uid_dpth_ht;
    ELSE
      v_msunt_uid_measure := lookup_tbl_pkg.get_msunt_uid(v_context, p_msunt_cd_measure);
    END IF;
    v_rdcnd_uid := lookup_tbl_pkg.get_rdcnd_uid(v_context, p_rdcnd_name);
    v_rlcom_uid := lookup_tbl_pkg.get_rlcom_uid(v_context, p_rlcom_cd);
    v_rmqlf_uid := lookup_tbl_pkg.get_rmqlf_uid(v_context, p_rmqlf_cd);
    v_rsbas_uid := lookup_tbl_pkg.get_rsbas_uid(v_context, p_rsbas_cd);
    v_ressta_uid := lookup_tbl_pkg.get_ressta_uid(v_context, p_ressta_name);
    v_rtimb_uid := lookup_tbl_pkg.get_rtimb_uid(v_context, p_rtimb_name);
    v_rtmpb_uid := lookup_tbl_pkg.get_rtmpb_uid(v_context, p_rtmpb_name);
    v_rvtyp_uid := lookup_tbl_pkg.get_rvtyp_uid(v_context, p_rvtyp_name);
    v_rwbas_uid := lookup_tbl_pkg.get_rwbas_uid(v_context, p_rwbas_name);
    v_smfrc_uid := lookup_tbl_pkg.get_smfrc_uid(v_context, p_smfrc_name);
    v_tmzone_uid_lab_start := lookup_tbl_pkg.get_tmzone_uid(v_context, p_tmzone_cd_lab_start);
    IF p_tmzone_cd_lab_start = p_tmzone_cd_lab_end THEN
      v_tmzone_uid_lab_end := v_tmzone_uid_lab_start;
    ELSE
      v_tmzone_uid_lab_end := lookup_tbl_pkg.get_tmzone_uid(v_context, p_tmzone_cd_lab_end);
    END IF;
    -- drop date portion of time-only fields
    IF p_res_lab_analysis_start_time IS NOT NULL THEN
      v_res_lab_analysis_start_time := to_date('01/01/0001 ' 
        || to_char(p_res_lab_analysis_start_time,'HH24:MI:SS'),'MM/DD/YYYY HH24:MI:SS');
    END IF;
    IF p_res_lab_analysis_end_time IS NOT NULL THEN
      v_res_lab_analysis_end_time := to_date('01/01/0001 ' 
        || to_char(p_res_lab_analysis_end_time,'HH24:MI:SS'),'MM/DD/YYYY HH24:MI:SS');
    END IF;
    
    -- Get next sequence value and put into out parameter.
    SELECT res_seq.NEXTVAL
      INTO p_res_uid
      FROM dual;
    INSERT INTO result (
        res_uid,
        act_uid,
        anlmth_uid,
        chr_uid,
        cplval_uid,
        msunt_uid_depth_height,
        msunt_uid_measure,
        org_uid,
        rdcnd_uid,
        ressta_uid,
        res_comments,
        res_data_logger_line,
        res_depth_altitude_ref_point,
        res_depth_height,
        res_lab_analysis_end_date,
        res_lab_analysis_end_time,
        res_lab_analysis_start_date,
        res_lab_analysis_start_time,
        res_lab_name,
        res_last_change_date,
        res_measure,
        res_measure_bias,
        res_measure_conf_interval,
        res_measure_lower_conf_limit,
        res_measure_precision,
        res_measure_upper_conf_limit,
        res_particle_size_basis,
        rlcom_uid,
        rmqlf_uid,  
        rsbas_uid,
        rtimb_uid,
        rtmpb_uid,
        rvtyp_uid,
        rwbas_uid,
        smfrc_uid,
        tmzone_uid_lab_analysis_end,
        tmzone_uid_lab_analysis_start)
      VALUES (
        p_res_uid,
        p_act_uid,
        p_anlmth_uid,
        v_chr_uid,
        v_cplval_uid,
        v_msunt_uid_dpth_ht,
        v_msunt_uid_measure,
        organization_pkg.get_org_uid,
        v_rdcnd_uid,
        v_ressta_uid,
        p_res_comments,
        p_res_data_logger_line,
        p_res_depth_altitude_ref_point,
        p_res_depth_height,
        p_res_lab_analysis_end_date,
        v_res_lab_analysis_end_time,
        p_res_lab_analysis_start_date,
        v_res_lab_analysis_start_time,
        p_res_lab_name,
        SYSTIMESTAMP,
        p_res_measure,
        p_res_measure_bias,
        p_res_measure_conf_interval,
        p_res_measure_lower_conf_limit,
        p_res_measure_precision,
        p_res_measure_upper_conf_limit,
        p_res_particle_size_basis,
        v_rlcom_uid,
        v_rmqlf_uid,
        v_rsbas_uid,
        v_rtimb_uid,
        v_rtmpb_uid,
        v_rvtyp_uid,
        v_rwbas_uid,
        v_smfrc_uid,
        v_tmzone_uid_lab_end,
        v_tmzone_uid_lab_start);
      
    v_trans_audit_uid := transaction_log_pkg.insert_audit(
      lib_pkg.c_audtyp_audit_insert, 
      lib_pkg.c_tbl_result, 
      p_res_uid);
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'result_pkg.insert_row');
      v_trans_audit_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_insert, 
        lib_pkg.c_tbl_result, 
        p_res_uid,
        NULL,
        'N');
  
  END insert_row;
  
  /****************************************************************************************
   Delete a row by unique key
  ****************************************************************************************/
  PROCEDURE delete_row (
    p_context                         IN   transaction_log_detail.tldet_context%TYPE,
    p_res_uid                         IN   result.res_uid%TYPE) AS
  
    v_context  transaction_log_detail.tldet_context%TYPE;
    
  BEGIN
    v_context :=  lib_pkg.context_concat(p_context, 'Result UID = ' || p_res_uid);
    --Delete Child Records
    result_detect_quant_limit_pkg.delete_row_by_res_uid(v_context,p_res_uid);
    result_lab_sample_prep_pkg.delete_row_by_res_uid(v_context,p_res_uid);
    --Delete attached objects for result uid
    attached_object_pkg.delete_rows_by_table_ref(p_context, p_res_uid, lib_pkg.c_tbl_result);                                                     
    DELETE
      FROM result
      WHERE res_uid = p_res_uid;
    IF SQL%ROWCOUNT > 0 THEN
      v_trans_audit_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_result, 
        p_res_uid,
        NULL);
    END IF;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'result_pkg.delete_row');
      v_trans_audit_uid := transaction_log_pkg.insert_audit(
        lib_pkg.c_audtyp_audit_delete, 
        lib_pkg.c_tbl_result, 
        p_res_uid,
        NULL,
        'N');
  
  END delete_row;
  
  /****************************************************************************************
   Delete a row by Activity UID
  ****************************************************************************************/  
  PROCEDURE delete_rows_by_act_uid (
    p_context   IN transaction_log_detail.tldet_context%TYPE,
    p_act_uid   IN activity.act_uid%TYPE) AS
  
  BEGIN
    FOR del_res_rec IN (SELECT res_uid
                          FROM result
                          WHERE act_uid = p_act_uid) LOOP
      delete_row(p_context, del_res_rec.res_uid);
    END LOOP;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(p_context, 'result_pkg.delete_rows_by_act_uid');
    
  END delete_rows_by_act_uid;
  
END result_pkg;
/

prompt
prompt Creating package body TRANSACTION_LOG_PKG
prompt =========================================
prompt
CREATE OR REPLACE PACKAGE BODY transaction_log_pkg IS

/****************************************************************************************
                               PRIVATE CONSTANTS AND TYPES                                
 ****************************************************************************************/
  c_trsta_pending   CONSTANT NUMBER := 1;
  c_trsta_success   CONSTANT NUMBER := 2;
  c_trsta_failed    CONSTANT NUMBER := 3;
  
/****************************************************************************************
                                    PRIVATE VARIABLES                                  
 ****************************************************************************************/
  v_trlog_uid             transaction_log.trlog_uid%TYPE;
  v_trlog_id              transaction_log.trlog_trans_id%TYPE;
  v_trtyp_uid             transaction_type.trtyp_uid%TYPE;
  v_err_cnt_this_session  NUMBER(10) := 0;
      
/****************************************************************************************
                                PROCEDURES AND FUNCTIONS                                
 ****************************************************************************************/
 
/****************************************************************************************
  Procedure to insert an audit row into the transaction_log table.
 ****************************************************************************************/
  FUNCTION insert_audit (
    p_audtyp_uid        IN  transaction_log_audit.audtyp_uid%TYPE,
    p_tbl_uid           IN  transaction_log_audit.tbl_uid%TYPE,
    p_ref_uid           IN  transaction_log_audit.ref_uid%TYPE,
    p_ref_id            IN  transaction_log_audit.ref_id%TYPE := NULL,
    p_tlaud_success_yn  IN  transaction_log_audit.tlaud_success_yn%TYPE := 'P')
    
    RETURN transaction_log_audit.tlaud_uid%TYPE IS    
  
    PRAGMA AUTONOMOUS_TRANSACTION;
  
    v_tlaud_uid transaction_log_audit.tlaud_uid%TYPE;
    v_existing_cnt  NUMBER(10) := 0;
    v_tbl_name      VARCHAR2(50);
    
  BEGIN
    IF p_tbl_uid < 5 THEN
      SELECT COUNT(*)
        INTO v_existing_cnt
        FROM transaction_log_audit ta
        WHERE ta.trlog_uid = v_trlog_uid
        AND ta.tbl_uid = p_tbl_uid
        AND ta.ref_uid = p_ref_uid;
      v_tbl_name :=
        CASE p_tbl_uid
          WHEN '1' THEN 'Project'
          WHEN '2' THEN 'Monitoring Location'
          WHEN '3' THEN 'Activity'
          WHEN '4' THEN 'Activity Group'
          ELSE NULL
        END;
      IF v_existing_cnt > 0 THEN
        insert_error(v_tbl_name || ' Identifier "' || p_ref_id || 
          '" has already been used in this submission file and cannot be used for another ' 
            || v_tbl_name,
          'transaction_log.insert_audit',
          NULL);  
      END IF;
    END IF;
    
    INSERT INTO transaction_log_audit (
      tlaud_uid, 
      audtyp_uid, 
      org_uid, 
      ref_uid, 
      tbl_uid,
      trlog_uid,
      ref_id,
      tlaud_success_yn)      
    VALUES (
      tlaud_seq.NEXTVAL,
      p_audtyp_uid,
      organization_pkg.get_org_uid,
      p_ref_uid,
      p_tbl_uid,
      v_trlog_uid,
      p_ref_id,
      p_tlaud_success_yn)
    RETURNING tlaud_uid INTO v_tlaud_uid;
    COMMIT;
    RETURN v_tlaud_uid;
    
  EXCEPTION
    WHEN OTHERS THEN
      COMMIT;     
      lib_pkg.raise_error(
        NULL, 
        'transaction_log.insert_audit', 
        'Error writing to transaction_log_audit: ' || SQLERRM, 
        lib_pkg.c_err_audit); 
        
  END insert_audit;

/****************************************************************************************
  Update all transaction_log_audit table entries for a specific transaction where success 
  is pending
 ****************************************************************************************/  
  PROCEDURE update_audit_pending (
    p_tlaud_success_yn   IN transaction_log_audit.tlaud_success_yn%TYPE) IS
      
    PRAGMA AUTONOMOUS_TRANSACTION;
    
  BEGIN
    UPDATE transaction_log_audit a
      SET a.tlaud_success_yn = p_tlaud_success_yn
      WHERE a.trlog_uid = v_trlog_uid
      AND a.tlaud_success_yn = 'P';
    COMMIT;
  END update_audit_pending;
  
/****************************************************************************************
  Procedure to insert an error row into the transaction_log table.
 ****************************************************************************************/  
  PROCEDURE insert_error(
    p_tldet_msg       IN  VARCHAR2,
    p_tldet_source    IN  VARCHAR2,
    p_tldet_context   IN  VARCHAR2) IS    
    
  PRAGMA AUTONOMOUS_TRANSACTION;
  
  BEGIN 
    v_err_cnt_this_session := v_err_cnt_this_session + 1;
    INSERT INTO transaction_log_detail (
      tldet_uid, 
      org_uid, 
      tldtyp_uid, 
      trlog_uid, 
      tldet_msg, 
      tldet_source, 
      tldet_context)
    VALUES (
      tldet_seq.NEXTVAL,
      organization_pkg.get_org_uid,
      lib_pkg.c_tldtyp_error,
      v_trlog_uid,
      p_tldet_msg,
      lower(p_tldet_source),
      p_tldet_context);
    COMMIT;
    
  EXCEPTION
    WHEN OTHERS THEN
      v_err_cnt_this_session := v_err_cnt_this_session + 1;
      COMMIT;     
      lib_pkg.raise_error(
        p_tldet_context, 
        'transaction_log.insert_error', 
        'Error writing to transaction_log_detail: ' || SQLERRM,
        lib_pkg.c_err_logging); 
        
  END insert_error;

/****************************************************************************************
  Procedure to insert a message row into the transaction_log table.
 ****************************************************************************************/  
  PROCEDURE insert_message(
    p_tldet_msg       IN  VARCHAR2) IS   
    
  PRAGMA AUTONOMOUS_TRANSACTION;
  
  BEGIN          
    INSERT INTO transaction_log_detail (
      tldet_uid, 
      org_uid, 
      tldtyp_uid, 
      trlog_uid, 
      tldet_msg, 
      tldet_source, 
      tldet_context)
    VALUES (
      tldet_seq.NEXTVAL,
      organization_pkg.get_org_uid,
      lib_pkg.c_tldtyp_message,
      v_trlog_uid,
      p_tldet_msg,
      NULL,
      NULL);
    COMMIT;
   
  EXCEPTION
    WHEN OTHERS THEN
      COMMIT;  
      lib_pkg.raise_error(
        'Insert Message', 
        'transaction_log.insert_message', 
        'Error writing to transaction_log_detail: ' || SQLERRM, 
        lib_pkg.c_err_logging); 
        
  END insert_message;
  
/****************************************************************************************
  Procedure to insert a message row into the transaction_log table.
 ****************************************************************************************/  
  PROCEDURE insert_warning (
    p_tldet_msg       IN  VARCHAR2,
    p_tldet_context   IN  VARCHAR2) IS
    
  PRAGMA AUTONOMOUS_TRANSACTION;
  
  BEGIN          
    INSERT INTO transaction_log_detail (
      tldet_uid, 
      org_uid, 
      tldtyp_uid, 
      trlog_uid, 
      tldet_msg,  
      tldet_context)
    VALUES (
      tldet_seq.NEXTVAL,
      organization_pkg.get_org_uid,
      lib_pkg.c_tldtyp_warning,
      v_trlog_uid,
      p_tldet_msg,
      p_tldet_context);
    COMMIT;
   
  EXCEPTION
    WHEN OTHERS THEN
      COMMIT;  
      lib_pkg.raise_error(
        'Insert Message', 
        'transaction_log.insert_message', 
        'Error writing to transaction_log_detail: ' || SQLERRM, 
        lib_pkg.c_err_logging); 
        
  END insert_warning;

/****************************************************************************************
  Get Transaction Log Unique ID                                   
 ****************************************************************************************/
  FUNCTION get_trlog_uid 
    RETURN transaction_log.trlog_uid%TYPE AS
    
  BEGIN 
    RETURN v_trlog_uid;
  END get_trlog_uid;
  
/****************************************************************************************
   Start new transaction inserts row into transaction table
 ****************************************************************************************/
  PROCEDURE start_transaction (
    p_context                       IN   transaction_log_detail.tldet_context%TYPE,
    p_org_id                        IN   organization.org_id%TYPE := NULL,
    p_trtyp_uid                     IN   transaction_type.trtyp_uid%TYPE,
    p_usr_naas_id                   IN   user_list.usr_naas_id%TYPE,    
    p_trlog_trans_id                IN   transaction_log.trlog_trans_id%TYPE,
    p_trlog_doc_id                  IN   transaction_log.trlog_doc_id%TYPE,
    p_trlog_other                   IN   transaction_log.trlog_other%TYPE,    
    p_trhead_author                 IN   transaction_header.trhead_author%TYPE := NULL,
    p_trhead_comment                IN   transaction_header.trhead_comment%TYPE := NULL,
    p_trhead_contact_info           IN   transaction_header.trhead_contact_info%TYPE := NULL,
    p_trhead_creation_time          IN   transaction_header.trhead_creation_time%TYPE := NULL,
    p_trhead_id                     IN   transaction_header.trhead_id%TYPE := NULL,
    p_trhead_operation              IN   transaction_header.trhead_operation%TYPE := NULL,
    p_trhead_org_name               IN   transaction_header.trhead_org_name%TYPE := NULL,
    p_trhead_schema_ref             IN   transaction_header.trhead_schema_ref%TYPE := NULL,
    p_trhead_title                  IN   transaction_header.trhead_title%TYPE := NULL,
    p_trlog_start_time              IN   transaction_log.trlog_start_time%TYPE := SYSTIMESTAMP,
    p_trlog_uid                     OUT  transaction_log.trlog_uid%TYPE) AS

    PRAGMA AUTONOMOUS_TRANSACTION;
    
    v_context         transaction_log_detail.tldet_context%TYPE; 
    v_org_uid         organization.org_uid%TYPE;
    v_usr_uid         user_list.usr_uid%TYPE;
    v_trans_created   BOOLEAN := FALSE;
    v_acctyp_uid      access_type.acctyp_uid%TYPE;
    
  BEGIN
    v_context :=  lib_pkg.context_concat(p_context, 'Transaction ID = ' || p_trlog_trans_id); 
    IF p_trlog_start_time IS NULL THEN
      lib_pkg.raise_error(
        p_context, 
        'transaction_pkg.start_transaction',
        'p_start_time parameter cannot be null',
        lib_pkg.c_err_fatal);
    END IF;
    IF p_org_id IS NULL THEN
      v_org_uid := NULL;
    ELSE
      v_org_uid := organization_pkg.get_org_uid(p_org_id);
    END IF;
    IF p_trtyp_uid = lib_pkg.c_trtyp_submit THEN
      v_acctyp_uid := lib_pkg.c_acctyp_full;
    ELSE
      v_acctyp_uid := lib_pkg.c_acctyp_read_only;
    END IF;
    IF upper(p_trhead_operation) NOT IN ('UPDATE-INSERT', 'DELETE') THEN
      lib_pkg.raise_error(
        p_context, 
        'transaction_pkg.start_transaction',
        'Payload Operation must be either "Update-Insert" or "Delete").',
        lib_pkg.c_err_fatal);
    END IF;
    IF p_usr_naas_id IS NOT NULL AND p_org_id IS NOT NULL THEN
      v_usr_uid := lookup_tbl_pkg.get_usr_uid(v_context,p_usr_naas_id);
      IF lib_pkg.user_org_access_allowed(v_usr_uid, v_org_uid, v_acctyp_uid) = 'N' THEN
        lib_pkg.raise_error(
          p_context,
          'transaction_pkg.start_transaction',
          'Unauthorized User "' || p_usr_naas_id 
            || '".  Before you can submit data to WQX your CDX user name must be '
            || 'added to the WQX system, your organization must be added to the system, ' 
            || 'and you must be granted rights to that organization.  Contact STORET/WQX '
            || 'Support for assistance.',
          lib_pkg.c_err_fatal);
      END IF;
    END IF;
    -- Get next sequence value and put into out parameter.
    SELECT trlog_seq.NEXTVAL
      INTO p_trlog_uid
      FROM dual;
    v_trlog_uid := p_trlog_uid;
    v_trtyp_uid := p_trtyp_uid;
    INSERT INTO transaction_log (
        trlog_uid, 
        org_uid, 
        trsta_uid, 
        trtyp_uid, 
        usr_uid, 
        trlog_trans_id, 
        trlog_doc_id, 
        trlog_start_time, 
        trlog_other)
      VALUES (
        v_trlog_uid,
        v_org_uid,
        c_trsta_pending,
        p_trtyp_uid,
        v_usr_uid,
        p_trlog_trans_id,
        p_trlog_doc_id,
        p_trlog_start_time,
        p_trlog_other);
    COMMIT;
    v_trans_created := TRUE;
    -- must do this after the commit so the transaction row will be visible to the log
    IF p_trtyp_uid = lib_pkg.c_trtyp_submit THEN 
      insert_message('Parse and Load started at ' || to_char(p_trlog_start_time, 'MM/DD/YYYY HH:MI:SS AM'));
      INSERT INTO transaction_header (
        trlog_uid,
        org_uid,
        trhead_author,
        trhead_comment,
        trhead_contact_info,
        trhead_creation_time,
        trhead_id,
        trhead_operation,
        trhead_org_name,
        trhead_schema_ref,
        trhead_title)
      VALUES (
        v_trlog_uid,
        v_org_uid,
        p_trhead_author,
        p_trhead_comment,
        p_trhead_contact_info,
        p_trhead_creation_time,
        p_trhead_id,
        p_trhead_operation,
        p_trhead_org_name,
        p_trhead_schema_ref,
        p_trhead_title);
      COMMIT;
    END IF;
    
  EXCEPTION
    WHEN OTHERS THEN
      COMMIT;
      IF v_trans_created THEN
        lib_pkg.raise_error(
          v_context, 
          'transaction_pkg.start_transaction');
      ELSE
        RAISE;
      END IF;
  END start_transaction;

/****************************************************************************************
  Get the number of errors logged for the current transaction/session
 ****************************************************************************************/ 
  FUNCTION get_error_count
    RETURN NUMBER IS
  
    --v_error_count   NUMBER(10);
        
  BEGIN
    RETURN v_err_cnt_this_session;
    /* 
    SELECT COUNT(*)
      INTO v_error_count
      FROM transaction_log_detail 
     WHERE trlog_uid = v_trlog_uid
       AND tldtyp_uid = lib_pkg.c_tldtyp_error;  
    RETURN v_error_count;
    */
  END get_error_count;
  
/****************************************************************************************
   Update final transaction status and end time
 ****************************************************************************************/ 
  FUNCTION end_trans_status (
    p_context   IN  transaction_log_detail.tldet_context%TYPE,
    p_end_time  IN  TIMESTAMP) 
    
    RETURN transaction_log.trsta_uid%TYPE AS
  
    PRAGMA AUTONOMOUS_TRANSACTION;

    v_return        NUMBER;
           
  BEGIN
    IF p_end_time IS NULL THEN
      lib_pkg.raise_error(
        p_context, 
        'transaction_pkg.end_trans_status',
        'p_end_time is required');
    END IF;
    IF get_error_count = 0 THEN
      v_return := c_trsta_success;    
    ELSE
      v_return := c_trsta_failed;
    END IF;
    UPDATE transaction_log
      SET trlog_end_time   = p_end_time,
          trsta_uid        = v_return
      WHERE trlog_uid      = v_trlog_uid;
    COMMIT;
    RETURN v_return;
    
  EXCEPTION
    WHEN OTHERS THEN
      COMMIT;
      lib_pkg.raise_error(
        p_context, 'transaction_pkg.end_trans_status');          
      RETURN c_trsta_failed;
      
  END end_trans_status;
  
/****************************************************************************************
   End Transaction Procedure updates Transaction table as either success or failed based
   on errors logged in the transaction_log table.
****************************************************************************************/ 
  FUNCTION end_transaction (
    p_context  IN  transaction_log_detail.tldet_context%TYPE,
    p_end_time IN  transaction_log.trlog_end_time%TYPE := SYSTIMESTAMP) 
    
    RETURN transaction_log.trsta_uid%TYPE AS
        
    v_context  transaction_log_detail.tldet_context%TYPE;
    v_return   transaction_log.trsta_uid%TYPE;
    
  BEGIN
    v_context := lib_pkg.context_concat(p_context, 'Transaction ID = ' || v_trlog_id);
    v_return := end_trans_status(v_context, p_end_time);
    IF v_trtyp_uid = lib_pkg.c_trtyp_submit THEN 
      transaction_log_pkg.insert_message(
        'Parse and Load completed at ' || to_char(p_end_time, 
        'MM/DD/YYYY HH:MI:SS AM'));
    END IF;
    RETURN v_return; 
      
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        v_context, 
        'transaction_pkg.end_transaction');
      RETURN c_trsta_failed;
      
  END end_transaction;
 
END transaction_log_pkg;
/

prompt
prompt Creating package body XML_QUERY_PKG
prompt ===================================
prompt
CREATE OR REPLACE PACKAGE BODY xml_query_pkg IS

/****************************************************************************************
 *                                PRIVATE CONSTANTS AND TYPES                           *
 ****************************************************************************************/
  c_xml_encoding  CONSTANT VARCHAR2(25) := 'UTF-8';
  --c_xml_encoding  CONSTANT VARCHAR2(25) := 'windows-1252';
  
/****************************************************************************************
 *                                     PRIVATE VARIABLES                                *
 ****************************************************************************************/

/****************************************************************************************
 *                                  PROCEDURES AND FUNCTIONS                            *
 ****************************************************************************************/

  /**************************************************************************************
    Create a new clob and add the standard XML Header to it
   **************************************************************************************/
  FUNCTION create_xml_clob 
    RETURN CLOB IS
  
    v_clob CLOB;
  
  BEGIN
    INSERT INTO xml_clob (
        clob_content)
      VALUES (
        empty_clob())
      RETURNING clob_content 
      INTO v_clob;
    dbms_lob.OPEN(v_clob, dbms_lob.lob_readwrite);
    dbms_lob.append(v_clob, to_clob('<?xml version="1.0" encoding="' || c_xml_encoding || '"?>'));
    RETURN v_clob;
  END create_xml_clob;
  
  /****************************************************************************************
    This fucnction takes two incoming parameters, p_element_name and p_usr_naas_id_from_cdx(reqired)
    It returns XML output of all the WQX lookup data based on the user's input.  It uses
    a temporary CLOB table to store the XML and returns the CLOB to the caller.
   ****************************************************************************************/
  FUNCTION get_domain_values (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_element_name          IN VARCHAR2  := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE) 
    
    RETURN CLOB IS
  
    v_xmltype  xmltype;
    v_xmlclob  CLOB;
    v_element_name VARCHAR2(100) := upper(p_element_name);
  
    CURSOR c_ActivityGroupTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityGroupType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                agt.agtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                agt.agtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(agt.agtyp_last_change_date,
                                                                     'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value")))) 
            FROM activity_group_type agt)))) AS "DomainValue"
      FROM dual;
       
    CURSOR c_ActivityMediaXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityMedia'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
               xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                am.acmed_name AS "value")),
               xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(am.acmed_last_change_date,
                                                                     'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM activity_media am)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ActivityMediaSubdivisionXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityMediaSubdivision'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                ams.amsub_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(ams.amsub_last_change_date,
                                                                 'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
              FROM activity_media_subdivision ams)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ActivityRelativeDepthXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityRelativeDepth'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rd.reldpth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(rd.reldpth_last_change_date,
                                                                 'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM relative_depth rd)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ActivityTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                at.actyp_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                at.actyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('MonitoringLocationRequired' AS "colname",
                                                                at.actyp_mon_loc_req_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('AnalyticalMethodRequired' AS "colname",
                                                                at.actyp_anl_mth_req_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(at.actyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM activity_type at)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_AddressTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'AddressType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                addt.addtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                addt.addtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(addtyp_last_change_Date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM address_type addt)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_AnalyticalMethodXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'AnalyticalMethod'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Identifier' AS "colname",
                                                                am.anlmth_id AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                am.anlmth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('QualifierType' AS "colname",
                                                                am.anlmth_qual_type AS "value")), 
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                am.anlmth_desc AS "value")),                                                                                                                                                                   
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(am.anlmth_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM analytical_method am,
                    analytical_method_context amc
              WHERE am.amctx_uid = amc.amctx_uid
                AND (amc.amctx_epa_managed_yn = 'Y' 
                     OR amc.org_uid IN (SELECT uo.org_uid
                                          FROM user_org_access uo
                                          WHERE uo.usr_uid = lookup_tbl_pkg.get_usr_uid(NULL,p_usr_naas_id_from_cdx))))))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_AnalyticalMethodContextXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'AnalyticalMethodContext'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                am.amctx_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                am.amctx_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('EPAMangaged' AS "colname",
                                                                am.amctx_epa_managed_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(am.amctx_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value")))) 
               FROM (SELECT amc.amctx_cd, amc.amctx_name, amc.amctx_epa_managed_yn, amc.amctx_last_change_date
                       FROM analytical_method_context amc
                       WHERE amc.amctx_epa_managed_yn = 'Y'
                     UNION
                     SELECT o.org_id amctx_cd,
                            o.org_name amctx_name,
                            'N' amctx_epa_managed_yn,
                            o.org_last_change_date amctx_last_change_date
                       FROM organization o,
                            user_org_access uo
                       WHERE o.org_uid = uo.org_uid
                         AND uo.usr_uid = lookup_tbl_pkg.get_usr_uid(NULL,p_usr_naas_id_from_cdx)) am  )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_CharacteristicXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'Characteristic'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                c.chr_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('SRSIdentifier' AS "colname",
                                                                c.chr_srs_id AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('StoretIdentifier' AS "colname",
                                                                c.chr_storet_id AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('PickList' AS "colname",
                                                                c.chr_pick_list_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('SampleFractionRequired' AS "colname",
                                                                c.chr_sample_fraction_req_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname", 
                                                                to_char(c.chr_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM characteristic c)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_CountryXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),   
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'Country'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                c.cntry_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                c.cntry_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(c.cntry_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM country c)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_CountyXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'County'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                c.cnty_fips_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                c.cnty_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(c.cnty_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM county c)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_DetectionQuantLimitTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'DetectionQuantitationLimitType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                dqlt.dqltyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                dqlt.dqltyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(dqlt.dqltyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM detection_quant_limit_type dqlt)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ElectronicAddressTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ElectronicAddressType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                eat.eatyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                eat.eatyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(eat.eatyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM electronic_address_type eat)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_HorizontalCollectMethodXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'HorizontalCollectionMethod'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                hcm.hcmth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                hcm.hcmth_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(hcm.hcmth_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM horizontal_collection_method hcm)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_HorizontalCoordRefSysDatXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'HorizontalCoordinageReferenceSystemDatum'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                hrd.hrdat_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                hrd.hrdat_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(hrd.hrdat_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM horizontal_reference_datum hrd)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_MeasureUnitXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'MeasureUnit'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                mu.msunt_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                mu.msunt_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(mu.msunt_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM measurement_unit mu)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_MonitoringLocationTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'MonitoringLocationType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                mlt.mltyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(mlt.mltyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM monitoring_location_type mlt)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultDetectionConditionXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultDetectionCondition'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rdc.rdcnd_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rdc.rdcnd_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_detection_condition rdc)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultLaboratoryCommentXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultLaboratoryComment'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                rlb.rlcom_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rlb.rlcom_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rlb.rlcom_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_lab_comment rlb)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultSampleFractionXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultSampleFraction'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                sf.smfrc_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                sf.smfrc_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(sf.smfrc_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM sample_fraction sf)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultStatusXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultStatus'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rs.ressta_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rs.ressta_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rs.ressta_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_status rs)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultTemperatureBasisXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultTemperatureBasis'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rtb.rtmpb_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rtb.rtmpb_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rtb.rtmpb_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_temperature_basis rtb)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultTimeBasisXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultTimeBasis'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rtb.rtimb_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rtb.rtimb_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rtb.rtimb_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_time_basis rtb)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultValueTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultValueType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rvt.rvtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rvt.rvtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rvt.rvtyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_value_type rvt)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ResultWeightBasisXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultWeightBasis'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rwb.rwbas_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rwb.rwbas_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rwb.rwbas_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_weight_basis rwb)))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_SampleCollectionEquipmentXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'SampleCollectionEquipment'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                sce.sceqp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('TypeName' AS "colname",
                  (SELECT scept.scetyp_name
                     FROM sample_collection_equip_type scept
                    WHERE scept.scetyp_uid = sce.scetyp_uid) AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(sce.sceqp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM sample_collection_equip sce )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_SampleContainerColorXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'SampleContainerColor'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                cc.concol_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                cc.concol_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(cc.concol_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM container_color cc )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_SampleContainerTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'SampleContainerType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                ct.contyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                ct.contyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(ct.contyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM container_type ct )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_SampleTissueAnatomyXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'SampleTissueAnatomy'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                sta.stant_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(sta.stant_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM sample_tissue_anatomy sta )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_TaxonXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'Taxon'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                t.tax_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Rank' AS "colname",
                                                                tr.txrnk_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(t.tax_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM taxon t,
                    taxon_rank tr
              WHERE tr.txrnk_uid = t.txrnk_uid )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_StateXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'State'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                s.st_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                s.st_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('StateFipsCode' AS "colname",
                                                                s.st_fips_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(s.st_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM state s )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_StatisticalBaseXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'StatisticalBase'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                rsb.rsbas_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rsb.rsbas_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rsb.rsbas_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM Result_Statistical_Base rsb )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_TelephoneNumberTypeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'TelephoneNumberType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                pt.phtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                pt.phtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(pt.phtyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM phone_type pt )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_TimeZoneXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'TimeZone'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                tz.tmzone_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                tz.tmzone_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Offset' AS "colname",
                                                                tz.tmzone_offset AS "value")),                
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(tz.tmzone_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM time_zone tz )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_ThermalPreservativeUsedXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ThermalPreservativeUsed'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                tp.thprsv_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                tp.thprsv_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(tp.thprsv_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM thermal_preservative tp )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_TribeXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'Tribe'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                t.trb_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                t.trb_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(t.trb_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM tribe t )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_VerticalCollectionMethodXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'VerticalCollectionMethod'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                vcm.vcmth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(vcm.vcmth_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM vertical_collection_method vcm )))) AS "DomainValue"
        FROM dual;
       
    CURSOR c_VerticalCoordRefSysDatXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlagg(xmlelement("WQXElement",
          xmlelement("WQXElementName", 'VerticalCoordinateReferenceSystemDatum'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                vrd.vrdat_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                vrd.vrdat_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(vrd.vrdat_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM vertical_reference_datum vrd )))) AS "DomainValue"
        FROM dual;
        
    CURSOR c_DomainValuesXML IS
      SELECT xmlelement("WQXDomainValueList", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_DomainValues_v1.0.xsd' AS "xsi:schemaLocation"),  
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityGroupType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                agt.agtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                agt.agtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(agt.agtyp_last_change_date,
                                                                     'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))  
            FROM activity_group_type agt)), 
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityMedia'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
               xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                am.acmed_name AS "value")),
               xmlelement("WQXElementRowColumn", xmlattributes('Last' AS "colname",
                                                                am.acmed_name AS "value")),                                                                
               xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(am.acmed_last_change_date,
                                                                     'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
              FROM activity_media am)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ActivityMediaSubdivision'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                ams.amsub_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(ams.amsub_last_change_date,
                                                                 'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
             FROM activity_media_subdivision ams)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ActivityRelativeDepth'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rd.reldpth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                 to_char(rd.reldpth_last_change_date,
                                                                 'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))    
              FROM relative_depth rd)),
         xmlelement("WQXElement", 
           xmlelement("WQXElementName", 'ActivityType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                at.actyp_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                at.actyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('MonitoringLocationRequired' AS "colname",
                                                                at.actyp_mon_loc_req_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('AnalyticalMethodRequired' AS "colname",
                                                                at.actyp_anl_mth_req_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(at.actyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))    
              FROM activity_type at)), 
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'AddressType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                addt.addtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                addt.addtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(addt.addtyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
              FROM address_type addt)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'AnalyticalMethod'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Identifier' AS "colname",
                                                                am.anlmth_id AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                am.anlmth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('QualifierType' AS "colname",
                                                                am.anlmth_qual_type AS "value")), 
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                am.anlmth_desc AS "value")),                                                                                                                                                                   
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(am.anlmth_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value")))) 
              FROM analytical_method am)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'AnalyticalMethodContext'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                amc.amctx_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                amc.amctx_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('EPAMangaged' AS "colname",
                                                                amc.amctx_epa_managed_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(amc.amctx_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))  
              FROM analytical_method_context amc)),
         xmlelement("WQXElement", 
           xmlelement("WQXElementName", 'Characteristic'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                c.chr_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('SRSIdentifier' AS "colname",
                                                                c.chr_srs_id AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('StoretIdentifier' AS "colname",
                                                                c.chr_storet_id AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('PickList' AS "colname",
                                                                c.chr_pick_list_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('SampleFractionRequired' AS "colname",
                                                                c.chr_sample_fraction_req_yn AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname", 
                                                                to_char(c.chr_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
              FROM characteristic c)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'Country'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                c.cntry_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                c.cntry_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(c.cntry_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))     
              FROM country c)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'County'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                c.cnty_fips_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                c.cnty_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(c.cnty_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value")))) 
              FROM county c)), 
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'DetectionQuantitationLimitType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                dqlt.dqltyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                dqlt.dqltyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(dqlt.dqltyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))    
              FROM detection_quant_limit_type dqlt)),
         xmlelement("WQXElement",
           xmlelement("WQXElementName", 'ElectronicAddressType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                eat.eatyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                eat.eatyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(eat.eatyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value")))) 
              FROM electronic_address_type eat)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'HorizontalCollectionMethod'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                hcm.hcmth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                hcm.hcmth_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(hcm.hcmth_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))     
              FROM horizontal_collection_method hcm)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'HorizontalCoordinageReferenceSystemDatum'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                hrd.hrdat_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                hrd.hrdat_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(hrd.hrdat_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value")))) 
              FROM horizontal_reference_datum hrd)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'MeasureUnit'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                mu.msunt_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                mu.msunt_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(mu.msunt_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))     
              FROM measurement_unit mu)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'MonitoringLocationType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                mlt.mltyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(mlt.mltyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
              FROM monitoring_location_type mlt)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ResultDetectionCondition'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rdc.rdcnd_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rdc.rdcnd_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))    
              FROM result_detection_condition rdc)),
        xmlelement("WQXElement",
          xmlelement("WQXElementName", 'ResultLaboratoryComment'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                rlb.rlcom_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rlb.rlcom_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rlb.rlcom_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))     
              FROM result_lab_comment rlb)),
         xmlelement("WQXElement", 
           xmlelement("WQXElementName", 'ResultSampleFraction'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                sf.smfrc_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                sf.smfrc_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(sf.smfrc_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM sample_fraction sf)), 
         xmlelement("WQXElement",
           xmlelement("WQXElementName", 'ResultStatus'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rs.ressta_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rs.ressta_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rs.ressta_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_status rs)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ResultTemperatureBasis'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rtb.rtmpb_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rtb.rtmpb_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rtb.rtmpb_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_temperature_basis rtb)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ResultTimeBasis'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rtb.rtimb_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rtb.rtimb_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rtb.rtimb_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_time_basis rtb)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ResultValueType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rvt.rvtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rvt.rvtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rvt.rvtyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_value_type rvt)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ResultWeightBasis'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                rwb.rwbas_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rwb.rwbas_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rwb.rwbas_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM result_weight_basis rwb)),
         xmlelement("WQXElement", 
           xmlelement("WQXElementName", 'SampleCollectionEquipment'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                sce.sceqp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('TypeName' AS "colname",
                  (SELECT scept.scetyp_name
                     FROM sample_collection_equip_type scept
                    WHERE scept.scetyp_uid = sce.scetyp_uid) AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(sce.sceqp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM sample_collection_equip sce)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'SampleContainerColor'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                cc.concol_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                cc.concol_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(cc.concol_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM container_color cc )),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'SampleContainerType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                ct.contyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                ct.contyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(ct.contyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM container_type ct)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'SampleTissueAnatomy'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                sta.stant_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(sta.stant_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM sample_tissue_anatomy sta)), 
         xmlelement("WQXElement",
           xmlelement("WQXElementName", 'Taxon'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                t.tax_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Rank' AS "colname",
                                                                tr.txrnk_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(t.tax_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM taxon t,
                    taxon_rank tr
              WHERE tr.txrnk_uid = t.txrnk_uid)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'State'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                s.st_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                s.st_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('StateFipsCode' AS "colname",
                                                                s.st_fips_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(s.st_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM state s)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'StatisticalBase'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                rsb.rsbas_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                rsb.rsbas_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(rsb.rsbas_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM Result_Statistical_Base rsb)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'TelephoneNumberType'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                pt.phtyp_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                pt.phtyp_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(pt.phtyp_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM phone_type pt)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'TimeZone'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                tz.tmzone_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                tz.tmzone_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Offset' AS "colname",
                                                                tz.tmzone_offset AS "value")),                
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(tz.tmzone_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM time_zone tz)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'ThermalPreservativeUsed'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                tp.thprsv_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                tp.thprsv_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(tp.thprsv_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM thermal_preservative tp)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'Tribe'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Code' AS "colname",
                                                                t.trb_cd AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                t.trb_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(t.trb_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM tribe t)),
        xmlelement("WQXElement", 
          xmlelement("WQXElementName", 'VerticalCollectionMethod'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                vcm.vcmth_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(vcm.vcmth_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM vertical_collection_method vcm)),
         xmlelement("WQXElement",
           xmlelement("WQXElementName", 'VerticalCoordinateReferenceSystemDatum'),
            (SELECT xmlagg(
              xmlelement("WQXElementRow",
                xmlelement("WQXElementRowColumn", xmlattributes('Name' AS "colname",
                                                                vrd.vrdat_name AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('Description' AS "colname",
                                                                vrd.vrdat_desc AS "value")),
                xmlelement("WQXElementRowColumn", xmlattributes('LastChangeDate' AS "colname",
                                                                to_char(vrd.vrdat_last_change_date,
                                                                'YYYY-MM-DD"T":HH24:MI:SS') || SESSIONTIMEZONE AS "value"))))
               FROM vertical_reference_datum vrd))) AS "DomainValue"
        FROM dual;  
      
  BEGIN
    v_xmlclob := create_xml_clob();
    -- Check required fields for null values for Query transactions
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_domain_values',
        p_error_msg => 'NAAS User ID is required',
        p_force_err_yn => 'Y');
    END IF;
    IF p_trtyp_uid = lib_pkg.c_trtyp_query THEN
      IF v_element_name IS NULL THEN
        lib_pkg.raise_error( 
          p_context => NULL,
          p_source => 'xml_query_pkg.get_domain_values',
          p_error_msg => 'Element Name is required for a Query.  To retrieve all domain value lists, use Solicit.',
          p_force_err_yn => 'Y');
      END IF;
    END IF;
    IF v_element_name = 'ACTIVITYGROUPTYPE' THEN
      OPEN c_ActivityGroupTypeXML;
      LOOP
        FETCH c_ActivityGroupTypeXML
          INTO v_xmltype;
        EXIT WHEN c_ActivityGroupTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ACTIVITYMEDIA' THEN
      OPEN c_ActivityMediaXML;
      LOOP
        FETCH c_ActivityMediaXML
          INTO v_xmltype;
        EXIT WHEN c_ActivityMediaXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ACTIVITYMEDIASUBDIVISION' THEN
      OPEN c_ActivityMediaSubdivisionXML;
      LOOP
        FETCH c_ActivityMediaSubdivisionXML
          INTO v_xmltype;
        EXIT WHEN c_ActivityMediaSubdivisionXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ACTIVITYRELATIVEDEPTH' THEN
      OPEN c_ActivityRelativeDepthXML;
      LOOP
        FETCH c_ActivityRelativeDepthXML
          INTO v_xmltype;
        EXIT WHEN c_ActivityRelativeDepthXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ACTIVITYTYPE' THEN
      OPEN c_ActivityTypeXML;
      LOOP
        FETCH c_ActivityTypeXML
          INTO v_xmltype;
        EXIT WHEN c_ActivityTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ADDRESSTYPE' THEN
      OPEN c_AddressTypeXML;
      LOOP
        FETCH c_AddressTypeXML
          INTO v_xmltype;
        EXIT WHEN c_AddressTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ANALYTICALMETHOD' THEN
      OPEN c_AnalyticalMethodXML;
      LOOP
        FETCH c_AnalyticalMethodXML
          INTO v_xmltype;
        EXIT WHEN c_AnalyticalMethodXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ANALYTICALMETHODCONTEXT' THEN
      OPEN c_AnalyticalMethodContextXML;
      LOOP
        FETCH c_AnalyticalMethodContextXML
          INTO v_xmltype;
        EXIT WHEN c_AnalyticalMethodContextXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'CHARACTERISTIC' THEN
      OPEN c_CharacteristicXML;
      LOOP
        FETCH c_CharacteristicXML
          INTO v_xmltype;
        EXIT WHEN c_CharacteristicXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'COUNTRY' THEN
      OPEN c_CountryXML;
      LOOP
        FETCH c_CountryXML
          INTO v_xmltype;
        EXIT WHEN c_CountryXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'COUNTY' THEN
      OPEN c_CountyXML;
      LOOP
        FETCH c_CountryXML
          INTO v_xmltype;
        EXIT WHEN c_CountyXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'DETECTIONQUANTITATIONLIMITTYPE' THEN
      OPEN c_DetectionQuantLimitTypeXML;
      LOOP
        FETCH c_DetectionQuantLimitTypeXML
          INTO v_xmltype;
        EXIT WHEN c_DetectionQuantLimitTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'ELECTRONICADDRESSTYPE' THEN
      OPEN c_ElectronicAddressTypeXML;
      LOOP
        FETCH c_ElectronicAddressTypeXML
          INTO v_xmltype;
        EXIT WHEN c_ElectronicAddressTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'HORIZONTALCOLLECTIONMETHOD' THEN
      OPEN c_HorizontalCollectMethodXML;
      LOOP
        FETCH c_HorizontalCollectMethodXML
          INTO v_xmltype;
        EXIT WHEN c_HorizontalCollectMethodXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'HORIZONTALCOORDINATEREFERENCESYSTEMDATUM' THEN
      OPEN c_HorizontalCoordRefSysDatXML;
      LOOP
        FETCH c_HorizontalCoordRefSysDatXML
          INTO v_xmltype;
        EXIT WHEN c_HorizontalCoordRefSysDatXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'MEASUREUNIT' THEN
      OPEN c_MeasureUnitXML;
      LOOP
        FETCH c_MeasureUnitXML
          INTO v_xmltype;
        EXIT WHEN c_MeasureUnitXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'MONITORINGLOCATIONTYPE' THEN
      OPEN c_MonitoringLocationTypeXML;
      LOOP
        FETCH c_MonitoringLocationTypeXML
          INTO v_xmltype;
        EXIT WHEN c_MonitoringLocationTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTDETECTIONCONDITION' THEN
      OPEN c_ResultDetectionConditionXML;
      LOOP
        FETCH c_ResultDetectionConditionXML
          INTO v_xmltype;
        EXIT WHEN c_ResultDetectionConditionXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTLABORATORYCOMMENT' THEN
      OPEN c_ResultLaboratoryCommentXML;
      LOOP
        FETCH c_ResultLaboratoryCommentXML
          INTO v_xmltype;
        EXIT WHEN c_ResultLaboratoryCommentXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTSAMPLEFRACTION' THEN
      OPEN c_ResultSampleFractionXML;
      LOOP
        FETCH c_ResultSampleFractionXML
          INTO v_xmltype;
        EXIT WHEN c_ResultSampleFractionXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTSTATUS' THEN
      OPEN c_ResultStatusXML;
      LOOP
        FETCH c_ResultStatusXML
          INTO v_xmltype;
        EXIT WHEN c_ResultStatusXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTTEMPERATUREBASIS' THEN
      OPEN c_ResultTemperatureBasisXML;
      LOOP
        FETCH c_ResultTemperatureBasisXML
          INTO v_xmltype;
        EXIT WHEN c_ResultTemperatureBasisXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTTIMEBASIS' THEN
      OPEN c_ResultTimeBasisXML;
      LOOP
        FETCH c_ResultTimeBasisXML
          INTO v_xmltype;
        EXIT WHEN c_ResultTimeBasisXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTVALUETYPE' THEN
      OPEN c_ResultValueTypeXML;
      LOOP
        FETCH c_ResultValueTypeXML
          INTO v_xmltype;
        EXIT WHEN c_ResultValueTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'RESULTWEIGHTBASIS' THEN
      OPEN c_ResultWeightBasisXML;
      LOOP
        FETCH c_ResultWeightBasisXML
          INTO v_xmltype;
        EXIT WHEN c_ResultWeightBasisXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'SAMPLECOLLECTIONEQUIPMENT' THEN
      OPEN c_SampleCollectionEquipmentXML;
      LOOP
        FETCH c_SampleCollectionEquipmentXML
          INTO v_xmltype;
        EXIT WHEN c_SampleCollectionEquipmentXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'SAMPLECONTAINERCOLOR' THEN
      OPEN c_SampleContainerColorXML;
      LOOP
        FETCH c_SampleContainerColorXML
          INTO v_xmltype;
        EXIT WHEN c_SampleContainerColorXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'SAMPLECONTAINERTYPE' THEN
      OPEN c_SampleContainerTypeXML;
      LOOP
        FETCH c_SampleContainerTypeXML
          INTO v_xmltype;
        EXIT WHEN c_SampleContainerTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'SAMPLETISSUEANATOMY' THEN
      OPEN c_SampleTissueAnatomyXML;
      LOOP
        FETCH c_SampleTissueAnatomyXML
          INTO v_xmltype;
        EXIT WHEN c_SampleTissueAnatomyXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'TAXON' THEN
      OPEN c_TaxonXML;
      LOOP
        FETCH c_TaxonXML
          INTO v_xmltype;
        EXIT WHEN c_TaxonXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'STATE' THEN
      OPEN c_StateXML;
      LOOP
        FETCH c_StateXML
          INTO v_xmltype;
        EXIT WHEN c_StateXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'STATISTICALBASE' THEN
      OPEN c_StatisticalBaseXML;
      LOOP
        FETCH c_StatisticalBaseXML
          INTO v_xmltype;
        EXIT WHEN c_StatisticalBaseXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'TELEPHONENUMBERTYPE' THEN
      OPEN c_TelephoneNumberTypeXML;
      LOOP
        FETCH c_TelephoneNumberTypeXML
          INTO v_xmltype;
        EXIT WHEN c_TelephoneNumberTypeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'TIMEZONE' THEN
      OPEN c_TimeZoneXML;
      LOOP
        FETCH c_TimeZoneXML
          INTO v_xmltype;
        EXIT WHEN c_TimeZoneXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'THERMALPRESERVATIVEUSED' THEN
      OPEN c_ThermalPreservativeUsedXML;
      LOOP
        FETCH c_ThermalPreservativeUsedXML
          INTO v_xmltype;
        EXIT WHEN c_ThermalPreservativeUsedXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'TRIBE' THEN
      OPEN c_TribeXML;
      LOOP
        FETCH c_TribeXML
          INTO v_xmltype;
        EXIT WHEN c_TribeXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'VERTICALCOLLECTIONMETHOD' THEN
      OPEN c_VerticalCollectionMethodXML;
      LOOP
        FETCH c_VerticalCollectionMethodXML
          INTO v_xmltype;
        EXIT WHEN c_VerticalCollectionMethodXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name = 'VERTICALCOORDINATEREFERENCESYSTEMDATUM' THEN
      OPEN c_VerticalCoordRefSysDatXML;
      LOOP
        FETCH c_VerticalCoordRefSysDatXML
          INTO v_xmltype;
        EXIT WHEN c_VerticalCoordRefSysDatXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    ELSIF v_element_name IS NULL THEN
      OPEN c_DomainValuesXML;
      LOOP
        FETCH c_DomainValuesXML
          INTO v_xmltype;
        EXIT WHEN c_DomainValuesXML%NOTFOUND;
        dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
      END LOOP;
      dbms_lob.CLOSE(v_xmlclob);
    END IF;
    RETURN v_xmlclob;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_domain_values',
        p_force_err_yn => 'Y');
  
  END get_domain_values;
  
  /****************************************************************************************
    This fucnction takes five incoming parameters, p_org_id, p_usr_naas_id(req), 
    p_in_usr_naas_id, p_trlog_start_time, and p_trlog_start_time_end.  It returns XML output of 
    all the WQX transactions linked to a user and/or organization.  It only returns data that
    the calling p_usr_naas_id has access to. It uses a temporary CLOB table to store the 
    XML and returns the CLOB to the caller.
   ****************************************************************************************/
  FUNCTION get_transaction_history (
    p_trtyp_uid               IN transaction_type.trtyp_uid%TYPE,
    p_org_id                  IN organization.org_id%TYPE               := NULL,
    p_usr_naas_id             IN user_list.usr_naas_id%TYPE             := NULL,
    p_trlog_trans_id          IN transaction_log.trlog_trans_id%TYPE    := NULL,
    p_trlog_start_time_begin  IN transaction_log.trlog_start_time%TYPE  := NULL,
    p_trlog_start_time_end    IN transaction_log.trlog_start_time%TYPE  := NULL,
    p_usr_naas_id_from_cdx    IN user_list.usr_naas_id%TYPE) 
    
    RETURN CLOB IS
  
    v_xmltype  xmltype;
    v_xmlclob  CLOB;
  
    CURSOR c_xml IS
      SELECT xmlelement("WQXTransactionHistory", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_TransactionHistory_v1.0.xsd' AS "xsi:schemaLocation"),  
          (SELECT xmlagg(
            xmlelement("TransactionRecord",
              xmlelement("TransactionOrganizationIdentifier",o.org_id),
              xmlelement("TransactionUserName", u.usr_naas_id),
              xmlelement("TransactionIdentifier",t.trlog_trans_id),
              xmlelement("TransactionStartDate",to_char(t.trlog_start_time,'YYYY-MM-DD')),
              xmlelement("TransactionStartTime",decode(t.trlog_start_time, null, null,to_char(t.trlog_start_time,'HH24:MI:SS') || SESSIONTIMEZONE)),
              xmlelement("TransactionEndDate", to_char(t.trlog_end_time,'YYYY-MM-DD')),
              xmlelement("TransactionEndTime",decode(t.trlog_end_time,null, null,to_char(t.trlog_end_time,'HH24:MI:SS') || SESSIONTIMEZONE)),
              xmlelement("TransactionTypeName", tt.trtyp_name),
              xmlelement("TransactionStatusName",s.trsta_name),
              xmlelement("TransactionHeaderAuthor",h.trhead_author),
              xmlelement("TransactionPayloadOperationName",h.trhead_operation),
              xmlelement("TransactionCommentText",t.trlog_other)))
             FROM transaction_log t,
                  transaction_header h,
                  transaction_status s,
                  transaction_type tt,
                  user_list u,
                  organization o
            WHERE t.org_uid = o.org_uid (+)
              AND t.usr_uid = u.usr_uid
              AND t.trsta_uid = s.trsta_uid
              AND t.trtyp_uid = tt.trtyp_uid
              AND t.trlog_uid = h.trlog_uid (+)
              AND u.usr_naas_id = nvl(p_usr_naas_id, u.usr_naas_id)
              AND (t.trlog_trans_id = p_trlog_trans_id
                   OR p_trlog_trans_id IS NULL)
              AND (t.trlog_start_time >= p_trlog_start_time_begin
                   OR p_trlog_start_time_begin IS NULL)
              AND (t.trlog_start_time <= p_trlog_start_time_end
                   OR p_trlog_start_time_end IS NULL)
              AND o.org_id = nvl(upper(p_org_id), o.org_id)
              AND o.org_uid IN (SELECT uo.org_uid
                                 FROM user_org_access uo
                                WHERE uo.usr_uid = lookup_tbl_pkg.get_usr_uid(NULL,p_usr_naas_id_from_cdx))
              )) AS "Transaction"
        FROM dual;
  
  BEGIN                                        
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_transaction_history',
        p_error_msg => 'NAAS User ID is required',
        p_force_err_yn => 'Y');
    END IF;
    IF (p_org_id IS NULL AND p_usr_naas_id IS NULL AND p_trlog_trans_id IS NULL) THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_transaction_history',
        p_error_msg => 'You must provide an Organization Identifier, User Identifier, or Transaction Identifier.',
        p_force_err_yn => 'Y'); 
    END IF;    
    v_xmlclob := create_xml_clob();
    
    OPEN c_xml;
    LOOP
      FETCH c_xml
        INTO v_xmltype;
      EXIT WHEN c_xml%NOTFOUND;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    END LOOP;
  
    dbms_lob.CLOSE(v_xmlclob);
  
    RETURN v_xmlclob;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_transaction_history',
        p_force_err_yn => 'Y'); 
    
  END get_transaction_history;
  
  /****************************************************************************************
    This fucnction takes three incoming parameters, p_org_id(req), p_prj_id,
    and p_usr_naas_id_from_cdx(req).  It returns XML output of all the WQX projects based on the
    user input.  It only returns data that the calling p_usr_naas_id_from_cdx has access to. 
    It uses a temporary CLOB table to store the XML and returns the CLOB to the caller.
   ****************************************************************************************/
  FUNCTION get_project (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_prj_id                IN project.prj_id%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE) 
    
    RETURN CLOB IS
  
    v_xmltype   xmltype;
    v_xmlclob   CLOB := NULL;
    v_prj_cnt   NUMBER;
    
    CURSOR c_xml IS
      SELECT xmlelement("WQX", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_WQX_v1.0.xsd' AS "xsi:schemaLocation"),  
              xmlelement("Organization",
                xmlelement("OrganizationDescription", 
                  xmlelement("OrganizationIdentifier", o.org_id), 
                  xmlelement("OrganizationFormalName", o.org_name), 
                  xmlelement("OrganizationDescriptionText", o.org_desc), 
                  xmlelement("TribalCode", t.trb_cd)),
                (SELECT xmlagg(
                  xmlelement("Project", 
                    xmlelement("ProjectIdentifier", p.prj_id), 
                    xmlelement("ProjectName", p.prj_name), 
                    xmlelement("ProjectDescriptionText", p.prj_desc), 
                    (SELECT xmlagg(xmlelement("AttachedBinaryObject", 
                                    xmlelement("BinaryObjectFileName", a.atobj_file_name), 
                                    xmlelement("BinaryObjectFileTypeCode", a.atobj_type)))
                       FROM attached_object a
                      WHERE a.org_uid = o.org_uid
                        AND a.tbl_uid = lib_pkg.c_tbl_project
                        AND a.ref_uid = p.prj_uid)))
                    FROM project p
                   WHERE p.org_uid = o.org_uid
                     AND p.prj_id = nvl(p_prj_id,p.prj_id)))) AS "Project"
        FROM organization o,
             tribe t
       WHERE o.org_id = upper(p_org_id)
         AND o.trb_uid = t.trb_uid (+);
  
  BEGIN
    -- Check required fields for null values for Query transactions
    IF p_org_id IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_project',
        p_error_msg => 'Organization Identifier is required',
        p_force_err_yn => 'Y');
    END IF;
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_project',
        p_error_msg => 'NAAS User ID is required',
        p_force_err_yn => 'Y');
    END IF;
    -- Get count of records to be returned if over 1000 records then error on Query request
    IF p_trtyp_uid = lib_pkg.c_trtyp_query THEN
      SELECT COUNT(*)
        INTO v_prj_cnt
        FROM project p, organization o
       WHERE o.org_id = upper(p_org_id)
         AND p.org_uid = o.org_uid
         AND p.prj_id = nvl(p_prj_id,p.prj_id);
      IF v_prj_cnt > 1000 THEN
         lib_pkg.raise_error( 
           p_context => NULL,
           p_source => 'xml_query_pkg.get_project',
           p_error_msg => 'Your query exceeded the 1000 records allowed for a Query, please use Solicit.',
           p_force_err_yn => 'Y');
       END IF;
    END IF;
    v_xmlclob := create_xml_clob();
    OPEN c_xml;
    LOOP
      FETCH c_xml
        INTO v_xmltype;
      EXIT WHEN c_xml%NOTFOUND;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    END LOOP;
    dbms_lob.CLOSE(v_xmlclob);
    RETURN v_xmlclob;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_project',
        p_force_err_yn => 'Y'); 
          
  END get_project;
  
  /****************************************************************************************
    This function takes three incoming parameters, p_org_id(req), p_mloc_id,
    and p_usr_naas_id_from_cdx(req).  It returns XML output of all the WQX Monitoring Locations 
    based on the user input.  It only returns data that the calling p_usr_naas_id_from_cdx has 
    access to. It uses a temporary CLOB table to store the XML and returns the CLOB to the 
    caller.
   ****************************************************************************************/
  FUNCTION get_monitoring_location (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_mloc_id               IN monitoring_location.mloc_id%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    
    RETURN CLOB IS
  
    v_xmltype  xmltype;
    v_xmlclob  CLOB;
    v_mloc_cnt NUMBER;
  
    CURSOR c_xml IS
      SELECT xmlelement("WQX", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_WQX_v1.0.xsd' AS "xsi:schemaLocation"),  
              xmlelement("Organization",
                xmlelement("OrganizationDescription", 
                  xmlelement("OrganizationIdentifier", o.org_id), 
                  xmlelement("OrganizationFormalName", o.org_name), 
                  xmlelement("OrganizationDescriptionText", o.org_desc), 
                  xmlelement("TribalCode", t.trb_cd)), 
                (SELECT xmlagg(
                  xmlelement("MonitoringLocation",
                    xmlelement("MonitoringLocationIdentity",
                      xmlelement("MonitoringLocationIdentifier", m.mloc_id),
                      xmlelement("MonitoringLocationName", m.mloc_name),
                      xmlelement("MonitoringLocationTypeName", 
                        (SELECT mt.mltyp_name 
                           FROM monitoring_location_type mt 
                          WHERE mt.mltyp_uid = m.mltyp_uid)),
                      xmlelement("MonitoringLocationDescriptionText", m.mloc_desc),
                      xmlelement("HUCEightDigitCode", m.mloc_huc_8),
                      xmlelement("HUCTwelveDigitCode", m.mloc_huc_12),
                      xmlelement("TribalLandIndicator", decode(m.mloc_tribal_land_yn, 'Y', 'true','N', 'false', 'false')),
                      xmlelement("TribalLandName", m.mloc_tribal_land_name),
                      (SELECT xmlagg(
                        xmlelement("AlternateMonitoringLocationIdentity",
                          xmlelement("MonitoringLocationIdentifier", mla.mlalt_id),
                          xmlelement("MonitoringLocationIdentifierContext", mla.mlalt_context)))
                         FROM monitoring_location_alternate mla
                        WHERE mla.mloc_uid = m.mloc_uid)),
                    xmlelement("MonitoringLocationGeospatial",
                      xmlelement("LatitudeMeasure", m.mloc_latitude),
                      xmlelement("LongitudeMeasure", m.mloc_longitude),
                      xmlelement("SourceMapScaleNumeric", m.mloc_source_map_scale),
                      xmlelement("HorizontalCollectionMethodName", 
                        (SELECT h.hcmth_name 
                           FROM horizontal_collection_method h
                          WHERE h.hcmth_uid = m.hcmth_uid)),
                      xmlelement("HorizontalCoordinateReferenceSystemDatumName", 
                        (SELECT hrd.hrdat_name
                           FROM horizontal_reference_datum hrd
                          WHERE hrd.hrdat_uid = m.hrdat_uid)),
                      xmlelement("VerticalMeasure",
                        xmlelement("MeasureValue", m.mloc_vertical_measure),
                        xmlelement("MeasureUnitCode",
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = m.msunt_uid))),
                      xmlelement("VerticalCollectionMethodName", 
                        (SELECT v.vcmth_name
                           FROM vertical_collection_method v
                          WHERE v.vcmth_uid = m.vcmth_uid)),
                      xmlelement("VerticalCoordinateReferenceSystemDatumName", 
                        (SELECT vr.vrdat_name
                           FROM vertical_reference_datum vr
                          WHERE vr.vrdat_uid = m.vrdat_uid)),
                      xmlelement("CountryCode", 
                        (SELECT c.cntry_cd
                           FROM country c
                          WHERE c.cntry_uid = m.cntry_uid)),
                      xmlelement("StateCode",
                        (SELECT s.st_cd 
                           FROM state s
                          WHERE s.st_uid = m.st_uid)),
                      xmlelement("CountyCode",
                        (SELECT cnty.cnty_fips_cd
                           FROM county cnty
                          WHERE cnty.cnty_uid = m.cnty_uid))),
                    (SELECT xmlagg(xmlelement("AttachedBinaryObject", 
                                    xmlelement("BinaryObjectFileName", a.atobj_file_name), 
                                    xmlelement("BinaryObjectFileTypeCode", a.atobj_type)))
                       FROM attached_object a
                      WHERE a.org_uid = m.org_uid
                        AND a.tbl_uid = lib_pkg.c_tbl_monitoring_location
                        AND a.ref_uid = m.mloc_uid)))
                    FROM monitoring_location m
                   WHERE m.org_uid = o.org_uid
                     AND m.mloc_id = nvl(p_mloc_id,m.mloc_id)))) AS "MonitoringLocation"
        FROM organization o,
             tribe t
       WHERE o.org_id = upper(p_org_id)
         AND o.trb_uid = t.trb_uid (+);
  
  BEGIN
    -- Check required fields for null values for Query transactions
    IF p_org_id IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_monitoring_location',
        p_error_msg => 'Organization Identifier is required',
        p_force_err_yn => 'Y');
    END IF;
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_monitoring_location',
        p_error_msg => 'NAAS User Id is required',
        p_force_err_yn => 'Y');
    END IF;
    -- Get count of records to be returned if over 1000 records then error on Query request
    IF p_trtyp_uid = lib_pkg.c_trtyp_query THEN
      SELECT COUNT(*)
        INTO v_mloc_cnt
        FROM monitoring_location m, organization o
       WHERE o.org_id = upper(p_org_id)
         AND m.org_uid = o.org_uid
         AND m.mloc_id = nvl(p_mloc_id,m.mloc_id);
       IF v_mloc_cnt > 1000 THEN
         lib_pkg.raise_error( 
           p_context => NULL,
           p_source => 'xml_query_pkg.get_monitoring_location',
           p_error_msg => 'Your query exceeded the 1000 records allowed for a Query, please use Solicit.',
           p_force_err_yn => 'Y');
       END IF;
    END IF;
    v_xmlclob := create_xml_clob();
    OPEN c_xml;
    LOOP
      FETCH c_xml
        INTO v_xmltype;
      EXIT WHEN c_xml%NOTFOUND;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    END LOOP;
    dbms_lob.CLOSE(v_xmlclob);
    RETURN v_xmlclob;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_monitoring_location',
        p_force_err_yn => 'Y'); 
          
  END get_monitoring_location;
  
  /****************************************************************************************
    This fucnction takes seven incoming parameters, p_org_id(req), p_mloc_id,
    p_prj_id, p_act_id, p_act_start_date, p_act_end_date and p_usr_naas_id_from_cdx(req).  
    It returns XML output of all the WQX Activities  based on the user input.  It only 
    returns data that the calling p_usr_naas_id_from_cdx has access to. It uses a temporary CLOB 
    table to store the XML and returns the CLOB to the caller.
   ****************************************************************************************/ 
  FUNCTION get_activity (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_mloc_id               IN monitoring_location.mloc_id%TYPE := NULL,
    p_prj_id                IN project.prj_id%TYPE := NULL,
    p_act_id                IN activity.act_id%TYPE := NULL,
    p_act_start_date_begin  IN activity.act_start_date%TYPE := NULL,
    p_act_start_date_end    IN activity.act_start_date%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    
    RETURN CLOB IS
  
    v_xmltype   xmltype;
    v_xmlclob   CLOB;
    v_act_cnt   NUMBER;
  
    CURSOR c_xml IS
      SELECT xmlelement("WQX", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_WQX_v1.0.xsd' AS "xsi:schemaLocation"), 
              xmlelement("Organization",
                xmlelement("OrganizationDescription", 
                  xmlelement("OrganizationIdentifier", o.org_id), 
                  xmlelement("OrganizationFormalName", o.org_name), 
                  xmlelement("OrganizationDescriptionText", o.org_desc), 
                  xmlelement("TribalCode", tr.trb_cd)), 
                (SELECT xmlagg(
                  xmlelement("Activity",
                    xmlelement("ActivityDescription",
                      xmlelement("ActivityIdentifier", a.act_id),
                      xmlelement("ActivityTypeCode", 
                        (SELECT at.actyp_cd 
                           FROM activity_type at
                          WHERE at.actyp_uid = a.actyp_uid)),
                      xmlelement("ActivityMediaName", 
                        (SELECT am.acmed_name
                           FROM activity_media am
                          WHERE am.acmed_uid = a.acmed_uid)),
                      xmlelement("ActivityMediaSubdivisionName",
                        (SELECT ams.amsub_name
                           FROM activity_media_subdivision ams
                          WHERE ams.amsub_uid = a.amsub_uid)),
                      xmlelement("ActivityStartDate", to_char(a.act_start_date,'YYYY-MM-DD')),
                      xmlelement("ActivityStartTime", 
                        xmlelement("Time", to_char(a.act_start_time,'HH24:MI:SS')),
                        xmlelement("TimeZoneCode",astz.tmzone_cd)),
                      xmlelement("ActivityEndDate", to_char(a.act_end_date,'YYYY-MM-DD')),
                      xmlelement("ActivityEndTime",
                        xmlelement("Time", to_char(a.act_end_time,'HH24:MI:SS')),
                        xmlelement("TimeZoneCode",aetz.tmzone_cd)),
                      xmlelement("ActivityRelativeDepthName", 
                        (SELECT rd.reldpth_name
                           FROM relative_depth rd
                          WHERE rd.reldpth_uid = a.reldpth_uid)),
                      xmlelement("ActivityDepthHeightMeasure",
                        xmlelement("MeasureValue", a.act_depth_height),
                        xmlelement("MeasureUnitCode", 
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = a.msunt_uid_depth_height))),
                      xmlelement("ActivityTopDepthHeightMeasure",
                        xmlelement("MeasureValue", a.act_depth_height_top),
                        xmlelement("MeasureUnitCode",
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = a.msunt_uid_depth_height_top))),
                      xmlelement("ActivityBottomDepthHeightMeasure",
                        xmlelement("MeasureValue", a.act_depth_height_bottom),
                        xmlelement("MeasureUnitCode",
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = a.msunt_uid_depth_height_bottom))),
                      xmlelement("ActivityDepthAltitudeReferencePointText", a.act_depth_altitude_ref_point),
                      (SELECT xmlagg(
                        xmlelement("ProjectIdentifier", p.prj_id))
                         FROM project p,
                              activity_project ap
                        WHERE ap.act_uid = a.act_uid
                          AND ap.prj_uid = p.prj_uid),
                      xmlelement("ActivityConductingOrganizationText", 
                          (SELECT aco.acorg_name
                             FROM activity_conducting_org aco
                             WHERE aco.org_uid = o.org_uid
                               AND aco.act_uid = a.act_uid)),
                       (SELECT xmlagg(
                          xmlelement("MonitoringLocationIdentifier", ml.mloc_id))
                           FROM monitoring_location ml
                           WHERE ml.mloc_uid = a.mloc_uid
                             AND ml.org_uid = o.org_uid),                      
                      xmlelement("ActivityCommentText", a.act_comments)),
                    xmlelement("ActivityLocation",
                      xmlelement("LatitudeMeasure", a.act_loc_latitude),
                      xmlelement("LongitudeMeasure", a.act_loc_longitude),
                      xmlelement("SourceMapScaleNumeric", a.act_loc_source_map_scale),
                      xmlelement("HorizontalCollectionMethodName", 
                        (SELECT hcm.hcmth_name
                           FROM horizontal_collection_method hcm
                          WHERE hcm.hcmth_uid = a.hcmth_uid)),
                      xmlelement("HorizontalCoordinateReferenceSystemDatumName",
                        (SELECT hrd.hrdat_name
                           FROM horizontal_reference_datum hrd
                          WHERE hrd.hrdat_uid = a.hrdat_uid))),
                    xmlelement("SampleDescription",
                      xmlelement("SampleCollectionMethod",
                        xmlelement("MethodIdentifier", a.act_sam_collect_meth_id),
                        xmlelement("MethodIdentifierContext", a.act_sam_collect_meth_context),
                        xmlelement("MethodName", a.act_sam_collect_meth_name),
                        xmlelement("MethodQualifierTypeName", a.act_sam_collect_meth_qual_type),
                        xmlelement("MethodDescriptionText", a.act_sam_collect_meth_desc)),
                      xmlelement("SampleTissueTaxonomicName",
                        (SELECT t.tax_name
                           FROM taxon t
                          WHERE t.tax_uid = a.tax_uid)),
                      xmlelement("SampleTissueAnatomyName",
                        (SELECT sta.stant_name
                           FROM sample_tissue_anatomy sta
                          WHERE sta.stant_uid = a.stant_uid)),
                      xmlelement("SampleCollectionEquipmentName", 
                        (SELECT sce.sceqp_name
                           FROM sample_collection_equip sce
                          WHERE sce.sceqp_uid = a.sceqp_uid)),
                      xmlelement("SampleCollectionEquipmentCommentText", a.act_sam_collect_equip_comments),
                      xmlelement("SamplePreparation",
                        xmlelement("SamplePreparationMethod",
                          xmlelement("MethodIdentifier", a.act_sam_prep_meth_id),
                          xmlelement("MethodIdentifierContext", a.act_sam_prep_meth_context),
                          xmlelement("MethodName", a.act_sam_prep_meth_name),
                          xmlelement("MethodQualifierTypeName", a.act_sam_prep_meth_qual_type),
                          xmlelement("MethodDescriptionText", a.act_sam_prep_meth_desc)),
                        xmlelement("SampleContainerTypeName", 
                          (SELECT ct.contyp_name
                             FROM container_type ct
                            WHERE ct.contyp_uid = a.contyp_uid)),
                        xmlelement("SampleContainerColorName",
                          (SELECT cc.concol_name
                             FROM container_color cc
                            WHERE cc.concol_uid = a.concol_uid)),
                        xmlelement("ChemicalPreservativeUsedName", a.act_sam_chemical_preservative),
                        xmlelement("ThermalPreservativeUsedName",
                          (SELECT tp.thprsv_name
                             FROM thermal_preservative tp
                            WHERE tp.thprsv_uid = a.thprsv_uid)),
                        xmlelement("SampleTransportStorageDescription", a.act_sam_transport_storage_desc))),
                      (SELECT xmlagg(
                        xmlelement("AttachedBinaryObject",
                          xmlelement("BinaryObjectFileName",ao.atobj_file_name),
                          xmlelement("BinaryObjectFileTypeCode", ao.atobj_type)))
                           FROM attached_object ao
                          WHERE ao.org_uid = a.org_uid
                            AND ao.tbl_uid = lib_pkg.c_tbl_activity
                            AND ao.ref_uid = a.mloc_uid),
                       xmlelement("ResultCount",
                        (SELECT COUNT(*)
                          FROM RESULT r
                         WHERE r.org_uid = o.org_uid
                           AND r.act_uid = a.act_uid))))
              FROM activity a,
                   time_zone astz,
                   time_zone aetz
             WHERE a.org_uid = o.org_uid
               AND a.tmzone_uid_start_time = astz.tmzone_uid (+)
               AND a.tmzone_uid_end_time = aetz.tmzone_uid (+)
               AND a.mloc_uid = nvl((SELECT ml.mloc_uid 
                                       FROM monitoring_location ml 
                                       WHERE ml.mloc_id = p_mloc_id
                                       AND ml.org_uid = o.org_uid), a.mloc_uid)
               AND a.act_start_date BETWEEN nvl(trunc(p_act_start_date_begin), a.act_start_date) 
                                        AND nvl(trunc(p_act_start_date_end), a.act_start_date)
               AND a.act_id = nvl(p_act_id, a.act_id)
               AND a.act_uid IN
                (SELECT ap.act_uid
                   FROM project p, activity_project ap
                  WHERE p.prj_id = nvl(p_prj_id,p.prj_id)
                    AND p.org_uid = o.org_uid
                    AND ap.prj_uid = p.prj_uid)
               ))) AS "Activity"
       FROM organization o,
            tribe tr
      WHERE upper(o.org_id) = upper(p_org_id)
        AND o.trb_uid = tr.trb_uid (+);  
      
  BEGIN
    -- Check required fields for null values for Query transactions
    IF p_org_id IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_activity',
        p_error_msg => 'Organization Identifier is required',
        p_force_err_yn => 'Y');
    END IF;
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_activity',
        p_error_msg => 'NAAS User Id is required',
        p_force_err_yn => 'Y');
    END IF;
    -- Get count of records to be returned if over 500 records then error on Query request
    IF p_trtyp_uid = lib_pkg.c_trtyp_query THEN
      SELECT COUNT(*)
        INTO v_act_cnt
        FROM activity a,
             organization o
       WHERE upper(o.org_id) = upper(p_org_id)
         AND a.org_uid = o.org_uid
         AND a.mloc_uid = nvl((SELECT ml.mloc_uid 
                             FROM monitoring_location ml 
                            WHERE ml.mloc_id = p_mloc_id
                              AND ml.org_uid = o.org_uid), a.mloc_uid)
         AND a.act_start_date BETWEEN nvl(trunc(p_act_start_date_begin), a.act_start_date) 
                                  AND nvl(trunc(p_act_start_date_end), a.act_start_date)
         AND a.act_id = nvl(p_act_id, a.act_id)
         AND a.act_uid IN (SELECT ap.act_uid
                             FROM project p, activity_project ap
                            WHERE p.prj_id = nvl(p_prj_id,p.prj_id)
                              AND p.org_uid = o.org_uid
                              AND ap.prj_uid = p.prj_uid);
       IF v_act_cnt > 500 THEN
         lib_pkg.raise_error( 
           p_context => NULL,
           p_source => 'xml_query_pkg.get_activity',
           p_error_msg => 'Your query exceeded the 500 records allowed for a Query, please use Solicit.',
           p_force_err_yn => 'Y');
       END IF;
    END IF;
    v_xmlclob := create_xml_clob();
    OPEN c_xml;
    LOOP
      FETCH c_xml
        INTO v_xmltype;
      EXIT WHEN c_xml%NOTFOUND;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    END LOOP;
    dbms_lob.CLOSE(v_xmlclob);
    RETURN v_xmlclob;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_activity',
        p_force_err_yn => 'Y'); 
          
  END get_activity;
  
  /****************************************************************************************
    Return XML document containing Activities and Results that match the criteria passed in
    This only returns data that the user has access to 
   ****************************************************************************************/  
  FUNCTION get_result (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_mloc_id               IN monitoring_location.mloc_id%TYPE := NULL,
    p_prj_id                IN project.prj_id%TYPE := NULL,
    p_act_id                IN activity.act_id%TYPE := NULL,
    p_act_start_date_begin  IN activity.act_start_date%TYPE := NULL,
    p_act_start_date_end    IN activity.act_start_date%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE)
    
    RETURN CLOB IS
  
    v_xmltype   xmltype;
    v_xmlclob   CLOB;
    v_result_cnt NUMBER;
  
    CURSOR c_xml IS
      SELECT xmlelement("WQX", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_WQX_v1.0.xsd' AS "xsi:schemaLocation"), 
              xmlelement("Organization",
                xmlelement("OrganizationDescription", 
                  xmlelement("OrganizationIdentifier", o.org_id), 
                  xmlelement("OrganizationFormalName", o.org_name), 
                  xmlelement("OrganizationDescriptionText", o.org_desc), 
                  xmlelement("TribalCode", tr.trb_cd)), 
                (SELECT xmlagg(
                  xmlelement("Activity",
                    xmlelement("ActivityDescription",
                      xmlelement("ActivityIdentifier", a.act_id),
                      xmlelement("ActivityTypeCode", 
                        (SELECT at.actyp_cd 
                           FROM activity_type at
                          WHERE at.actyp_uid = a.actyp_uid)),
                      xmlelement("ActivityMediaName", 
                        (SELECT am.acmed_name
                           FROM activity_media am
                          WHERE am.acmed_uid = a.acmed_uid)),
                      xmlelement("ActivityMediaSubdivisionName",
                        (SELECT ams.amsub_name
                           FROM activity_media_subdivision ams
                          WHERE ams.amsub_uid = a.amsub_uid)),
                      xmlelement("ActivityStartDate", to_char(a.act_start_date,'YYYY-MM-DD')),
                      xmlelement("ActivityStartTime", 
                        xmlelement("Time", to_char(a.act_start_time,'HH24:MI:SS')),
                        xmlelement("TimeZoneCode",astz.tmzone_cd)),
                      xmlelement("ActivityEndDate", to_char(a.act_end_date,'YYYY-MM-DD')),
                      xmlelement("ActivityEndTime",
                        xmlelement("Time", to_char(a.act_end_time,'HH24:MI:SS')),
                        xmlelement("TimeZoneCode",aetz.tmzone_cd)),
                      xmlelement("ActivityRelativeDepthName", 
                        (SELECT rd.reldpth_name
                           FROM relative_depth rd
                          WHERE rd.reldpth_uid = a.reldpth_uid)),
                      xmlelement("ActivityDepthHeightMeasure",
                        xmlelement("MeasureValue", a.act_depth_height),
                        xmlelement("MeasureUnitCode", 
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = a.msunt_uid_depth_height))),
                      xmlelement("ActivityTopDepthHeightMeasure",
                        xmlelement("MeasureValue", a.act_depth_height_top),
                        xmlelement("MeasureUnitCode",
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = a.msunt_uid_depth_height_top))),
                      xmlelement("ActivityBottomDepthHeightMeasure",
                        xmlelement("MeasureValue", a.act_depth_height_bottom),
                        xmlelement("MeasureUnitCode",
                          (SELECT mu.msunt_cd
                             FROM measurement_unit mu
                            WHERE mu.msunt_uid = a.msunt_uid_depth_height_bottom))),
                      xmlelement("ActivityDepthAltitudeReferencePointText", a.act_depth_altitude_ref_point),
                      (SELECT xmlagg(
                        xmlelement("ProjectIdentifier", p.prj_id))
                         FROM project p,
                              activity_project ap
                        WHERE ap.act_uid = a.act_uid
                          AND ap.prj_uid = p.prj_uid),
                      xmlelement("ActivityConductingOrganizationText", 
                        (SELECT aco.acorg_name
                             FROM activity_conducting_org aco
                             WHERE aco.org_uid = o.org_uid
                               AND aco.act_uid = a.act_uid)),
                      xmlelement("ActivityCommentText", a.act_comments)),
                    xmlelement("ActivityLocation",
                      xmlelement("LatitudeMeasure", a.act_loc_latitude),
                      xmlelement("LongitudeMeasure", a.act_loc_longitude),
                      xmlelement("SourceMapScaleNumeric", a.act_loc_source_map_scale),
                      xmlelement("HorizontalCollectionMethodName", 
                        (SELECT hcm.hcmth_name
                           FROM horizontal_collection_method hcm
                          WHERE hcm.hcmth_uid = a.hcmth_uid)),
                      xmlelement("HorizontalCoordinateReferenceSystemDatumName",
                        (SELECT hrd.hrdat_name
                           FROM horizontal_reference_datum hrd
                          WHERE hrd.hrdat_uid = a.hrdat_uid))),
                    xmlelement("SampleDescription",
                      xmlelement("SampleCollectionMethod",
                        xmlelement("MethodIdentifier", a.act_sam_collect_meth_id),
                        xmlelement("MethodIdentifierContext", a.act_sam_collect_meth_context),
                        xmlelement("MethodName", a.act_sam_collect_meth_name),
                        xmlelement("MethodQualifierTypeName", a.act_sam_collect_meth_qual_type),
                        xmlelement("MethodDescriptionText", a.act_sam_collect_meth_desc)),
                      xmlelement("SampleTissueTaxonomicName",
                        (SELECT t.tax_name
                           FROM taxon t
                          WHERE t.tax_uid = a.tax_uid)),
                      xmlelement("SampleTissueAnatomyName",
                        (SELECT sta.stant_name
                           FROM sample_tissue_anatomy sta
                          WHERE sta.stant_uid = a.stant_uid)),
                      xmlelement("SampleCollectionEquipmentName", 
                        (SELECT sce.sceqp_name
                           FROM sample_collection_equip sce
                          WHERE sce.sceqp_uid = a.sceqp_uid)),
                      xmlelement("SampleCollectionEquipmentCommentText", a.act_sam_collect_equip_comments),
                      xmlelement("SamplePreparation",
                        xmlelement("SamplePreparationMethod",
                          xmlelement("MethodIdentifier", a.act_sam_prep_meth_id),
                          xmlelement("MethodIdentifierContext", a.act_sam_prep_meth_context),
                          xmlelement("MethodName", a.act_sam_prep_meth_name),
                          xmlelement("MethodQualifierTypeName", a.act_sam_prep_meth_qual_type),
                          xmlelement("MethodDescriptionText", a.act_sam_prep_meth_desc)),
                        xmlelement("SampleContainerTypeName", 
                          (SELECT ct.contyp_name
                             FROM container_type ct
                            WHERE ct.contyp_uid = a.contyp_uid)),
                        xmlelement("SampleContainerColorName",
                          (SELECT cc.concol_name
                             FROM container_color cc
                            WHERE cc.concol_uid = a.concol_uid)),
                        xmlelement("ChemicalPreservativeUsedName", a.act_sam_chemical_preservative),
                        xmlelement("ThermalPreservativeUsedName",
                          (SELECT tp.thprsv_name
                             FROM thermal_preservative tp
                            WHERE tp.thprsv_uid = a.thprsv_uid)),
                        xmlelement("SampleTransportStorageDescription", a.act_sam_transport_storage_desc))),
                      (SELECT xmlagg(
                        xmlelement("AttachedBinaryObject",
                          xmlelement("BinaryObjectFileName",ao.atobj_file_name),
                          xmlelement("BinaryObjectFileTypeCode", ao.atobj_type)))
                           FROM attached_object ao
                          WHERE ao.org_uid = a.org_uid
                            AND ao.tbl_uid = lib_pkg.c_tbl_activity
                            AND ao.ref_uid = a.mloc_uid),
                            -----Start Results-----
                       (SELECT xmlagg(
                          xmlelement("Result", 
                            xmlelement("ResultDescription",
                              xmlelement("DataLoggerLineName", r.res_data_logger_line),
                              xmlelement("ResultDetectionConditionText",
                                (SELECT rdc.rdcnd_name
                                   FROM result_detection_condition rdc
                                  WHERE rdc.rdcnd_uid = r.rdcnd_uid)),
                              xmlelement("CharacteristicName",
                                (SELECT c.chr_name
                                   FROM characteristic c
                                  WHERE c.chr_uid = r.chr_uid)),
                              xmlelement("ResultSampleFractionText",
                                (SELECT sf.smfrc_name
                                   FROM sample_fraction sf
                                  WHERE sf.smfrc_uid = r.smfrc_uid)),
                              xmlelement("ResultMeasure",
                                xmlelement("ResultMeasureValue", r.res_measure),
                                xmlelement("MeasureUnitCode",
                                  (SELECT mu.msunt_cd
                                     FROM measurement_unit mu
                                    WHERE mu.msunt_uid = r.msunt_uid_measure)),
                                xmlelement("MeasureQualifierCode", 
                                  (SELECT rmq.rmqlf_cd
                                     FROM result_measure_qualifier rmq
                                    WHERE rmq.rmqlf_uid = r.rmqlf_uid))),
                              xmlelement("ResultStatusIdentifier",
                                (SELECT rs.ressta_name
                                   FROM result_status rs
                                  WHERE rs.ressta_uid = r.ressta_uid)),
                              xmlelement("StatisticalBaseCode",
                                (SELECT rsb.rsbas_cd
                                   FROM result_statistical_base rsb
                                  WHERE rsb.rsbas_uid = r.rsbas_uid)),
                              xmlelement("ResultValueTypeName",
                                (SELECT rvt.rvtyp_name
                                   FROM result_value_type rvt
                                  WHERE rvt.rvtyp_uid = r.rvtyp_uid)),
                              xmlelement("ResultWeightBasisText",
                                (SELECT rwb.rwbas_name
                                   FROM result_weight_basis rwb
                                  WHERE rwb.rwbas_uid = r.rwbas_uid)),
                              xmlelement("ResultTimeBasisText",
                                (SELECT rtb.rtimb_name
                                   FROM result_time_basis rtb
                                  WHERE rtb.rtimb_uid = r.rtimb_uid)),
                              xmlelement("ResultTemperatureBasisText",
                                (SELECT rtemp.rtmpb_name 
                                   FROM result_temperature_basis rtemp
                                  WHERE rtemp.rtmpb_uid = r.rtmpb_uid)),
                              xmlelement("ResultParticleSizeBasisText", r.res_particle_size_basis),
                              xmlelement("DataQuality",
                                xmlelement("PrecisionValue",r.res_measure_precision),
                                xmlelement("BiasValue", r.res_measure_bias),
                                xmlelement("ConfidenceIntervalValue", r.res_measure_conf_interval),
                                xmlelement("UpperConfidenceLimitValue", r.res_measure_upper_conf_limit),
                                xmlelement("LowerConfidenceLimitValue", r.res_measure_lower_conf_limit)),
                              xmlelement("ResultCommentText", r.res_comments),
                              xmlelement("ResultDepthHeightMeasure",
                                xmlelement("MeasureValue", r.res_depth_height),
                                xmlelement("MeasureUnitCode",
                                  (SELECT mu.msunt_cd
                                     FROM measurement_unit mu
                                    WHERE mu.msunt_uid = r.msunt_uid_depth_height))),
                              xmlelement("ResultDepthAltitudeReferencePointText", r.res_depth_altitude_ref_point)),
                            (SELECT xmlagg(
                               xmlelement("AttachedBinaryObject",
                                 xmlelement("BinaryObjectFileName",ao.atobj_file_name),
                                 xmlelement("BinaryObjectFileTypeCode", ao.atobj_type)))
                               FROM attached_object ao
                              WHERE ao.org_uid = r.org_uid
                                AND ao.tbl_uid = lib_pkg.c_tbl_result
                                AND ao.ref_uid = r.res_uid),
                            xmlelement("ResultAnalyticalMethod",
                              xmlelement("MethodIdentifier",
                                (SELECT am.anlmth_id
                                   FROM analytical_method am
                                  WHERE am.anlmth_uid = r.anlmth_uid)),
                              xmlelement("MethodIdentifierContext",
                                (SELECT amc.amctx_cd
                                   FROM analytical_method_context amc,
                                        analytical_method anl
                                  WHERE amc.amctx_uid = anl.amctx_uid
                                    AND anl.anlmth_uid = r.anlmth_uid)),
                              xmlelement("MethodName",
                                (SELECT anl.anlmth_name
                                   FROM analytical_method anl
                                  WHERE anl.anlmth_uid = r.anlmth_uid)),
                              xmlelement("MethodQualifierTypeName",
                                (SELECT anl.anlmth_qual_type
                                   FROM analytical_method anl
                                  WHERE anl.anlmth_uid = r.anlmth_uid)),
                              xmlelement("MethodDescriptionText",
                                (SELECT anl.anlmth_desc
                                   FROM analytical_method anl
                                  WHERE anl.anlmth_uid = r.anlmth_uid))),
                            xmlelement("ResultLabInformation",
                              xmlelement("LaboratoryName", r.res_lab_name),
                              xmlelement("AnalysisStartDate", to_char(r.res_lab_analysis_start_date,'YYYY-MM-DD')),
                              xmlelement("AnalysisStartTime",
                                xmlelement("Time", to_char(r.res_lab_analysis_start_time,'HH24:MI:SS')),
                                xmlelement("TimeZoneCode", lastz.tmzone_cd)),
                              xmlelement("AnalysisEndDate", to_char(r.res_lab_analysis_end_date,'YYYY-MM-DD')),
                              xmlelement("AnalysisEndTime",
                                xmlelement("Time", to_char(r.res_lab_analysis_end_time,'HH24:MI:SS')),
                                xmlelement("TimeZoneCode",laetz.tmzone_cd)),
                              xmlelement("ResultLaboratoryCommentCode",
                                (SELECT rlc.rlcom_cd
                                   FROM result_lab_comment rlc
                                  WHERE rlc.rlcom_uid = r.rlcom_uid)),
                              (SELECT xmlagg(
                                xmlelement("ResultDetectionQuantitationLimit",
                                  xmlelement("DetectionQuantitationLimitTypeName",
                                    (SELECT dqlt.dqltyp_name
                                       FROM detection_quant_limit_type dqlt
                                      WHERE dqlt.dqltyp_uid = rdql.dqltyp_uid
                                        AND rdql.res_uid = r.res_uid)),
                                  xmlelement("DetectionQuantitationLimitMeasure",
                                    xmlelement("MeasureValue", rdql.rdqlmt_measure),
                                    xmlelement("MeasureUnitCode",
                                      (SELECT mu.msunt_cd
                                         FROM measurement_unit mu
                                        WHERE mu.msunt_uid = rdql.msunt_uid
                                          AND rdql.res_uid = r.res_uid)))))
                                 FROM result_detect_quant_limit rdql
                                WHERE rdql.res_uid = r.res_uid)),
                              (SELECT xmlagg(
                                xmlelement("LabSamplePreparation",
                                  xmlelement("LabSamplePreparationMethod",
                                    xmlelement("MethodIdentifier",rlsp.rlsprp_method_id),
                                    xmlelement("MethodIdentifierContext",rlsp.rlsprp_method_context),
                                    xmlelement("MethodName",rlsp.rlsprp_method_name)),
                                  xmlelement("PreparationStartDate",to_char(rlsp.rlsprp_start_date,'YYYY-MM-DD')),
                                  xmlelement("PreparationStartTime",
                                    xmlelement("Time",to_char(rlsp.rlsprp_start_time,'HH24:MI:SS')),
                                    xmlelement("TimeZoneCode",tzs.tmzone_cd)),
                                  xmlelement("PreparationEndDate",to_char(rlsp.rlsprp_end_date,'YYYY-MM-DD')),
                                  xmlelement("PreparationEndTime",
                                    xmlelement("Time",to_char(rlsp.rlsprp_end_time,'HH24:MI:SS')),
                                    xmlelement("TimeZoneCode",tze.tmzone_cd))))
                                 FROM result_lab_sample_prep rlsp,
                                      time_zone tzs,
                                      time_zone tze
                                WHERE rlsp.res_uid = r.res_uid
                                  AND rlsp.tmzone_uid_end_time = tze.tmzone_uid
                                  AND rlsp.tmzone_uid_start_time = tzs.tmzone_uid)))
                              FROM result r,
                                   time_zone lastz,
                                   time_zone laetz
                             WHERE r.act_uid = a.act_uid
                               AND r.tmzone_uid_lab_analysis_start = lastz.tmzone_uid (+)
                               AND r.tmzone_uid_lab_analysis_end = laetz.tmzone_uid (+)
                               AND r.org_uid = o.org_uid) 
                            ----End Results--------
                            ))
              FROM activity a,
                   time_zone astz,
                   time_zone aetz
             WHERE a.org_uid = o.org_uid
               AND a.tmzone_uid_start_time = astz.tmzone_uid (+)
               AND a.tmzone_uid_end_time = aetz.tmzone_uid (+)
               AND a.mloc_uid = nvl((SELECT ml.mloc_uid 
                                   FROM monitoring_location ml 
                                  WHERE ml.mloc_id = p_mloc_id
                                    AND ml.org_uid = o.org_uid), a.mloc_uid)
               AND a.act_start_date BETWEEN nvl(trunc(p_act_start_date_begin), a.act_start_date) 
                                        AND nvl(trunc(p_act_start_date_end), a.act_start_date)
               AND a.act_id = nvl(p_act_id, a.act_id)
               AND a.act_uid IN
                (SELECT ap.act_uid
                   FROM project p, activity_project ap
                  WHERE p.prj_id = nvl(p_prj_id,p.prj_id)
                    AND p.org_uid = o.org_uid
                    AND ap.prj_uid = p.prj_uid)
               ))) AS "Activity"
       FROM organization o,
            tribe tr
      WHERE o.org_id = upper(p_org_id)
        AND o.trb_uid = tr.trb_uid (+); 
      
  BEGIN
    -- Check required fields for null values for Query transactions
    IF p_org_id IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_result',
        p_error_msg => 'Organization Identifier is required',
        p_force_err_yn => 'Y');
    END IF;
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_result',
        p_error_msg => 'NAAS User Id is required',
        p_force_err_yn => 'Y');
    END IF;
    -- Get count of records to be returned if over 500 records then error on Query request
    IF p_trtyp_uid = lib_pkg.c_trtyp_query THEN
      SELECT COUNT(*)
        INTO v_result_cnt
        FROM activity a,
             organization o
        WHERE o.org_id = upper(p_org_id)
          AND a.org_uid = o.org_uid
          AND a.mloc_uid = nvl((SELECT ml.mloc_uid 
                                FROM monitoring_location ml 
                                WHERE ml.mloc_id = p_mloc_id
                                AND ml.org_uid = o.org_uid), a.mloc_uid)
        AND a.act_start_date BETWEEN nvl(trunc(p_act_start_date_begin), a.act_start_date) 
                                 AND nvl(trunc(p_act_start_date_end), a.act_start_date)
        AND a.act_id = nvl(p_act_id,a.act_id)
        AND a.act_uid IN
                (SELECT ap.act_uid
                   FROM project p, activity_project ap
                  WHERE p.prj_id = nvl(p_prj_id,p.prj_id)
                    AND p.org_uid = o.org_uid
                    AND ap.prj_uid = p.prj_uid);
        
      IF v_result_cnt > 500 THEN
         lib_pkg.raise_error( 
           p_context => NULL,
           p_source => 'xml_query_pkg.get_result',
           p_error_msg => 'Your query exceeded the 500 records allowed for a Query, please use Solicit.',
           p_force_err_yn => 'Y');
       END IF;  
    END IF;
    v_xmlclob := create_xml_clob();
    OPEN c_xml;
    LOOP
      FETCH c_xml
        INTO v_xmltype;
      EXIT WHEN c_xml%NOTFOUND;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    END LOOP;
    dbms_lob.CLOSE(v_xmlclob);
    RETURN v_xmlclob;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_transaction_result',
        p_force_err_yn => 'Y'); 
        
  END get_result;
  
  /****************************************************************************************
    This fucnction takes three incoming parameters, p_org_id(req), p_agtyp_name, and p_actgrp_id.  
    It returns XML output of all the WQX Activity Groups based on the user input.  
    It uses a temporary CLOB table to store the XML and returns the CLOB to the caller.
   ****************************************************************************************/  
  FUNCTION get_activity_group (
    p_trtyp_uid             IN transaction_type.trtyp_uid%TYPE,
    p_org_id                IN organization.org_id%TYPE,
    p_agtyp_name            IN activity_group_type.agtyp_name%TYPE := NULL,
    p_actgrp_id             IN activity_group.actgrp_id%TYPE := NULL,
    p_usr_naas_id_from_cdx  IN user_list.usr_naas_id%TYPE
  ) RETURN CLOB IS
    
    v_xmltype  xmltype;
    v_xmlclob  CLOB;
    
    CURSOR c_xml IS
      SELECT xmlelement("WQX", xmlattributes('http://www.exchangenetwork.net/schema/wqx/1' AS "xmlns",
                                             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                             'http://www.exchangenetwork.net/schema/wqx/1 http://www.exchangenetwork.net/schema/wqx/1/0/WQX_WQX_v1.0.xsd' AS "xsi:schemaLocation"),
              xmlelement("Organization",
                xmlelement("OrganizationDescription", 
                  xmlelement("OrganizationIdentifier", o.org_id), 
                  xmlelement("OrganizationFormalName", o.org_name), 
                  xmlelement("OrganizationDescriptionText", o.org_desc), 
                  xmlelement("TribalCode", t.trb_cd)),
                (SELECT xmlagg(xmlelement("ActivityGroup", 
                    xmlelement("ActivityGroupIdentifier", ag.actgrp_id), 
                    xmlelement("ActivityGroupName", ag.actgrp_name), 
                    xmlelement("ActivityGroupTypeCode", agtyp.agtyp_name), 
                    (SELECT xmlagg(xmlelement("ActivityIdentifier", a.act_id))
                       FROM activity_group_detail agd, activity a
                      WHERE agd.org_uid = o.org_uid
                        AND agd.actgrp_uid = ag.actgrp_uid
                        AND agd.act_uid = a.act_uid)))
                    FROM activity_group ag, activity_group_type agtyp
                   WHERE ag.org_uid = o.org_uid
                     AND ag.actgrp_id = nvl(p_actgrp_id,ag.actgrp_id)
                     AND agtyp.agtyp_name = nvl(p_agtyp_name,agtyp.agtyp_name)))) AS "ActivityGroup"
        FROM organization o,
             tribe t
       WHERE o.org_id = upper(p_org_id)
         AND o.trb_uid = t.trb_uid (+);
  BEGIN
    -- Check required fields for null values for Query transactions
    IF p_org_id IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_activity_group',
        p_error_msg => 'Organization Identifier is required',
        p_force_err_yn => 'Y');
    END IF;
    IF p_usr_naas_id_from_cdx IS NULL THEN
      lib_pkg.raise_error( 
        p_context => NULL,
        p_source => 'xml_query_pkg.get_activity_group',
        p_error_msg => 'NAAS User Id is required',
        p_force_err_yn => 'Y');
    END IF;
    v_xmlclob := create_xml_clob();
    OPEN c_xml;
    LOOP
      FETCH c_xml
        INTO v_xmltype;
      EXIT WHEN c_xml%NOTFOUND;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    END LOOP;
    dbms_lob.CLOSE(v_xmlclob);
    RETURN v_xmlclob;
    
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_activity_group',
        p_force_err_yn => 'Y'); 
          
  END get_activity_group;
  
  /****************************************************************************************
    This fucnction returns XML output of the processing report for a Submit.  
    It uses a temporary CLOB table to store the XML and returns the CLOB to the caller.
   ****************************************************************************************/  
  FUNCTION get_processing_report(
    p_trlog_uid         IN transaction_log.trlog_uid%TYPE,
    p_wqx_node_version  IN VARCHAR) 

    RETURN CLOB IS 
  
    v_xmltype               xmltype;
    v_xmlclob               CLOB;
    v_wqx_database_version  VARCHAR2(10) := lib_pkg.get_version;
    --v_timestamp VARCHAR2(50);
    
    CURSOR c_xml IS
      SELECT xmlelement("Notify", xmlattributes('http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                                                 'notification.xsd' AS "xsi:noNamespaceSchemaLocation"),
        xmlelement("Status", upper(ts.trsta_name)),
        xmlelement("Operation", 'Submit'),
        xmlelement("DataFlow", 'WQX'),
        xmlelement("Timestamp", to_char(tl.trlog_end_time, 'YYYY-MM-DD"T"HH24:MI:SS.SSSSSSS') || SESSIONTIMEZONE),
        xmlelement("TransactionID", tl.trlog_trans_id),
        xmlelement("flowSpecificInfo",
          xmlelement("ProcessingReport", 
            xmlelement("ProcessingSoftware", xmlattributes(p_wqx_node_version AS "Version"), 'WQX Node'),
            xmlelement("ProcessingSoftware", xmlattributes(v_wqx_database_version AS "Version"), 'WQX Database'),
            xmlelement("Counts",
              (SELECT xmlelement("Error", count(tld.tldet_uid))
                 FROM transaction_log_detail tld 
                 WHERE tld.tldtyp_uid = lib_pkg.c_tldtyp_error
                 AND tld.trlog_uid = tl.trlog_uid),
               (SELECT xmlelement("Warning", COUNT(tld.tldet_uid))
                  FROM transaction_log_detail tld
                  WHERE tld.tldtyp_uid = lib_pkg.c_tldtyp_warning
                  AND tld.trlog_uid = tl.trlog_uid),
               (SELECT xmlagg(xmlelement("Project", xmlattributes(at.audtyp_name AS "Action"), COUNT(tla.tlaud_uid)))
                  FROM transaction_log_audit tla, audit_type at, transaction_log tlog
                  WHERE tlog.trlog_uid = p_trlog_uid
                  AND tla.trlog_uid = tlog.trlog_uid
                  AND tla.audtyp_uid = at.audtyp_uid
                  AND tla.tbl_uid = lib_pkg.c_tbl_project
                  AND tla.tlaud_success_yn = 'Y'
                  GROUP BY at.audtyp_name),
                (SELECT xmlagg(xmlelement("MonitoringLocation", xmlattributes(at.audtyp_name AS "Action"), COUNT(tla.tlaud_uid)))
                  FROM transaction_log_audit tla, audit_type at, transaction_log tlog
                  WHERE tlog.trlog_uid = p_trlog_uid
                  AND tla.trlog_uid = tlog.trlog_uid
                  AND tla.audtyp_uid = at.audtyp_uid
                  AND tla.tbl_uid = lib_pkg.c_tbl_monitoring_location
                  AND tla.tlaud_success_yn = 'Y'                  
                  GROUP BY at.audtyp_name),
                (SELECT xmlagg(xmlelement("Activity", xmlattributes(at.audtyp_name AS "Action"), COUNT(tla.tlaud_uid)))
                  FROM transaction_log_audit tla, audit_type at, transaction_log tlog
                  WHERE tlog.trlog_uid = p_trlog_uid
                  AND tla.trlog_uid = tlog.trlog_uid
                  AND tla.audtyp_uid = at.audtyp_uid
                  AND tla.tbl_uid = lib_pkg.c_tbl_activity
                  AND tla.tlaud_success_yn = 'Y'
                  GROUP BY at.audtyp_name),
                (SELECT xmlagg(xmlelement("ActivityGroup", xmlattributes(at.audtyp_name AS "Action"), COUNT(tla.tlaud_uid)))
                  FROM transaction_log_audit tla, audit_type at, transaction_log tlog
                  WHERE tlog.trlog_uid = p_trlog_uid
                  AND tla.trlog_uid = tlog.trlog_uid
                  AND tla.audtyp_uid = at.audtyp_uid
                  AND tla.tbl_uid = lib_pkg.c_tbl_activity_group
                  AND tla.tlaud_success_yn = 'Y'
                  GROUP BY at.audtyp_name),  
                (SELECT xmlagg(xmlelement("Result", xmlattributes(at.audtyp_name AS "Action"), COUNT(tla.tlaud_uid)))
                  FROM transaction_log_audit tla, audit_type at, transaction_log tlog
                  WHERE tlog.trlog_uid = p_trlog_uid
                  AND tla.trlog_uid = tlog.trlog_uid
                  AND tla.audtyp_uid = at.audtyp_uid
                  AND tla.tbl_uid = lib_pkg.c_tbl_result
                  AND tla.tlaud_success_yn = 'Y'
                  GROUP BY at.audtyp_name)),
            xmlelement("Log",
              (SELECT xmlagg(xmlelement("LogDetail",
                               xmlelement("Type", tldtyp.tldtyp_name),
                               xmlelement("Text", tldet.tldet_msg),
                               xmlelement("Context", tldet.tldet_context))) 
                 FROM (SELECT * 
                        FROM transaction_log_detail 
                        ORDER BY tldet_uid) tldet, 
                        transaction_log tlog, 
                        transaction_log_detail_type tldtyp
                 WHERE tlog.trlog_uid = p_trlog_uid
                 AND tldet.trlog_uid = tlog.trlog_uid
                 AND tldet.tldtyp_uid = tldtyp.tldtyp_uid)),
            xmlelement("ProcessingFailures",
              (SELECT xmlagg(xmlelement("ProjectIdentifier", tlaud.ref_id))
                 FROM transaction_log_audit tlaud
                WHERE tl.trlog_uid = p_trlog_uid
                  AND tlaud.trlog_uid = tl.trlog_uid
                  AND tlaud.tbl_uid = lib_pkg.c_tbl_project
                  AND tlaud.tlaud_success_yn = 'N'),
              (SELECT xmlagg(xmlelement("MonitoringLocationIdentifier", tlaud.ref_id))
                 FROM transaction_log_audit tlaud
                WHERE tl.trlog_uid = p_trlog_uid
                  AND tlaud.trlog_uid = tl.trlog_uid
                  AND tlaud.tbl_uid = lib_pkg.c_tbl_monitoring_location
                  AND tlaud.tlaud_success_yn = 'N'),
              (SELECT xmlagg(xmlelement("ActivityIdentifier", tlaud.ref_id))
                 FROM transaction_log_audit tlaud
                WHERE tl.trlog_uid = p_trlog_uid
                  AND tlaud.trlog_uid = tl.trlog_uid
                  AND tlaud.tbl_uid = lib_pkg.c_tbl_activity
                  AND tlaud.tlaud_success_yn = 'N'),
              (SELECT xmlagg(xmlelement("ActivityGroupIdentifier", tlaud.ref_id))
                 FROM transaction_log_audit tlaud
                WHERE tl.trlog_uid = p_trlog_uid
                  AND tlaud.trlog_uid = tl.trlog_uid
                  AND tlaud.tbl_uid = lib_pkg.c_tbl_activity_group
                  AND tlaud.tlaud_success_yn = 'N'))))) AS "ProcessReport"
      FROM transaction_log tl, transaction_status ts
      WHERE tl.trlog_uid = p_trlog_uid
        AND tl.trsta_uid = ts.trsta_uid;
    
  BEGIN
    v_xmlclob := create_xml_clob();
    OPEN c_xml;
      FETCH c_xml
        INTO v_xmltype;
      dbms_lob.append(v_xmlclob, v_xmltype.getclobval());
    dbms_lob.CLOSE(v_xmlclob);
    
    RETURN v_xmlclob;
  
  EXCEPTION
    WHEN OTHERS THEN
      lib_pkg.raise_error(
        p_context => NULL,
        p_source => 'xml_query_pkg.get_processing_report',
        p_force_err_yn => 'Y'); 
  
  END get_processing_report;
  
END xml_query_pkg;
/


spool off
