----------------------------------------------
-- Export file for user WQX                 --
-- Created by ryanj on 9/6/2006, 2:53:06 PM --
----------------------------------------------

prompt
prompt Creating table MONITORING_LOCATION
prompt ==================================
prompt
create table MONITORING_LOCATION
(
  MLOC_UID              NUMBER(20) not null,
  CNTY_UID              NUMBER(6),
  CNTRY_UID             NUMBER(6),
  HCMTH_UID             NUMBER(6) not null,
  HRDAT_UID             NUMBER(6) not null,
  MLTYP_UID             NUMBER(6) not null,
  MSUNT_UID             NUMBER(6),
  ORG_UID               NUMBER(20) not null,
  ST_UID                NUMBER(6),
  VCMTH_UID             NUMBER(6),
  VRDAT_UID             NUMBER(6),
  MLOC_ID               VARCHAR2(35) not null,
  MLOC_NAME             VARCHAR2(255) not null,
  MLOC_DESC             VARCHAR2(1999),
  MLOC_HUC_8            VARCHAR2(8),
  MLOC_HUC_12           VARCHAR2(12),
  MLOC_LATITUDE         NUMBER not null,
  MLOC_LONGITUDE        NUMBER not null,
  MLOC_SOURCE_MAP_SCALE NUMBER(8),
  MLOC_TRIBAL_LAND_YN   VARCHAR2(1),
  MLOC_TRIBAL_LAND_NAME VARCHAR2(200),
  MLOC_VERTICAL_MEASURE VARCHAR2(12),
  MLOC_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&LARGE_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
    pctincrease 0
  );
alter table MONITORING_LOCATION
  add constraint MLOC_PK primary key (MLOC_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table MONITORING_LOCATION
  add constraint MLOC_CNTRY_FK foreign key (CNTRY_UID)
  references COUNTRY (CNTRY_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_CNTY_FK foreign key (CNTY_UID)
  references COUNTY (CNTY_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_HCMTH_FK foreign key (HCMTH_UID)
  references HORIZONTAL_COLLECTION_METHOD (HCMTH_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_HRDAT_FK foreign key (HRDAT_UID)
  references HORIZONTAL_REFERENCE_DATUM (HRDAT_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_MLTYP_FK foreign key (MLTYP_UID)
  references MONITORING_LOCATION_TYPE (MLTYP_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_MSUNT_FK foreign key (MSUNT_UID)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_ST_FK foreign key (ST_UID)
  references STATE (ST_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_VCMTH_FK foreign key (VCMTH_UID)
  references VERTICAL_COLLECTION_METHOD (VCMTH_UID);
alter table MONITORING_LOCATION
  add constraint MLOC_VRDAT_FK foreign key (VRDAT_UID)
  references VERTICAL_REFERENCE_DATUM (VRDAT_UID);
create unique index MLOC_ID_UPPER_UK on MONITORING_LOCATION (ORG_UID, UPPER(MLOC_ID))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index MLOC_ORG_FK_IDX on MONITORING_LOCATION (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY
prompt =======================
prompt
create table ACTIVITY
(
  ACT_UID                        NUMBER(20) not null,
  ACMED_UID                      NUMBER(6) not null,
  ACTYP_UID                      NUMBER(6) not null,
  AMSUB_UID                      NUMBER(6),
  HCMTH_UID                      NUMBER(6),
  HRDAT_UID                      NUMBER(6),
  MLOC_UID                       NUMBER(20),
  MSUNT_UID_DEPTH_HEIGHT         NUMBER(6),
  MSUNT_UID_DEPTH_HEIGHT_TOP     NUMBER(6),
  MSUNT_UID_DEPTH_HEIGHT_BOTTOM  NUMBER(6),
  ORG_UID                        NUMBER(20) not null,
  RELDPTH_UID                    NUMBER(6),
  TMZONE_UID_START_TIME          NUMBER(6),
  TMZONE_UID_END_TIME            NUMBER(6),
  ACT_ID                         VARCHAR2(35) not null,
  ACT_COMMENTS                   VARCHAR2(4000),
  ACT_START_DATE                 DATE not null,
  ACT_START_TIME                 DATE,
  ACT_END_DATE                   DATE,
  ACT_END_TIME                   DATE,
  ACT_DEPTH_HEIGHT               VARCHAR2(12),
  ACT_DEPTH_HEIGHT_TOP           VARCHAR2(12),
  ACT_DEPTH_HEIGHT_BOTTOM        VARCHAR2(12),
  ACT_DEPTH_ALTITUDE_REF_POINT   VARCHAR2(125),
  ACT_LOC_LATITUDE               NUMBER,
  ACT_LOC_LONGITUDE              NUMBER,
  ACT_LOC_SOURCE_MAP_SCALE       NUMBER(8),
  CONCOL_UID                     NUMBER(6),
  CONTYP_UID                     NUMBER(6),
  SCEQP_UID                      NUMBER(6),
  STANT_UID                      NUMBER(6),
  TAX_UID                        NUMBER(6),
  THPRSV_UID                     NUMBER(6),
  ACT_SAM_CHEMICAL_PRESERVATIVE  VARCHAR2(250),
  ACT_SAM_COLLECT_METH_ID        VARCHAR2(20),
  ACT_SAM_COLLECT_METH_CONTEXT   VARCHAR2(120),
  ACT_SAM_COLLECT_METH_NAME      VARCHAR2(120),
  ACT_SAM_COLLECT_METH_QUAL_TYPE VARCHAR2(25),
  ACT_SAM_COLLECT_METH_DESC      VARCHAR2(500),
  ACT_SAM_COLLECT_EQUIP_COMMENTS VARCHAR2(4000),
  ACT_SAM_PREP_METH_ID           VARCHAR2(20),
  ACT_SAM_PREP_METH_CONTEXT      VARCHAR2(120),
  ACT_SAM_PREP_METH_NAME         VARCHAR2(120),
  ACT_SAM_PREP_METH_QUAL_TYPE    VARCHAR2(25),
  ACT_SAM_PREP_METH_DESC         VARCHAR2(500),
  ACT_SAM_TRANSPORT_STORAGE_DESC VARCHAR2(250),
  ACT_LAST_CHANGE_DATE           TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&LARGE_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_HUGE_TABLE
    minextents 1
    maxextents unlimited
    pctincrease 0
  );
comment on column ACTIVITY.CONCOL_UID
  is 'Sample Only';
comment on column ACTIVITY.CONTYP_UID
  is 'Sample Only';
comment on column ACTIVITY.SCEQP_UID
  is 'Sample Only';
comment on column ACTIVITY.STANT_UID
  is 'Sample Only';
comment on column ACTIVITY.TAX_UID
  is 'Sample Only';
comment on column ACTIVITY.THPRSV_UID
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_COLLECT_METH_ID
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_COLLECT_METH_CONTEXT
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_COLLECT_METH_NAME
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_COLLECT_METH_QUAL_TYPE
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_COLLECT_METH_DESC
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_PREP_METH_ID
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_PREP_METH_CONTEXT
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_PREP_METH_NAME
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_PREP_METH_QUAL_TYPE
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_PREP_METH_DESC
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_TRANSPORT_STORAGE_DESC
  is 'Sample Only';
comment on column ACTIVITY.ACT_SAM_CHEMICAL_PRESERVATIVE
  is 'Sample Only';
alter table ACTIVITY
  add constraint ACT_PK primary key (ACT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY
  add constraint ACT_ACMED_FK foreign key (ACMED_UID)
  references ACTIVITY_MEDIA (ACMED_UID);
alter table ACTIVITY
  add constraint ACT_ACTYP_FK foreign key (ACTYP_UID)
  references ACTIVITY_TYPE (ACTYP_UID);
alter table ACTIVITY
  add constraint ACT_AMSUB_FK foreign key (AMSUB_UID)
  references ACTIVITY_MEDIA_SUBDIVISION (AMSUB_UID);
alter table ACTIVITY
  add constraint ACT_CONCOL_FK foreign key (CONCOL_UID)
  references CONTAINER_COLOR (CONCOL_UID);
alter table ACTIVITY
  add constraint ACT_CONTYP_FK foreign key (CONTYP_UID)
  references CONTAINER_TYPE (CONTYP_UID);
alter table ACTIVITY
  add constraint ACT_HCMTH_FK foreign key (HCMTH_UID)
  references HORIZONTAL_COLLECTION_METHOD (HCMTH_UID);
alter table ACTIVITY
  add constraint ACT_HRDAT_FK foreign key (HRDAT_UID)
  references HORIZONTAL_REFERENCE_DATUM (HRDAT_UID);
alter table ACTIVITY
  add constraint ACT_MLOC_FK foreign key (MLOC_UID)
  references MONITORING_LOCATION (MLOC_UID);
alter table ACTIVITY
  add constraint ACT_MSUNT_DEPTH_HEIGHT_BOTM_FK foreign key (MSUNT_UID_DEPTH_HEIGHT_BOTTOM)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table ACTIVITY
  add constraint ACT_MSUNT_DEPTH_HEIGHT_FK foreign key (MSUNT_UID_DEPTH_HEIGHT)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table ACTIVITY
  add constraint ACT_MSUNT_DEPTH_HEIGHT_TOP_FK foreign key (MSUNT_UID_DEPTH_HEIGHT_TOP)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table ACTIVITY
  add constraint ACT_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table ACTIVITY
  add constraint ACT_RELDPTH_FK foreign key (RELDPTH_UID)
  references RELATIVE_DEPTH (RELDPTH_UID);
alter table ACTIVITY
  add constraint ACT_SCEQP_FK foreign key (SCEQP_UID)
  references SAMPLE_COLLECTION_EQUIP (SCEQP_UID);
alter table ACTIVITY
  add constraint ACT_STANT_FK foreign key (STANT_UID)
  references SAMPLE_TISSUE_ANATOMY (STANT_UID);
alter table ACTIVITY
  add constraint ACT_TAX_FK foreign key (TAX_UID)
  references TAXON (TAX_UID);
alter table ACTIVITY
  add constraint ACT_THPRSV_FK foreign key (THPRSV_UID)
  references THERMAL_PRESERVATIVE (THPRSV_UID);
alter table ACTIVITY
  add constraint ACT_TMZONE_END_TIME_FK foreign key (TMZONE_UID_END_TIME)
  references TIME_ZONE (TMZONE_UID);
alter table ACTIVITY
  add constraint ACT_TMZONE_START_TIME_FK foreign key (TMZONE_UID_START_TIME)
  references TIME_ZONE (TMZONE_UID);
create unique index ACT_ID_UPPER_UK on ACTIVITY (UPPER(ACT_ID), ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index ACT_MLOC_FK_IDX on ACTIVITY (MLOC_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index ACT_ORG_FK_IDX on ACTIVITY (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_CONDUCTING_ORG
prompt ======================================
prompt
create table ACTIVITY_CONDUCTING_ORG
(
  ACT_UID                NUMBER(20) not null,
  ORG_UID                NUMBER(20) not null,
  ACORG_NAME             VARCHAR2(120) not null,
  ACORG_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_CONDUCTING_ORG
  add constraint ACORG_PK primary key (ACT_UID, ACORG_NAME)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_CONDUCTING_ORG
  add constraint ACORG_ACT_FK foreign key (ACT_UID)
  references ACTIVITY (ACT_UID);
alter table ACTIVITY_CONDUCTING_ORG
  add constraint ACORG_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);

prompt
prompt Creating table ACTIVITY_GROUP
prompt =============================
prompt
create table ACTIVITY_GROUP
(
  ACTGRP_UID              NUMBER(20) not null,
  AGTYP_UID               NUMBER(6) not null,
  ORG_UID                 NUMBER(20) not null,
  ACTGRP_ID               VARCHAR2(35) not null,
  ACTGRP_NAME             VARCHAR2(50),
  ACTGRP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_GROUP
  add constraint ACTGRP_PK primary key (ACTGRP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_GROUP
  add constraint ACTGRP_AGTYP_FK foreign key (AGTYP_UID)
  references ACTIVITY_GROUP_TYPE (AGTYP_UID);
alter table ACTIVITY_GROUP
  add constraint ACTGRP_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
create unique index ACTGRP_ID_UPPER_UK on ACTIVITY_GROUP (ORG_UID, UPPER(ACTGRP_ID))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_GROUP_DETAIL
prompt ====================================
prompt
create table ACTIVITY_GROUP_DETAIL
(
  ACTGRP_UID             NUMBER(20) not null,
  ACT_UID                NUMBER(20) not null,
  ORG_UID                NUMBER(20) not null,
  AGDET_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_GROUP_DETAIL
  add constraint AGDET_PK primary key (ACTGRP_UID, ACT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_GROUP_DETAIL
  add constraint AGDET_ACTGRP_FK foreign key (ACTGRP_UID)
  references ACTIVITY_GROUP (ACTGRP_UID);
alter table ACTIVITY_GROUP_DETAIL
  add constraint AGDET_ACT_FK foreign key (ACT_UID)
  references ACTIVITY (ACT_UID);
alter table ACTIVITY_GROUP_DETAIL
  add constraint AGDET_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);

prompt
prompt Creating table PROJECT
prompt ======================
prompt
create table PROJECT
(
  PRJ_UID              NUMBER(20) not null,
  ORG_UID              NUMBER(20) not null,
  PRJ_ID               VARCHAR2(35) not null,
  PRJ_NAME             VARCHAR2(120) not null,
  PRJ_DESC             VARCHAR2(1999),
  PRJ_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table PROJECT
  add constraint PRJ_PK primary key (PRJ_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table PROJECT
  add constraint PRJ_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
create unique index PRJ_ID_UPPER_UK on PROJECT (ORG_UID, UPPER(PRJ_ID))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
create index PRJ_ORG_FK_IDX on PROJECT (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ACTIVITY_PROJECT
prompt ===============================
prompt
create table ACTIVITY_PROJECT
(
  ACT_UID                 NUMBER(20) not null,
  PRJ_UID                 NUMBER(20) not null,
  ORG_UID                 NUMBER(20) not null,
  ACTPRJ_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_PROJECT
  add constraint ACT_PRJ_PK primary key (ACT_UID, PRJ_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ACTIVITY_PROJECT
  add constraint ACT_PRJ_ACT_FK foreign key (ACT_UID)
  references ACTIVITY (ACT_UID);
alter table ACTIVITY_PROJECT
  add constraint ACT_PRJ_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table ACTIVITY_PROJECT
  add constraint ACT_PRJ_PRJ_FK foreign key (PRJ_UID)
  references PROJECT (PRJ_UID);
create index ACT_PRJ_ACT_FK_IDX on ACTIVITY_PROJECT (ACT_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index ACT_PRJ_PRJ_FK_IDX on ACTIVITY_PROJECT (PRJ_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ATTACHED_OBJECT
prompt ==============================
prompt
create table ATTACHED_OBJECT
(
  ATOBJ_UID              NUMBER(20) not null,
  ORG_UID                NUMBER(20) not null,
  REF_UID                NUMBER(20) not null,
  TBL_UID                NUMBER(6) not null,
  ATOBJ_FILE_NAME        VARCHAR2(255) not null,
  ATOBJ_TYPE             VARCHAR2(6) not null,
  ATOBJ_CONTENT          BLOB not null,
  ATOBJ_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&LARGE_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_HUGE_TABLE
    minextents 1
    maxextents unlimited
    pctincrease 0
  );
alter table ATTACHED_OBJECT
  add constraint ATOBJ_PK primary key (ATOBJ_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ATTACHED_OBJECT
  add constraint ATOBJ_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table ATTACHED_OBJECT
  add constraint ATOBJ_TBL_FK foreign key (TBL_UID)
  references TABLE_LIST (TBL_UID);
create unique index ATOBJ_FILE_NAME_UPPER_UK on ATTACHED_OBJECT (REF_UID, TBL_UID, UPPER(ATOBJ_FILE_NAME))
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
  
prompt
prompt Creating table MONITORING_LOCATION_ALTERNATE
prompt ============================================
prompt
create table MONITORING_LOCATION_ALTERNATE
(
  MLOC_UID               NUMBER(20) not null,
  ORG_UID                NUMBER(20) not null,
  MLALT_ID               VARCHAR2(35) not null,
  MLALT_CONTEXT          VARCHAR2(120) not null,
  MLALT_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table MONITORING_LOCATION_ALTERNATE
  add constraint MLALT_PK primary key (MLOC_UID, MLALT_ID, MLALT_CONTEXT)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table MONITORING_LOCATION_ALTERNATE
  add constraint MLALT_MLOC_FK foreign key (MLOC_UID)
  references MONITORING_LOCATION (MLOC_UID);
alter table MONITORING_LOCATION_ALTERNATE
  add constraint MLALT_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);

prompt
prompt Creating table ORG_ADDRESS
prompt ==========================
prompt
create table ORG_ADDRESS
(
  ORGADD_UID                  NUMBER(20) not null,
  ADDTYP_UID                  NUMBER(6) not null,
  CNTRY_UID                   NUMBER(6),
  CNTY_UID                    NUMBER(6),
  ORG_UID                     NUMBER(20) not null,
  ST_UID                      NUMBER(6),
  ORGADD_ADDRESS              VARCHAR2(50) not null,
  ORGADD_ADDRESS_SUPPLEMENTAL VARCHAR2(120),
  ORGADD_LOCALITY_NAME        VARCHAR2(30),
  ORGADD_POSTAL_CD            VARCHAR2(10),
  ORGADD_LAST_CHANGE_DATE     TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ORG_ADDRESS
  add constraint ORGADD_PK primary key (ORGADD_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ORG_ADDRESS
  add constraint ORGADD_ADDTYP_FK foreign key (ADDTYP_UID)
  references ADDRESS_TYPE (ADDTYP_UID);
alter table ORG_ADDRESS
  add constraint ORGADD_CNTRY_FK foreign key (CNTRY_UID)
  references COUNTRY (CNTRY_UID);
alter table ORG_ADDRESS
  add constraint ORGADD_CNTY_FK foreign key (CNTY_UID)
  references COUNTY (CNTY_UID);
alter table ORG_ADDRESS
  add constraint ORGADD_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table ORG_ADDRESS
  add constraint ORGADD_ST_FK foreign key (ST_UID)
  references STATE (ST_UID);
create index ORGADD_ORG_FK_IDX on ORG_ADDRESS (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ORG_ELECTRONIC_ADDRESS
prompt =====================================
prompt
create table ORG_ELECTRONIC_ADDRESS
(
  ORGEA_UID              NUMBER(20) not null,
  EATYP_UID              NUMBER(6) not null,
  ORG_UID                NUMBER(20) not null,
  ORGEA_TEXT             VARCHAR2(120) not null,
  ORGEA_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ORG_ELECTRONIC_ADDRESS
  add constraint ORGEA_PK primary key (ORGEA_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ORG_ELECTRONIC_ADDRESS
  add constraint ORGEA_EATYP_FK foreign key (EATYP_UID)
  references ELECTRONIC_ADDRESS_TYPE (EATYP_UID);
alter table ORG_ELECTRONIC_ADDRESS
  add constraint ORGEA_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
create index ORGEA_ORG_FK_IDX on ORG_ELECTRONIC_ADDRESS (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table ORG_PHONE
prompt ========================
prompt
create table ORG_PHONE
(
  ORGPH_UID              NUMBER(20) not null,
  ORG_UID                NUMBER(20) not null,
  PHTYP_UID              NUMBER(6) not null,
  ORGPH_NUM              VARCHAR2(15) not null,
  ORGPH_EXT              VARCHAR2(6),
  ORGPH_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table ORG_PHONE
  add constraint ORGPH_PK primary key (ORGPH_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table ORG_PHONE
  add constraint ORGPH_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table ORG_PHONE
  add constraint ORGPH_PHTYP_FK foreign key (PHTYP_UID)
  references PHONE_TYPE (PHTYP_UID);
create index ORGPH_ORG_FK_IDX on ORG_PHONE (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT
prompt =====================
prompt
create table RESULT
(
  RES_UID                       NUMBER(20) not null,
  ACT_UID                       NUMBER(20) not null,
  ANLMTH_UID                    NUMBER(6),
  CHR_UID                       NUMBER(6),
  CPLVAL_UID                    NUMBER(6),
  MSUNT_UID_DEPTH_HEIGHT        NUMBER(6),
  MSUNT_UID_MEASURE             NUMBER(6),
  ORG_UID                       NUMBER(20) not null,
  RDCND_UID                     NUMBER(6),
  RESSTA_UID                    NUMBER(6),
  RLCOM_UID                     NUMBER(6),
  RMQLF_UID                     NUMBER(6),
  RSBAS_UID                     NUMBER(6),
  RTIMB_UID                     NUMBER(6),
  RTMPB_UID                     NUMBER(6),
  RVTYP_UID                     NUMBER(6),
  RWBAS_UID                     NUMBER(6),
  SMFRC_UID                     NUMBER(6),
  TMZONE_UID_LAB_ANALYSIS_START NUMBER(6),
  TMZONE_UID_LAB_ANALYSIS_END   NUMBER(6),
  RES_COMMENTS                  VARCHAR2(4000),
  RES_DATA_LOGGER_LINE          VARCHAR2(15),
  RES_DEPTH_HEIGHT              VARCHAR2(12),
  RES_DEPTH_ALTITUDE_REF_POINT  VARCHAR2(125),
  RES_LAB_ANALYSIS_START_DATE   DATE,
  RES_LAB_ANALYSIS_START_TIME   DATE,
  RES_LAB_ANALYSIS_END_DATE     DATE,
  RES_LAB_ANALYSIS_END_TIME     DATE,
  RES_LAB_NAME                  VARCHAR2(60),
  RES_MEASURE                   VARCHAR2(60),
  RES_MEASURE_BIAS              VARCHAR2(60),
  RES_MEASURE_CONF_INTERVAL     VARCHAR2(15),
  RES_MEASURE_PRECISION         VARCHAR2(60),
  RES_MEASURE_LOWER_CONF_LIMIT  VARCHAR2(15),
  RES_MEASURE_UPPER_CONF_LIMIT  VARCHAR2(15),
  RES_PARTICLE_SIZE_BASIS       VARCHAR2(15),
  RES_LAST_CHANGE_DATE          TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&LARGE_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_HUGE_TABLE
    minextents 1
    maxextents unlimited
    pctincrease 0
  );
alter table RESULT
  add constraint RES_PK primary key (RES_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table RESULT
  add constraint RES_ACT_FK foreign key (ACT_UID)
  references ACTIVITY (ACT_UID);
alter table RESULT
  add constraint RES_ANLMTH_FK foreign key (ANLMTH_UID)
  references ANALYTICAL_METHOD (ANLMTH_UID);
alter table RESULT
  add constraint RES_CHR_FK foreign key (CHR_UID)
  references CHARACTERISTIC (CHR_UID);
alter table RESULT
  add constraint RES_CPLVAL_FK foreign key (CPLVAL_UID)
  references CHARACTERISTIC_PICK_LIST_VALUE (CPLVAL_UID);
alter table RESULT
  add constraint RES_MSUNT_DEPTH_HEIGHT_FK foreign key (MSUNT_UID_DEPTH_HEIGHT)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table RESULT
  add constraint RES_MSUNT_MEASURE_FK foreign key (MSUNT_UID_MEASURE)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table RESULT
  add constraint RES_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table RESULT
  add constraint RES_RDCND_FK foreign key (RDCND_UID)
  references RESULT_DETECTION_CONDITION (RDCND_UID);
alter table RESULT
  add constraint RES_RLCOM_FK foreign key (RLCOM_UID)
  references RESULT_LAB_COMMENT (RLCOM_UID);
alter table RESULT
  add constraint RES_RSBAS_FK foreign key (RSBAS_UID)
  references RESULT_STATISTICAL_BASE (RSBAS_UID);
alter table RESULT
  add constraint RES_RSTA_FK foreign key (RESSTA_UID)
  references RESULT_STATUS (RESSTA_UID);
alter table RESULT
  add constraint RES_RTIMB_FK foreign key (RTIMB_UID)
  references RESULT_TIME_BASIS (RTIMB_UID);
alter table RESULT
  add constraint RES_RTMPB_FK foreign key (RTMPB_UID)
  references RESULT_TEMPERATURE_BASIS (RTMPB_UID);
alter table RESULT
  add constraint RES_RVTYP_FK foreign key (RVTYP_UID)
  references RESULT_VALUE_TYPE (RVTYP_UID);
alter table RESULT
  add constraint RES_RWBAS_FK foreign key (RWBAS_UID)
  references RESULT_WEIGHT_BASIS (RWBAS_UID);
alter table RESULT
  add constraint RES_SFRC_FK foreign key (SMFRC_UID)
  references SAMPLE_FRACTION (SMFRC_UID);
alter table RESULT
  add constraint RES_TMZONE_LAB_ANL_END_FK foreign key (TMZONE_UID_LAB_ANALYSIS_END)
  references TIME_ZONE (TMZONE_UID);
alter table RESULT
  add constraint RES_TMZONE_LAB_ANL_START_FK foreign key (TMZONE_UID_LAB_ANALYSIS_START)
  references TIME_ZONE (TMZONE_UID);
create index RES_ACT_FK_IDX on RESULT (ACT_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index RES_ORG_FK_IDX on RESULT (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_DETECT_QUANT_LIMIT
prompt ========================================
prompt
create table RESULT_DETECT_QUANT_LIMIT
(
  RDQLMT_UID              NUMBER(20) not null,
  DQLTYP_UID              NUMBER(6),
  MSUNT_UID               NUMBER(6),
  ORG_UID                 NUMBER(20) not null,
  RES_UID                 NUMBER(20) not null,
  RDQLMT_MEASURE          VARCHAR2(12),
  RDQLMT_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table RESULT_DETECT_QUANT_LIMIT
  add constraint RDQLMT_PK primary key (RDQLMT_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table RESULT_DETECT_QUANT_LIMIT
  add constraint RDQLMT_DQLTYP_FK foreign key (DQLTYP_UID)
  references DETECTION_QUANT_LIMIT_TYPE (DQLTYP_UID);
alter table RESULT_DETECT_QUANT_LIMIT
  add constraint RDQLMT_MSUNT_FK foreign key (MSUNT_UID)
  references MEASUREMENT_UNIT (MSUNT_UID);
alter table RESULT_DETECT_QUANT_LIMIT
  add constraint RDQLMT_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table RESULT_DETECT_QUANT_LIMIT
  add constraint RDQLMT_RES_FK foreign key (RES_UID)
  references RESULT (RES_UID);
create index RDQLMT_ORG_FK_IDX on RESULT_DETECT_QUANT_LIMIT (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index RDQLMT_RES_FK_IDX on RESULT_DETECT_QUANT_LIMIT (RES_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table RESULT_LAB_SAMPLE_PREP
prompt =====================================
prompt
create table RESULT_LAB_SAMPLE_PREP
(
  RLSPRP_UID              NUMBER(20) not null,
  ORG_UID                 NUMBER(20) not null,
  RES_UID                 NUMBER(20) not null,
  TMZONE_UID_START_TIME   NUMBER(6),
  TMZONE_UID_END_TIME     NUMBER(6),
  RLSPRP_METHOD_ID        VARCHAR2(20) not null,
  RLSPRP_METHOD_CONTEXT   VARCHAR2(120) not null,
  RLSPRP_METHOD_NAME      VARCHAR2(120) not null,
  RLSPRP_METHOD_DESC      VARCHAR2(500),
  RLSPRP_METHOD_QUAL_TYPE VARCHAR2(25),
  RLSPRP_START_DATE       DATE,
  RLSPRP_START_TIME       DATE,
  RLSPRP_END_DATE         DATE,
  RLSPRP_END_TIME         DATE,
  RLSPRP_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&LARGE_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table RESULT_LAB_SAMPLE_PREP
  add constraint RLSPRP_PK primary key (RLSPRP_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table RESULT_LAB_SAMPLE_PREP
  add constraint RLSPRP_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table RESULT_LAB_SAMPLE_PREP
  add constraint RLSPRP_RES_FK foreign key (RES_UID)
  references RESULT (RES_UID);
alter table RESULT_LAB_SAMPLE_PREP
  add constraint RLSPRP_TMZONE_END_TIME_FK foreign key (TMZONE_UID_END_TIME)
  references TIME_ZONE (TMZONE_UID);
alter table RESULT_LAB_SAMPLE_PREP
  add constraint RLSPRP_TMZONE_START_TIME_FK foreign key (TMZONE_UID_START_TIME)
  references TIME_ZONE (TMZONE_UID);
create index RLSPRP_ORG_FK_IDX on RESULT_LAB_SAMPLE_PREP (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index RLSPRP_RES_FK_IDX on RESULT_LAB_SAMPLE_PREP (RES_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table USER_LIST
prompt ========================
prompt
create table USER_LIST
(
  USR_UID              NUMBER(6) not null,
  USR_NAAS_ID          VARCHAR2(100) not null,
  USR_COMMENTS         VARCHAR2(200),
  USR_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table USER_LIST
  add constraint USR_PK primary key (USR_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
create unique index USR_NAAS_ID_UPPER_UK on USER_LIST (UPPER(USR_NAAS_ID))
  tablespace &&MAIN_TABLESPACE
  pctfree 2
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_LOG
prompt ==============================
prompt
create table TRANSACTION_LOG
(
  TRLOG_UID        NUMBER(20) not null,
  ORG_UID          NUMBER(20),
  TRSTA_UID        NUMBER(6) not null,
  TRTYP_UID        NUMBER(6) not null,
  USR_UID          NUMBER(6),
  TRLOG_TRANS_ID   VARCHAR2(100),
  TRLOG_DOC_ID     VARCHAR2(100),
  TRLOG_START_TIME TIMESTAMP(6) not null,
  TRLOG_END_TIME   TIMESTAMP(6),
  TRLOG_OTHER      VARCHAR2(500)
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG
  add constraint TRLOG_PK primary key (TRLOG_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 0
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG
  add constraint TRLOG_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table TRANSACTION_LOG
  add constraint TRLOG_TRSTA_FK foreign key (TRSTA_UID)
  references TRANSACTION_STATUS (TRSTA_UID);
alter table TRANSACTION_LOG
  add constraint TRLOG_TRTYP_FK foreign key (TRTYP_UID)
  references TRANSACTION_TYPE (TRTYP_UID);
alter table TRANSACTION_LOG
  add constraint TRLOG_USR_FK foreign key (USR_UID)
  references USER_LIST (USR_UID);
create index TRLOG_ORG_FK_IDX on TRANSACTION_LOG (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index TRLOG_TRSTA_FK_IDX on TRANSACTION_LOG (TRSTA_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_HEADER
prompt =================================
prompt
create table TRANSACTION_HEADER
(
  TRLOG_UID            NUMBER(20) not null,
  ORG_UID              NUMBER(20) not null,
  TRHEAD_ID            VARCHAR2(40),
  TRHEAD_AUTHOR        VARCHAR2(100) not null,
  TRHEAD_COMMENT       VARCHAR2(1000),
  TRHEAD_CONTACT_INFO  VARCHAR2(300) not null,
  TRHEAD_CREATION_TIME TIMESTAMP(6) WITH TIME ZONE not null,
  TRHEAD_OPERATION     VARCHAR2(20) not null,
  TRHEAD_ORG_NAME      VARCHAR2(100) not null,
  TRHEAD_SCHEMA_REF    VARCHAR2(40),
  TRHEAD_TITLE         VARCHAR2(100) not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_TABLE
    minextents 1
    maxextents unlimited
  );
comment on column TRANSACTION_HEADER.TRHEAD_ID
  is 'Attribute on Document';
comment on column TRANSACTION_HEADER.TRHEAD_OPERATION
  is 'Attribute on Payload';
alter table TRANSACTION_HEADER
  add constraint TRHEAD_PK primary key (TRLOG_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_HEADER
  add constraint TRHEAD_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table TRANSACTION_HEADER
  add constraint TRHEAD_TRLOG_FK foreign key (TRLOG_UID)
  references TRANSACTION_LOG (TRLOG_UID) on delete cascade;
create index TRHEAD_ORG_FK_IDX on TRANSACTION_HEADER (ORG_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_LOG_AUDIT
prompt ====================================
prompt
create table TRANSACTION_LOG_AUDIT
(
  TLAUD_UID        NUMBER(20) not null,
  AUDTYP_UID       NUMBER(6) not null,
  ORG_UID          NUMBER(20),
  REF_UID          NUMBER(20),
  TBL_UID          NUMBER(6) not null,
  TRLOG_UID        NUMBER(20) not null,
  REF_ID           VARCHAR2(35),
  TLAUD_SUCCESS_YN VARCHAR2(1) default 'P' not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_HUGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG_AUDIT
  add constraint TLAUD_PK primary key (TLAUD_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG_AUDIT
  add constraint TLAUD_AUDTYP_FK foreign key (AUDTYP_UID)
  references AUDIT_TYPE (AUDTYP_UID);
alter table TRANSACTION_LOG_AUDIT
  add constraint TLAUD_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table TRANSACTION_LOG_AUDIT
  add constraint TLAUD_TBL_FK foreign key (TBL_UID)
  references TABLE_LIST (TBL_UID);
alter table TRANSACTION_LOG_AUDIT
  add constraint TLAUD_TRLOG_FK foreign key (TRLOG_UID)
  references TRANSACTION_LOG (TRLOG_UID);
create index TLAUD_TRLOG_IDX on TRANSACTION_LOG_AUDIT (TRLOG_UID, TBL_UID, AUDTYP_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
create index TLAUD_SUCCESS_IDX on TRANSACTION_LOG_AUDIT (tlaud_success_yn, trlog_uid)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table TRANSACTION_LOG_DETAIL
prompt =====================================
prompt
create table TRANSACTION_LOG_DETAIL
(
  TLDET_UID     NUMBER(20) not null,
  ORG_UID       NUMBER(20),
  TLDTYP_UID    NUMBER(6) not null,
  TRLOG_UID     NUMBER(20) not null,
  TLDET_MSG     VARCHAR2(1000),
  TLDET_SOURCE  VARCHAR2(100),
  TLDET_CONTEXT VARCHAR2(500)
)
tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_HUGE_TABLE
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG_DETAIL
  add constraint TLDET_PK primary key (TLDET_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );
alter table TRANSACTION_LOG_DETAIL
  add constraint TLDET_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table TRANSACTION_LOG_DETAIL
  add constraint TLDET_TLDTYP_FK foreign key (TLDTYP_UID)
  references TRANSACTION_LOG_DETAIL_TYPE (TLDTYP_UID);
alter table TRANSACTION_LOG_DETAIL
  add constraint TLDET_TRLOG_FK foreign key (TRLOG_UID)
  references TRANSACTION_LOG (TRLOG_UID);
create index TLDET_TRLOG_IDX on TRANSACTION_LOG_DETAIL (TRLOG_UID, TLDTYP_UID)
  tablespace &&MAIN_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_LARGE_INDEX
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table USER_ORG_ACCESS
prompt ==============================
prompt
create table USER_ORG_ACCESS
(
  USR_UID                NUMBER(6) not null,
  ORG_UID                NUMBER(20) not null,
  ACCTYP_UID             NUMBER(6) not null,
  UOACC_LAST_CHANGE_DATE TIMESTAMP(6) default SYSTIMESTAMP not null
)
tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 1
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_TABLE
    minextents 1
    maxextents unlimited
  );
alter table USER_ORG_ACCESS
  add constraint UOACC_PK primary key (USR_UID, ORG_UID)
  using index 
  tablespace &&MAIN_TABLESPACE
  pctfree 5
  initrans 2
  maxtrans 255
  storage
  (
    initial &&INIT_SIZE_MEDIUM_INDEX
    minextents 1
    maxextents unlimited
  );
alter table USER_ORG_ACCESS
  add constraint UOACC_ACCTYP_FK foreign key (ACCTYP_UID)
  references ACCESS_TYPE (ACCTYP_UID);
alter table USER_ORG_ACCESS
  add constraint UOACC_ORG_FK foreign key (ORG_UID)
  references ORGANIZATION (ORG_UID);
alter table USER_ORG_ACCESS
  add constraint UOACC_USR_FK foreign key (USR_UID)
  references USER_LIST (USR_UID);

prompt
prompt Creating table XML_CLOB
prompt =======================
prompt
create global temporary table XML_CLOB
(
  CLOB_CONTENT CLOB
)
on commit delete rows;

prompt
prompt Creating sequence ACTGRP_SEQ
prompt ============================
prompt
create sequence ACTGRP_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ACT_SEQ
prompt =========================
prompt
create sequence ACT_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence AMCTX_SEQ
prompt ===========================
prompt
create sequence AMCTX_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ANLMTH_SEQ
prompt ============================
prompt
create sequence ANLMTH_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ATOBJ_SEQ
prompt ===========================
prompt
create sequence ATOBJ_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence MLOC_SEQ
prompt ==========================
prompt
create sequence MLOC_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ORGADD_SEQ
prompt ============================
prompt
create sequence ORGADD_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ORGEA_SEQ
prompt ===========================
prompt
create sequence ORGEA_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ORGPH_SEQ
prompt ===========================
prompt
create sequence ORGPH_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence ORG_SEQ
prompt =========================
prompt
create sequence ORG_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence PRJ_SEQ
prompt =========================
prompt
create sequence PRJ_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence RDQLMT_SEQ
prompt ============================
prompt
create sequence RDQLMT_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence RES_SEQ
prompt =========================
prompt
create sequence RES_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence RLSPRP_SEQ
prompt ============================
prompt
create sequence RLSPRP_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence TLAUD_SEQ
prompt ===========================
prompt
create sequence TLAUD_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence TLDET_SEQ
prompt ===========================
prompt
create sequence TLDET_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence TRLOG_SEQ
prompt ===========================
prompt
create sequence TRLOG_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;

prompt
prompt Creating sequence USR_SEQ
prompt =========================
prompt
create sequence USR_SEQ
minvalue 1
maxvalue 999999999999999999999999999
start with 1
increment by 1
nocache;
